/*
   PXKFontManager.m

   NSFontManager for GNUstep GUI X/DPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: February 1997
   A completely rewritten version of the original source of Scott Christley.
   
   This file is part of the GNUstep GUI X/DPS Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include "config.h"

#include <DPS/psops.h>
#include <DPS/PSres.h>

#include <Foundation/NSDictionary.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSString.h>
#include <gnustep/xdps/PXKFontManager.h>
#include <gnustep/xdps/PXKFontPanel.h>
#include <gnustep/xdps/PXKFont.h>
#include "fonts.h"

@implementation PXKFontManager

+ (void)initialize
{
    // Initial version
    [self setVersion:1];

    // Set the factories
    [self setFontManagerFactory:[PXKFontManager class]];
    [self setFontPanelFactory:[PXKFontPanel class]];
}

@end

@implementation PXKFontManager (GNUstepBackend)

/* It would be probably more portable to use the standard PS resource
   enumerator functions, but the makepsres utility does not understand how
   DGS organize its resources. So we use the below techniques to identify
   the font and AFM files.

   For Adobe DPS implementations I use the PS resources because it's more
   portable.
 */

static int
afmEnumerator (char* resourceType, char* resourceName, char* resourceFile,
	       char* self)
{
  NSString* fontName = [NSString stringWithCString:resourceName];
  NSString* afmFileName = [NSString stringWithCString:resourceFile];

  [PXKFont makeKnownFontName:fontName fileName:afmFileName];
  [((NSMutableArray*)((PXKFontManager*)self)->fontsList) addObject:fontName];

  return 0;
}

- (void)enumerateFontsAndFamilies
{
  char product[255];
  NSString* productName;

  PSWProduct (product);
  productName = [NSString stringWithCString:product];

  if ([productName hasPrefix:@"Adobe Display PostScript"]) {
    fontsList = [NSMutableArray new];
    EnumeratePSResourceFiles (NULL, NULL, PSResFontAFM, NULL,
			       afmEnumerator, (char*)self);
    if (![fontsList count])
      NSLog (@"WARNING: No fonts were found! Check if the PSRESOURCEPATH "
	     @"environment variable points to the right directory. If so then "
	     @"probably you did not build the PS resource database using the "
	     @"`makepsres' utility.");
  }
  else if ([productName hasPrefix:@"Aladdin Ghostscript"]) {
    int i, noOfFonts;
    char fontName[FILENAME_MAX + 1], fileOrFont[FILENAME_MAX + 1];
    NSAutoreleasePool* pool = [NSAutoreleasePool new];
    NSMutableDictionary* fontFileDict;
    NSEnumerator* enumerator;
    id key;

    /* We make a dictionary of font name/file name where the font is defined.
	For this purpose we use the functions defined in fonts.psw; see this
	file for more info. */

    /* In the first step we create the dictionary that holds font names as keys
	and font names or file names as values. If the value is a file name
	then the file name contains the definition of the font. The file name
	is not an absolute filename, but we make it absolute in the third step
	of algorithm. If the value is a font name then the the key font name is
	an alias of the value font name.
    */
    PSWFontNames (&noOfFonts);
    fontFileDict = [NSMutableDictionary dictionaryWithCapacity:noOfFonts];
    for (i = 0; i < noOfFonts; i++) {
      PSWGetFontsArray (fontName, fileOrFont);
      [fontFileDict setObject:[NSString stringWithCString:fileOrFont]
		    forKey:[NSString stringWithCString:fontName]];
    }
    /* Pop the mark used by PSWFontNames() function */
    PScleartomark();

    /* In the second step we replace all the values from the dictionary that
	are font aliases with the actual file where the original file is
	defined. We suppose the file names and font names are different. */
    enumerator = [fontFileDict keyEnumerator];
    while ((key = [enumerator nextObject])) {
      id value = [fontFileDict objectForKey:key];
      id filename;

      /* Check to see if value is key in dictionary. If true, the key font is
	  an alias for another font; replace its value with the filename where
	  the font is defined. */
      if ((filename = [fontFileDict objectForKey:value]))
	[fontFileDict setObject:filename forKey:key];
    }

    /* In the third step replace each the file name with the complete path to
       it. */ 
    enumerator = [fontFileDict keyEnumerator];
    while ((key = [enumerator nextObject])) {
      id value = [fontFileDict objectForKey:key];
      char completePath[FILENAME_MAX + 1];
      NSString* fileName;
      int found;
  
      PSWCompleteFilename ([value cString], &found, completePath);
      if (found) {
	NSString* afmFileName;

	fileName = [NSString stringWithCString:completePath];
	afmFileName = [[fileName stringByDeletingPathExtension]
				  stringByAppendingPathExtension:@"afm"];
	[fontFileDict setObject:afmFileName forKey:key];
	[PXKFont makeKnownFontName:key fileName:afmFileName];
      }
    }

    /* Set the font list to the keys of fontFileDict */
    fontsList = [[fontFileDict allKeys] retain];

    [pool release];
  }
}

@end
