/* 
   CompiledTest.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __CompiledTest_h__
#define __CompiledTest_h__

#include <Foundation/NSObject.h>

@class NSString;
@class NSDictionary;
@class EOModel;
@class EOEntity;
@class EOAdaptor;
@class EOAdaptorContext;
@class EOAdaptorChannel;

@interface CompiledTest : NSObject
{
    EOModel*		model;
    NSDictionary*	testDictionary;
    NSString*		mainTestName;
    NSString*		currentTestName;
    NSDictionary*	testInfo;

    EOAdaptor*		adaptor;
    EOAdaptorContext*	adaptorContext;
    EOAdaptorChannel*	adaptorChannel;

    struct {
    	BOOL		verboseMask:1;
	BOOL		breakOnErr:1;
    } flags ;
}

/*
 * Initialization
 */
- initWithTestDict:(NSDictionary*)aTestDict
  modelDict:(NSDictionary*)aModelDict 
  forTest:(NSString*)aTestName;
- (void)runMainTest;

/* 
 * Runs a test 
 *   gets the test info dictionary
 *   invokes test init, run, cleanup methods
 */
- (void)runTest:(NSDictionary*)dict name:(NSString*)name;

/*
 * Test Method
 *   does nothing
 */
- (void)testNothing;

/*
 * Test Method
 *   compound test - runs a list of tests
 *   gets test (array of test names) and invokes runTest for each
 */
- (void)testListOfTests;

/*
 * Init/Cleanup methods
 */
- (void)enableBreakOnError;
- (void)disableBreakOnError;

- (void)enableMessages;
- (void)disableMessages;

/* 
 * Check and log
 */
- (void)check:(BOOL)aFlag format:(NSString*)format, ...;
- (void)logMessage:(NSString*)format, ...;

/*
 * Test info dictionary access
 */
- (NSArray*)rowsForEntity:(EOEntity*)anEntity
  attributes:(NSArray*)attributes values:(NSArray*)values;
- (NSArray*)attributesForEntity:(EOEntity*)entity names:(NSArray*)names;
- (NSArray*)sortOrderingForEntity:(EOEntity*)entity order:(NSArray*)names;

@end

@interface CompiledTest(Adaptor)

/*
 * Adaptor level operations
 */

- (void)initAdaptorObjects;
- (void)doneAdaptorObjects;
- (void)enableAdaptorVerbose;
- (void)disableAdaptorVerbose;

- (void)adaptorModifyEntity;
- (void)adaptorClearEntities;
- (void)adaptorInsertEntity;
- (void)adaptorSelectEntity;
- (void)adaptorUpdateEntity;

@end

@interface CompiledTest(Database)

/*
 * Database level operations
 */

@end

#endif  /* __CompiledTest_h__ */
