/* 
   SybaseAdaptor.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: October 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __SybaseAdaptor_h__
#define __SybaseAdaptor_h__

#include <eoaccess/EOAdaptor.h>

/* define this because sybfront.h also defines BOOL */
#define _OBJC_OBJC_H_

#include <sybfront.h>
#include <sybdb.h>

@class NSMutableArray;
@class NSMutableDictionary;

/* The following keys are meaningful in the connectionDictionary in a model:

   ifacefile - the path to the interface file (default /usr/sybase/interfaces)
   databaseServer or hostName - the name of the server (default SYBASE)
   databaseName - the name of the database to use (no default)
   userName - the name of the user (no default)
   password - the password used to connect to the server (no default)
*/

@interface SybaseAdaptor : EOAdaptor
{
    NSMutableDictionary* typesByName;
    LOGINREC* loginRecord;
    NSMutableArray *dbProcessPool;
    int dbProcessPoolLimit;
    int dbProcessesInUse;
    int maxTextSize;

    BOOL shareDBProcesses:1;
}

/* Logging messages and errors */
+ (void)setLogsMessages:(BOOL)flag;
+ (BOOL)logsMessages;
+ (void)setLogsErrors:(BOOL)flag;
+ (BOOL)logsErrors;

/* Dealing with the timeout to wait for a command completion. */
+ (void)setTimeOutInterval:(int)seconds;
+ (int)timeOutInterval;

/* Dealing with the timeout to wait for login. */
+ (void)setLoginTimeOutInterval:(int)seconds;
+ (int)loginTimeOutInterval;

/* Setting and getting the maximum number of bytes to be returned from a iamge
   field. */
- (void)setMaxTextSizeDefault:(int)textSize;
- (int)maxTextSizeDefault;

/* Getting the Sybase constant that represents a native type */
- (int)typeForName:(NSString*)typeName;

/* Configure the adaptor to share the DBPROCESSes or not. The default is not to
   share DBPROCESSes. */ 
- (void)setShareDBProcesses:(BOOL)flag;
- (BOOL)shareDBProcesses;

/* Setting and getting the maximum number of DBPROCESSes that can be shared by
   this adaptor. */
- (void)setDBProcessPoolLimit:(int)dbProcessPoolLimit;
- (int)dbProcessPoolLimit;

/* Inherited methods */
- (Class)adaptorChannelClass;
- (BOOL)isValidQualifierType:(NSString*)typeName;


// Private methods

/* Obtaining and releasing a DBPROCESS from pool */
- (DBPROCESS*)newDBProcess;
- (void)releaseDBProcess:(DBPROCESS*)dbprocess;

@end

#endif /* __SybaseAdaptor_h__ */
