/* 
   Postgres95Values.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
	      based on the Sybase Adaptor written by 
	   Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: December 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __Postgres95Values_h__
#define __Postgres95Values_h__

#include <Foundation/NSString.h>
#include <Foundation/NSValue.h>
#include <Foundation/NSData.h>
#include <Foundation/NSDate.h>
#include <eoaccess/EONull.h>

@class EOAttribute;
@class Postgres95Channel;

@interface NSString (Postgres95ValueCreation)
+ postgres95ValueFromBytes:(char*)bytes
  length:(int)length
  owned:(BOOL)owned
  attribute:(EOAttribute*)attribute
  adaptorChannel:(Postgres95Channel*)channel
  zone:(NSZone*)zone;
- stringValueForPostgres95Type:(NSString*)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSNumber (Postgres95ValueCreation)
+ postgres95ValueFromBytes:(char*)bytes
  length:(int)length
  owned:(BOOL)owned
  attribute:(EOAttribute*)attribute
  adaptorChannel:(Postgres95Channel*)channel
  zone:(NSZone*)zone;
- stringValueForPostgres95Type:(NSString*)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSData (Postgres95ValueCreation)
+ postgres95ValueFromBytes:(char*)bytes
  length:(int)length
  owned:(BOOL)owned
  attribute:(EOAttribute*)attribute
  adaptorChannel:(Postgres95Channel*)channel
  zone:(NSZone*)zone;
- stringValueForPostgres95Type:(NSString*)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSCalendarDate (Postgres95ValueCreation)
+ postgres95ValueFromBytes:(char*)bytes
  length:(int)length
  owned:(BOOL)owned
  attribute:(EOAttribute*)attribute
  adaptorChannel:(Postgres95Channel*)channel
  zone:(NSZone*)zone;
- stringValueForPostgres95Type:(NSString*)type
  attribute:(EOAttribute*)attribute;
@end

@interface EONull (Postgres95ValueCreation)
- stringValueForPostgres95Type:(NSString*)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSObject (Postgres95ValueCreation)
+ postgres95ValueFromBytes:(char*)bytes
  length:(int)length
  owned:(BOOL)owned
  attribute:(EOAttribute*)attribute
  adaptorChannel:(Postgres95Channel*)channel
  zone:(NSZone*)zone;
- stringValueForPostgres95Type:(NSString*)type
  attribute:(EOAttribute*)attribute;
@end

#endif /* __Postgres95Values_h__ */
