/* 
   common.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Bogdan Baliuc <stark@protv.ro>
   Date: 1995

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <eoaccess/common.h>

#if !LIB_FOUNDATION_LIBRARY

char *Ltoa(long nr, char *str, int base)
{
    char buff[34], rest, is_negative;
    int ptr;

    ptr = 32;
    buff[33] = '\0';
    if(nr < 0) {
	is_negative = 1;
	nr = -nr;
    }
    else
	is_negative = 0;

    while(nr != 0) {
	rest = nr % base;
	if(rest > 9)
	    rest += 'A' - 10;
	else
	    rest += '0';
	buff[ptr--] = rest;
	nr /= base;
    }
    if(ptr == 32)
	buff[ptr--] = '0';
    if(is_negative)
	buff[ptr--] = '-';

    Strcpy(str, &buff[ptr+1]);

    return(str);
}
#endif
