/* 
   GCGenericRecord.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: January 1997

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <extensions/GCArray.h>
#include <extensions/GCDictionary.h>

#include <eoaccess/EOEntity.h>
#include <eoaccess/EODatabase.h>
#include <eoaccess/GCGenericRecord.h>

@implementation GCGenericRecord

- init
{
    [super init];
    values = [[GCMutableDictionary alloc] init];
    return self;
}

- initWithPrimaryKey:(NSDictionary*)aKey entity:(EOEntity*)anEntity
{
    [self init];
    if (!aKey || !anEntity) {
	[self autorelease];
	return nil;
    }
    entity = [anEntity retain];
    [values addEntriesFromDictionary:aKey];
    return self;
}

- (void)gcDecrementRefCountOfContainedObjects
{
    [entity gcDecrementRefCount];
    [(id)values gcDecrementRefCount];
}

- (BOOL)gcIncrementRefCountOfContainedObjects
{
    if(![super gcIncrementRefCountOfContainedObjects])
	return NO;

    [entity gcIncrementRefCount];
    [(id)values gcIncrementRefCount];

    [entity gcIncrementRefCountOfContainedObjects];
    [(id)values gcIncrementRefCountOfContainedObjects];

    return YES;
}

- (void)dealloc
{
    [EODatabase forgetObject:self];
    return [super dealloc];
}

- (EOEntity*)entity
{
    return entity;
}

- (BOOL)takeValuesFromDictionary:(NSDictionary*)dictionary
{
    [values addEntriesFromDictionary:dictionary];
    return YES;
}

- (NSDictionary*)valuesForKeys:(NSArray*)keys
{
    // OPT - cache IMP for objectAtIndex, objectForKey, setObject:forKey:
    int i, n;
    NSMutableDictionary* dict;
    
    n = [keys count];
    dict = [[NSMutableDictionary alloc] initWithCapacity:n];
    
    for (i = 0; i < n; i++) {
	id key = [keys objectAtIndex:i];
    	[dict setObject:[values objectForKey:key] forKey:key];
    }
    
    return dict;
}

- (void)setObject:object forKey:key
{
    [values setObject:object forKey:key];
}

- objectForKey:key
{
    return [values objectForKey:key];
}

- (void)removeObjectForKey:key
{
    [values removeObjectForKey:key];
}

- (NSString*)description
{
    return [NSString stringWithFormat:
	@"<GCGenericRecord: entity %@ values %@",
	[entity name], [values description]];
}

@end
