// $Id: tree.cc,v 1.6 1998/09/24 13:19:50 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"
#include "../Configuration.hh"

void Gtk_Tree::Include(File &f,const Widget &w)
{  f.include("gtk--/tree.h");
   if (Configuration.sample_code) 
   {  f.include("gtk--/treeitem.h");
      f.include("vector");
   }
   Gtk_Container::Include(f,w);
}

void Gtk_Tree::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Tree");
}

void Gtk_Tree::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Tree");
   f << "()";
}

bool Gtk_Tree::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

void Gtk_Tree::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
   string selection_mode(w.getString("selection_mode","GTK_SELECTION_SINGLE"));
   f << instance << "set_selection_mode(" << selection_mode << ");\n\t";
   string view_mode(w.getString("view_mode","GTK_TREE_VIEW_LINE"));
   f << instance << "set_view_mode(" << view_mode << ");\n\t";
   bool view_line(w.getBool("view_line",true));
   f << instance << "set_view_lines(" << (view_line?"true":"false") << ");\n\t";
}

bool Gtk_Tree::SampleCode(File &f,const Widget &w,enum WriterType::CodePosition pos,const string misc)
{  const string name(f.InstanceName(w.Name()));
   switch(pos)
   {  case WriterType::ContainingConstructor:
         {  // insert items
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"alpha\"));\n";
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"beta\"));\n";
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"gamma\"));\n";
            f << "\tfor (vector<Gtk_TreeItem*>::iterator i=" << name 
              << "_items.begin();\n\t\t\ti!=" << name << "_items.end();++i)\n"
              << "\t{\t" << name << (w.isPointer() ? "->" : "." ) 
              						<< "append(*i);\n" 
              << "\t\t(*i)->show();\n"
              << "\t}\n";
            f << "\t" << name << "_items.back()->set_subtree(&" 
              << name << "_sub);\n";
            f << "\t" << name << "_sub.show();\n";
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"epsilon\"));\n";
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"tau\"));\n";
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"rho\"));\n";
            f << "\tfor (vector<Gtk_TreeItem*>::iterator i=" << name 
              << "_items.begin()+3;\n\t\t\ti!=" << name << "_items.end();++i)\n"
              << "\t{\t" << name << "_sub.append(*i);\n"
              << "\t\t(*i)->show();\n"
              << "\t}\n";
   	 }
   	 break;
      case WriterType::ContainingDestructor:
         {  f << "\tfor (vector<Gtk_TreeItem*>::iterator i=" << name 
              << "_items.begin();i!=" << name << "_items.end();++i)\n"
              << "\t\tdelete *i;\n";
         }
         break;
      case WriterType::ContainingPrivateMember:
         {  f << "\tGtk_Tree " << name << "_sub;\n";
            f << "\tvector<Gtk_TreeItem *> " << name << "_items;\n";
         }
         break;
      default: break;
   }
   return false;
}
