// $Id: notebook.cc,v 1.13 1998/09/24 13:19:46 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Notebook::Include(File &f,const Widget &w)
{  f.include("gtk--/label.h");
   f.include("gtk--/notebook.h");
   Gtk_Container::Include(f,w);
}

void Gtk_Notebook::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Notebook");
}

void Gtk_Notebook::DeclareNeeded(File &f,const Widget &w)
{  char n='a';
   for (Widget::const_iterator i=w.begin();i!=w.end();++i,n++)
   {  if (n!='a') f << "\n\t";
      f << "Gtk_Label " << (f.Declaration(w)+"_L"+n) << ";";
   }
}

void Gtk_Notebook::Derive(File &f,const Widget &w)
{  f << "Gtk_Notebook";
}

void Gtk_Notebook::Construct(File &f,const Widget &w,bool is_member)
{  char n='a';
   for (Widget::const_iterator i=w.begin();i!=w.end();++i,n++)
   {  if (n!='a') f << ",\n\t  ";
      f << (f.InstanceName(w.Name())+"_L"+n) << "(\""
        << f.CString((*i).Name()) << "\")";
   }
}

void Gtk_Notebook::ConstructPointer(File &f,const Widget &w)
{  char n='a';
   for (Widget::const_iterator i=w.begin();i!=w.end();++i,n++)
   {  f << "\t" << (f.InstanceName(w.Name())+"_L"+n) << " = new Gtk_Label(\""
        << f.CString((*i).Name()) << "\");\n";
   }
   f << "\t" << f.InstanceName(w.Name()) << " = new Gtk_Notebook();\n";
}

void Gtk_Notebook::DestructPointer(File &f,const Widget &w)
{  char n='a';
   f << "\tdelete " << f.InstanceName(w.Name()) << ";\n";
   for (Widget::const_iterator i=w.begin();i!=w.end();++i,n++)
   {  f << "\tdelete " << (f.InstanceName(w.Name())+"_L"+n) << ";\n";
   }
}

bool Gtk_Notebook::NeedConstruct(const Widget &w,bool is_member)
{  if (w.begin()!=w.end()) return true;
   return false;
}

void Gtk_Notebook::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
   bool show_tabs=w.getBool("show_tabs",true);
   bool show_border=w.getBool("show_border",true);
   string tab_pos=w.getString("tab_pos","GTK_POS_TOP");
   bool scrollable=w.getBool("scrollable",false);
   int tab_border=w.getInt("tab_border",3);
   bool popup_enable=w.getBool("popup_enable",false);
   // 2do: tooltips
   
   if (show_tabs)
      f << instance << "set_show_tabs(" << (show_tabs?"true":"false") << ");\n\t";
   if (!show_border)
      f << instance << "set_show_border(" << (show_border?"true":"false") << ");\n\t";
   if (scrollable)
      f << instance << "set_scrollable(" << (scrollable?"true":"false") << ");\n\t";
   if (popup_enable)
      f << instance << (popup_enable?"popup_enable":"popup_disable") << "();\n\t";
   f << instance << "set_tab_border(" << tab_border << ");\n\t";
   if (tab_pos!="GTK_POS_TOP")
      f << instance << "set_tab_pos(" << tab_pos << ");\n\t";
   
   char n='a';
   for (Widget::const_iterator i=w.begin();i!=w.end();++i,n++)
   {  f << instance << "append_page(&" << f.InstanceName((*i).Name())
        << ", &" << (f.InstanceName(w.Name())+"_L"+n) << ");\n\t";
   }
   // 2do: menu items
}
