// $Id: dialog.cc,v 1.24 1998/09/24 13:19:45 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Dialog::Include(File &f,const Widget &w)
{  f.include("gtk--/dialog.h");
   Gtk_Container::Include(f,w);
}

void Gtk_Dialog::Declare(File &f,const Widget &w)
{  cerr << "Warning: container contains Dialog ???\n";
   StandardWriter::Declare(f,w,"Gtk_Dialog");
}

void Gtk_Dialog::Derive(File &f,const Widget &w)
{  f << "Gtk_Dialog";
}

void Gtk_Dialog::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Dialog");
   f << "()";
}

bool Gtk_Dialog::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

static void PackChildren(File &f,const Widget &w,const string p_inst)
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
      Gtk_Box::PackChild(f,*i,p_inst);
}

static void CustomizeVBox(File &f,const Widget &w,const string instance)
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).ChildName()==string("Dialog:action_area"))
         PackChildren(f,*i,instance+"action_area()->");
      else 
         Gtk_Box::PackChild(f,*i,instance+"vbox()->");
   }
}

void Gtk_Dialog::Customize(File &f,const Widget &w,const string instance)
{  // this is a copy of Gtk_Window::Customize, but since we won't add
   // our child directly we can't invoke it
   Gtk_Container::Customize(f,w,instance);
   string title(w.getString("title",""));
   if (title.size())
      f << instance << "set_title(\"" << f.CString(title) << "\");\n\t";
   string position(w.getString("position",""));
   if (position.size() && position!="GTK_WIN_POS_NONE")
      f << instance << "position(\"" << position << "\");\n\t";
   bool allow_shrink=w.getBool("allow_shrink",false);
   bool allow_grow=w.getBool("allow_grow",true);
   bool auto_shrink=w.getBool("auto_shrink",false);
   if (allow_shrink || !allow_grow || auto_shrink)
      f << instance << "set_policy(" << (allow_shrink?"true":"false")
        << ", " << (allow_grow?"true":"false")
        << ", " << (auto_shrink?"true":"false") << ");\n\t";
   
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).ChildName()==string("Dialog:vbox"))
         CustomizeVBox(f,*i,instance);
      else  
      { cerr<< "Gtk_Dialog::Customize: Unknown attached child\n";
        (*i).debug();
      }
   }
}


WriterType::Subwidget Gtk_Dialog::IsSubwidget(const Widget &w,const Widget &ch)
{  if (ch.ChildName()=="Dialog:vbox") return WriterType::IgnoreButTestChildren;
   if (ch.ChildName()=="Dialog:action_area") return WriterType::IgnoreButAcceptChildren;
   return WriterType::not_Subwidget;
}
