// $Id: clist.cc,v 1.27 1998/10/09 09:41:48 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_CList::Include(File &f,const Widget &w)
{  f.include("gtk--/clist.h");
   Gtk_Container::Include(f,w);
}

void Gtk_CList::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_CList");
}

void Gtk_CList::Derive(File &f,const Widget &w)
{  f << "Gtk_CList";
}

void Gtk_CList::Construct(File &f,const Widget &w,bool is_member)
{  // 2do: look for columns and pass them
   int columns=w.getInt("columns",3);
   f << StandardWriter::ConstructName(f,w,is_member,"Gtk_CList");
   f << "("<< columns << ")";
}

bool Gtk_CList::NeedConstruct(const Widget &w,bool is_member)
{  return true; // doesn't have default constructor
}

void Gtk_CList::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
   string selection_mode=w.getString("selection_mode","GTK_SELECTION_SINGLE");
   bool show_titles=w.getBool("show_titles",true);
   string shadow_type=w.getString("shadow_type","GTK_SHADOW_IN");
   string hscrollbar_policy=w.getString("hscrollbar_policy","GTK_POLICY_AUTOMATIC");
   string vscrollbar_policy=w.getString("vscrollbar_policy","GTK_POLICY_AUTOMATIC");
   // 2do: Tooltips
      
   int i=0;
   for (Widget::const_iterator ch=w.begin();ch!=w.end();++ch,++i)
   {  if ((*ch).Class()=="GtkLabel")
      {  string label=(*ch).getString("label","");
         if (label!="")
            f << instance << "set_column_title(" << i << ", \"" 
              					<< label << "\");\n\t";
         string justify=(*ch).getString("justify","GTK_JUSTIFY_LEFT");
         if (justify!="GTK_JUSTIFY_LEFT")
            f << instance << "set_column_justification(" << i << ", "
              << justify << ");\n\t";
         // column width (glade didn't save it?)
      }
      else
         cerr << "Gtk_CList::Customize: can't handle widget class "
              << (*ch).Class() << " as title\n";
   }
   if (selection_mode!="GTK_SELECTION_SINGLE")
      f << instance << "set_selection_mode(" << selection_mode << ");\n\t";
   if (show_titles)
      f << instance << "column_titles_show();\n\t";
   if (shadow_type!="GTK_SHADOW_IN")
      f << instance << "set_border(" << shadow_type << ");\n\t";
   if (hscrollbar_policy!="GTK_POLICY_ALWAYS" 
   	|| vscrollbar_policy!="GTK_POLICY_ALWAYS")
      f << instance << "set_policy(" << vscrollbar_policy << ", " 
        << hscrollbar_policy << ");\n\t";
}

WriterType::Subwidget Gtk_CList::IsSubwidget(const Widget &w,const Widget &ch)
{  return WriterType::IgnoreTree; // only on labels !
}

bool Gtk_CList::SampleCode(File &f,const Widget &w,enum WriterType::CodePosition pos,const string misc)
{  switch(pos)
   {  case WriterType::ContainingConstructor:
         {  int cols=w.getInt("columns",3);
            int width=w.getInt("width",100);
            if (!cols) return false;
            f << "\tconst gchar *data_" << f.InstanceName(w.Name()) << "[]=\n\t{ ";
            for (int i=0;i<cols;i++)
   	       f << (i?", ":"") << "\"" << i << "\"";
   	    f << " };\n"
   	      << "\t" << f.InstanceName(w.Name()) 
   	      << (w.isPointer() ? "->" : "." ) << "append(data_"
   	      << f.InstanceName(w.Name()) << ");\n";
   	    f << "\tfor (int i=0;i<" << cols << ";++i)\n\t\t"
   	      << f.InstanceName(w.Name()) << (w.isPointer() ? "->" : "." ) 
   	      << "set_column_width(i,"
   	      << width/cols << ");\n";
   	 }
   	 break;
      default: break;
   }
   return false;
}
