// $Id: checkbutton.cc,v 1.6 1998/09/24 13:19:44 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_CheckButton::Include(File &f,const Widget &w)
{  f.include("gtk--/checkbutton.h");
}

void Gtk_CheckButton::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_CheckButton");
}

void Gtk_CheckButton::Construct(File &f,const Widget &w,bool is_member)
{  // 2do if !found("label")
   f << StandardWriter::ConstructName(f,w,is_member,"Gtk_CheckButton");
   f << "(\"" << f.CString(w.getString("label"))
	<< "\")";
}

bool Gtk_CheckButton::NeedConstruct(const Widget &w,bool is_member)
{  return w.hasTag("label");
}

void Gtk_CheckButton::Customize(File &f,const Widget &w,const string instance)
{  Gtk_ToggleButton::Customize(f,w,instance);
}
