/*
    fan_ctrl: a sample program to turn on/off Netwinder Rev5 fan
    Copyright 1998  woody@corelcomputer.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>

#include "therm.h"



main(argc,argv)
     int argc;
     char **argv;
{

	int	fd = 0;
	int	uTemp = 0;
	int	fan_new = 1;	//assume fan to be turned ON
	int	fan_old = 0;
	char*	basename;
	char* 	p;
	struct	THERM_SETTING	old_therm;
	struct	THERM_SETTING	kick_fan;
			
//	printf("\nargc=%d, argv:[0]=%s, [1]=%s.\n\n",
//	    argc,argv[0],argv[1]);
	
	basename = (p = strrchr(argv[0], '/')) ? p+1 : argv[0];
    
	if(argc < 2)
	{
	        fprintf(stderr,"\nNetWinder Fan Control program, Corel Computer 1998.\nUsage: %s ON or OFF.\n\n",
	        basename);
	}
	else if ((strcasecmp(argv[1], "ON")) == 0)
	{
	    fan_new = 1;
	}
	else if ((strcasecmp(argv[1], "OFF")) == 0)
	{
	    fan_new = 0;
	}
	else
	{
	    fprintf(stderr,"%s: unable to parse ON/OFF command (\"%s\")???.\n",
		basename, argv[1]);
	    return -1;	
	}

	fd = open("/dev/temperature", O_RDWR);
	if (fd <0)
	{
		printf("Error %d opening /dev/temperature\n",fd);
		return;
	}
//	else
//	{
//		printf("/dev/temperature open OK, rc = 0x%X.\n",fd);
//	}


	ioctl(fd, CMD_GET_FAN, &fan_old);
	if (!errno)
		printf("Current fan setting: %s.\n",fan_old?"ON":"OFF");
	else
	    printf("Error 0x%X getting fan setting.\n",errno);
			
	if (argc >= 2)
	{
	ioctl(fd, CMD_SET_FAN, &fan_new);
	
	if (!errno)
	    printf("New fan setting: %s.\n",fan_new?"ON":"OFF");
	else
	    printf("Error 0x%X setting the fan.\n",errno);
	}
	
	if ((fan_old != fan_new) && fan_new)	//if turning fan ON
	{	
	//remember the current setting
	ioctl(fd, CMD_GET_THERMOSTATE2, &old_therm);
	
	//temporary set therm at 0
	kick_fan.hi = 1;
	kick_fan.lo = 0;
	ioctl(fd, CMD_SET_THERMOSTATE2, &kick_fan);

	//give the fan a moment to start
	sleep(2);

	//and restore the old thermostat setting
	ioctl(fd, CMD_SET_THERMOSTATE2, &old_therm);
	}

	if (close(fd) != 0)
		printf("Error closing /dev/temperature\n");
}

