#include <stddef.h>
#include <termios.h>

#define KERNEL_NCCS 19

struct kernel_termios
  {
    tcflag_t c_iflag;		/* input mode flags */
    tcflag_t c_oflag;		/* output mode flags */
    tcflag_t c_cflag;		/* control mode flags */
    tcflag_t c_lflag;		/* local mode flags */
    cc_t c_cc[KERNEL_NCCS];	/* control characters */
    cc_t c_line;		/* line discipline */
    speed_t c_ispeed;           /* input speed */
    speed_t c_ospeed;           /* output speed */
  };

/* Put the state of FD into *TERMIOS_P.  */
int
A0getattr (int fd, struct kernel_termios *k_termios)
{
  struct termios termios;
  size_t cnt;
  int retval;

  retval = tcgetattr (fd, &termios);
  k_termios->c_iflag = termios.c_iflag;
  k_termios->c_oflag = termios.c_oflag;
  k_termios->c_cflag = termios.c_cflag;
  k_termios->c_lflag = termios.c_lflag;
  k_termios->c_line = termios.c_line;
  k_termios->c_ispeed = termios.c_ispeed;
  k_termios->c_ospeed = termios.c_ospeed;
  for (cnt = 0; cnt < KERNEL_NCCS; ++cnt)
    k_termios->c_cc[cnt] = termios.c_cc[cnt];

  return retval;
}

/* Put the state of FD into *TERMIOS_P.  */
int
A0setattr (int fd, int optional_actions,
	   const struct kernel_termios *k_termios)
{
  struct termios termios;
  size_t cnt;

  termios.c_iflag = k_termios->c_iflag;
  termios.c_oflag = k_termios->c_oflag;
  termios.c_cflag = k_termios->c_cflag;
  termios.c_lflag = k_termios->c_lflag;
  termios.c_line = k_termios->c_line;
  termios.c_ispeed = k_termios->c_ispeed;
  termios.c_ospeed = k_termios->c_ospeed;
  for (cnt = 0; cnt < KERNEL_NCCS; ++cnt)
    termios.c_cc[cnt] = k_termios->c_cc[cnt];

  return tcsetattr(fd, optional_actions, &termios);
}
