/*
 * $Id: net.c,v 1.12 1998/09/29 21:42:43 gregm Exp $
 * GXSNMP -- An snmp management application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Network specific functions. (not gui related)
 */
#include <config.h>
#include <main.h>
#include "net.h"

#include "structs.h"
#include "protos.h"

static GHashTable   *net_hash = NULL;

/*
 * Internal functions
 */
static void
check_net_hash_table (void)
{
  if (!net_hash)
    net_hash = g_hash_table_new (g_str_hash, g_str_equal);
}

/*
 * Function    : nl_add_network 
 * Description : This function will add a new network to the internal list
 *               of available/known networks. This function does not allocate
 *               a new net_entry for the network, that is the caller's 
 *               responsiblity.
 * Arguments   : network  -- The net_entry structure pointer of the network
 *                           to add.
 * Returns     : The net_entry pointer to the newly added network, or
 *               null on failure.
 */
net_entry *
nl_add_network (net_entry *network)
{
  net_entry    *last;

  g_return_val_if_fail (network != NULL, (net_entry *)NULL);
  check_net_hash_table ();
  last = g_hash_table_lookup (net_hash, network->nl_name);
  if (!last)
    {
      g_hash_table_insert (net_hash, g_strdup (network->nl_name),
			   network);
      return network;
    }
  return (net_entry *)NULL;
}

static int       found = FALSE;
static net_entry *found_node = NULL;

static void
search_for_net (void *key, void *val, void *data)
{
  unsigned long int   net_addr;
  unsigned long int   host_net;
  hosts               *host;
  net_entry           *network;

  host = (hosts *)data;
  network = (net_entry *)val;
  net_addr = inet_netof (network->nl_net);
  host_net = inet_netof (host->hl_addr);
  if (net_addr == host_net)
    {
      found = TRUE;
      found_node = network;
    }
}
static void 
add_net_to_clist (void *key, void *val, void *data)
{
}
/*
 * Function    : nl_populate_net_clist
 * Description : This function will fill in the net clist on the network
 *               panel display. Located here as this module maintains the
 *               network list.
 */
void
nl_populate_net_clist (GtkWidget *parent)
{
  g_return_if_fail (parent != NULL);

  if (net_hash)
    {
      g_hash_table_foreach (net_hash, add_net_to_clist, parent);
    }
}

/*
 * Function    : nl_get_host_net
 */
map_node *
nl_get_host_net (hosts *host)
{
  found      = FALSE;
  found_node = NULL;

  if (net_hash)
    g_hash_table_foreach (net_hash, search_for_net, host);
  else 
    return (map_node *)NULL;

  if (found)
    return (map_node *)found_node->nl_mnode;
  else
    return (map_node *)NULL;
}
/*
 * Function     : nl_del_network
 * Description  : This function will delete a network from the list of
 *                available/known networks. This should also invalidate 
 *                all the nodes pointers to this network.
 * Argument     : network  -- The net_entry pointer of the network in question.
 * Returns      : True     -- Life is good. We deleted the network.
 *                FALSE    -- Life sucks, we didn't delete the network.
 */
gboolean
nl_del_network (net_entry *network)
{
  g_return_val_if_fail (network != NULL, FALSE);
  g_hash_table_remove (net_hash, network);
  return FALSE;
}

/*
 * Function   : find_network_by_name
 * Description: This function will find a given network by name and return
 *              the net_entry structure pointer to it.
 * Arguments  : net_name  -- The network name to locate.
 * Returns    : net_entry structure pointer on success.
 *              NULL pointer on failure.
 */
net_entry *
find_network_by_name (gchar *name)
{
  if (net_hash)
    return (net_entry *)(g_hash_table_lookup (net_hash, name));
  else
    return (net_entry *)NULL;

}


/*
 * Function    : add_host_to_network
 * Description : This function will establish a connection from a node to the
 *               network object on the map.
 * Arguments   : network  -- The net_entry structure pointer of the network
 *                           in question.
 *               host     -- The hosts structure pointer of the host in 
 *                           int question.
 * Returns     : None for now.
 */
void 
add_host_to_network (net_entry *network, hosts *host, GnomeCanvasItem *item)
{

  g_return_if_fail (network != NULL);
  g_return_if_fail (host != NULL);

}

/*
 * Function    : del_host_from_network
 * Description : This function will delete a host from a given network.
 * Arguments   : network  -- The net_entry structure pointer of the network
 *                           in question.
 *               host     -- The hosts structure pointer of the network in 
 *                           question.
 * Returns     : None for now.
 */
void
del_host_from_network (net_entry *network, hosts *host)
{

}


/* EOF */
