#include <stdio.h>
#include <mntent.h>
#include <sys/sysmacros.h>
#include <sys/param.h>
#include "dinstall.h"
#include "../busybox/internal.h"

#define TARGET_PREFIX    "/target"
#define TARGET_NOPREFIX  "/tmp/notarget"
#define TARGET_TESTDIR   "targetdir_test"

#ifdef NFSROOT
int
is_nfs_partition( const char* target )
{
	struct fdisk_partition* p;
	if (! is_network_configured())
		return 0;
	p = fdisk_find_partition_by_mntpoint(target);
	if ((p) && (p->type == PTYPE_NFS))
		return 1;
	return 0;
}
#else
int
is_nfs_partition( const char* target )
{
	return 0;
}
#endif

/*
 * return the path to target network files:
 * either real /target if already mounted
 * or a temporary /tmp/notarget directory.
 */
const char* target_path(const char* s)
{
  static char buf[MAXPATHLEN];
  const char* prefix;
#ifndef _TESTING_
  if (Root)
	prefix = TARGET_PREFIX;
  else
	prefix = TARGET_NOPREFIX;
#else
  prefix = TARGET_TESTDIR;
#endif
  strcpy( buf, prefix );
  strcat( buf, s );
  return buf;
}

int
is_network_configured(void)
{
	struct stat statbuf;

	if ( (NAME_ISREG(target_path("/etc/init.d/network"),&statbuf)) &&
		 (NAME_ISEXE("/sbin/ifconfig",&statbuf)) )
		return 1;
	return 0;
}

int
check_target_path(void)
{
	if (!Root) {
		/* need to create the temp dir */
		return mkdir(TARGET_NOPREFIX,0755);
	}
	return 0;
}

/*
 * check_dir
 * Stats some dirname and checks whether it exists and whether it's a 
 * directory.
 */
int check_dir(const char* dirname)
{
  struct stat check;
  if(stat(dirname,&check)==-1)
    return -1;
  else
    return S_ISDIR(check.st_mode);
}

int
check_pending_config(void)
{
  if (check_dir(TARGET_NOPREFIX)!=-1) {
	/*
	 * /tmp/notarget exists: network was previously configured with no
	 * target system mounted.
	 * Just move the notarget tree to /target
	 */
	struct FileInfo finfo;
	memset( &finfo, 0, sizeof(finfo) );
	finfo.source = TARGET_NOPREFIX;
	finfo.directoryLength = 4;		/* /tmp part */
	finfo.destination = TARGET_PREFIX;
	finfo.dyadic = 1;
	finfo.recursive = 1;
	return descend( &finfo, cp_fn );
  }
  return 0;
}

/* vi: set sw=4 ts=4: */
