#include <stdio.h>
#include <sys/sysmacros.h>
#include <sys/ioctl.h>
#include <linux/serial.h>
#include "dinstall.h"
#include "../busybox/internal.h"
#include INCLINGUA

#define EXPORTS "export LD_LIBRARY_PATH=\"/target/lib:/target/usr/lib\"; "
#define SEDCOMMAND "/target/bin/sed"

extern int configure_timezone(void);

static int require_swap (void) {
  if ( (swapon_partitions == NULL) &&
       (fdisk_partitions_by_type[FSTYPE_SWAP] == NULL) &&
       (noSwap == 0) ) {
    problemBox(MSG_NO_SWAP_PARTITION_L,MSG_NO_SWAP_PARTITION);
    return 1;
  }
  return 0;
}

static int update_cdrom_symlink (void) {
  struct stat statbuf;
  int pos;
  
  if ( (! lstat("/dev/cdrom",&statbuf) ) &&
       S_ISLNK((&statbuf)->st_mode) && 
       NAME_ISDIR("/target/dev",&statbuf) ) {
    pos=readlink("/dev/cdrom",prtbuf,20);
    prtbuf[pos]='\0';
    symlink (prtbuf,"/target/dev/cdrom");
  }
  return 0;
}

#ifdef SCSI_FLOPPY
static int update_sfd0_symlink (void) {
  struct stat statbuf;
  int pos;
  
  if ( (! lstat("/dev/sfd0",&statbuf) ) &&
       S_ISLNK((&statbuf)->st_mode) && 
       NAME_ISDIR("/target/dev",&statbuf) ) {
    pos=readlink("/dev/sfd0",prtbuf,20);
    prtbuf[pos]='\0';
    symlink (prtbuf,"/target/dev/sfd0");
  }
  return 0;
}
#endif

#if #cpu (m68k)
static int update_fdisk_symlink (void) {
  char *target;

  /* determine target of symlink */
  if (strcmp(Arch2, "Atari") == 0)
	  target = "atari-fdisk";
  else if (strcmp(Arch2, "Amiga") == 0)
	  target = "amiga-fdisk";
  else if (strcmp(Arch2, "Macintosh") == 0)
	  target = "mac-fdisk";
  else if (strcmp(Arch2, "VME") == 0)
	  target = "../usr/sbin/pmac-fdisk";
  else
	  return -1;

  /* remove an existing /sbin/fdisk (ignore if not existed) */
  unlink("/target/sbin/fdisk");
  symlink(target, "/target/sbin/fdisk");
  return 0;
}
#endif

#if #cpu (powerpc)
static int update_fdisk_symlink (void) {
  char *target;

  /* determine target of symlink */
  if (strcmp(Arch2, "APUS") == 0)
	  target = "amiga-fdisk";
  else if (strcmp(Arch2, "BeBox") == 0)
	  target = "dos-fdisk";
  else if (strcmp(Arch2, "CHRP") == 0)
	  target = "dos-fdisk";
  else if (strcmp(Arch2, "MBX") == 0)
	  target = "dos-fdisk";
  else if (strcmp(Arch2, "PowerMac") == 0)
	  target = "pmac-fdisk";
  else if (strcmp(Arch2, "PReP") == 0)
	  target = "dos-fdisk";
  else
	  return -1;

  /* remove an existing /sbin/fdisk (ignore if not existed) */
  unlink("/target/sbin/fdisk");
  symlink(target, "/target/sbin/fdisk");
  return 0;
}
#endif


#ifdef SERIAL_CONSOLE
static int
update_console_info (void)
{
  char tty[16];
  int ttyline = -1;
  int err = 0;
  FILE *F;
  /* serial console setup:
   *  1/ relink /dev/console to /dev/ttyS<n> *only* if < 2.0 kernel
   *  2/ edit /target/etc/inittab to enable a T<n> line and set emulation type
   *  2b/ do the same thing with /target/etc/inittab.real
   *  3/ add ttyS<n> & cua<n> to /target/etc/securetty
   */
  if (!strncmp(real_kver,"2.0",3)) {
    strcpy(tty, ttyname(0));
    if (!strncmp(tty,"/dev/cua",8))
      ttyline = tty[8] - '0';
    else if (!strncmp(tty,"/dev/ttyS",9))
      ttyline = tty[9] - '0';
  }
  else {
	struct serial_struct sr;
    if (ioctl(0,TIOCGSERIAL,&sr) < 0)
      strcpy(tty, "/dev/console");
    else {
      ttyline = sr.line;
      sprintf(tty, "/dev/ttyS%d", ttyline);
    }
  }
  if (ttyline >= 0) {
    char *term = getenv("TERM");
    if (!term||!*term) term="vt100";
    /* 1 */
    if (!strncmp(real_kver,"2.0",3)) {
      /* 2.0 kernel only */
      unlink("/target/dev/console");
      symlink(tty, "/target/dev/console");
    }
    /* 2 */
    sprintf(prtbuf,EXPORTS
	SEDCOMMAND
	" -e 's/^#\\(T%d:.\\+\\)root\\(.*\\)/\\1root TERM=%s\\2/'"
	" -e 't x' -e 's/^\\([1-6]\\):/#\\1:/' -e b"
	" -e ':x' -e 's,/dev/[[:alnum:]]*,%s,g' < %s > %s",
	ttyline, term, tty,
	"/target/etc/inittab",
	"/target/etc/inittab.tmp");
    if (system(prtbuf) ||
	rename("/target/etc/inittab.tmp","/target/etc/inittab"))
    {
      problemBox("Error writing /target/etc/inittab ","Write error");
      return 1;
    }
    /* 2b */
    sprintf(prtbuf,EXPORTS
 	SEDCOMMAND
	" -e 's/^#\\(T%d:.\\+\\)[[:space:]][[:alnum:]]\\+[[:space:]]*$/\\1 %s/'"
	" -e 's/^\\([1-6]\\):/#\\1:/' < %s > %s",
	ttyline, term,
	"/target/etc/inittab.real",
	"/target/etc/inittab.real.tmp");
    if (system(prtbuf) ||
	rename("/target/etc/inittab.real.tmp","/target/etc/inittab.real"))
    {
      problemBox("Error writing /target/etc/inittab.real ","Write error");
      return 1;
    }
    /* 3 */
    F=fopen("/target/etc/securetty","a");
    if (F) {
      err = fprintf(F,"ttyS%d\ncua%d\n",ttyline,ttyline) <= 0;
      fclose(F);
    }
    else
      err = 1;
    if (err) {
      problemBox("Error writing /target/etc/securetty ","Write error");
      return 1;
    }
  }
  return 0;
}
#endif

static int write_environment (void) {
  FILE *etcenv;

  if (NULL==(etcenv=fopen("/target/etc/environment","w"))){
    problemBox(MSG_CANT_OPEN_ENVIRO,MSG_WRITE_ERROR);
    return 1;
  }
  fprintf(etcenv,"LANG=%s\n",LINGUA);
  fclose(etcenv);
  return 0;
}

static int write_fstab (void) {
  FILE *fstab;
  struct fdisk_partition *p;
  char* fsname;
  char* fsopts;

  if (NULL==(fstab=fopen("/target/etc/fstab","w"))){
    problemBox(MSG_CANT_OPEN_FSTAB,MSG_WRITE_ERROR);
    return 1;
  }

  if (is_nfs_partition("/target")) {
	fsname = "nfs";
	fsopts = "rw,rsize=8192,wsize=8192";
  }
  else {
	fsname = "ext2";
	fsopts = "defaults,errors=remount-ro";
  }
  fprintf(fstab,
"# /etc/fstab: static file system information.\n"
"#\n"
"# <file system> <mount point> <type> <options>                  <dump> <pass>\n"
"%-15s /             %s   %s 0      1\n",
  Root->name, fsname, fsopts);

  if (swapon_partitions != NULL) {
    p = swapon_partitions;
    while (p) {
      fprintf(fstab,
        "%-15s none          swap   sw                         0      0\n",
        p->name);
      p=p->next_in_use;
    }
  }

  fprintf(fstab,
"proc            /proc         proc   defaults                   0      0\n");

  fclose(fstab);

  sprintf(prtbuf,EXPORTS
      SEDCOMMAND
      " -n '/target\\//p' /etc/mtab | "
      SEDCOMMAND
      " -e 's/target\\///' -e 's/ 0 0/ 0 2/' -e 's/ rw / defaults /' "
      " >> /target/etc/fstab 2>/dev/null");
  if (system(prtbuf)) {
    problemBox(MSG_ERROR_WRITING_FSTAB,MSG_WRITE_ERROR);
    return 1;
  }
  return 0;
}

static int copy_default_keymap (void) {
  struct stat statbuf;
/* Don't create default keymap right now, we'll create it right after the
 * first reboot, using loadkeys/dumpkeys */
  if (! NAME_ISREG("/tmp/kbdconf",&statbuf)) {
/* If /tmp/kbdconf doesn't exist, perhaps the user skipped the "config
 * kbd" step. Just continue... */
    return 0;
  }
  sprintf(prtbuf,"cp /tmp/kbdconf /target/root/kbdconf");
  system(prtbuf);
  return 0;
}

#ifdef FONT
static int write_etc_kbd (void) {
  FILE *etc_kbd;
  if (NULL == (etc_kbd = fopen("/target/etc/kbd/config", "a"))) {
    problemBox(MSG_CANT_OPEN_ETC_KBD, MSG_WRITE_ERROR);
    return 1;
  }
  fprintf(etc_kbd, "CONSOLE_FONT=%s\n", FONT);
  fclose(etc_kbd);
  return 0;
}
#endif

int configure_base (void) {
  struct stat statbuf;

  if ( require_swap() ) return 1;

  if (! NAME_ISREG( "/target/sbin/init", &statbuf) ) {
    problemBox(MSG_BASE_NOT_INSTALLED_L,MSG_BASE_NOT_INSTALLED);
    return 1;
  }

  if ( write_fstab() ) return 1;

#if #cpu (m68k)
  /* don't do keymapping for VME serial console */
  if (strcmp(Arch2, "VME") == 0)
    unlink("/target/bin/loadkeys");
  else
#endif
    if ( copy_default_keymap() ) return 1;

#ifdef FONT
    if ( write_etc_kbd() ) return 1;
#endif

  configure_timezone();

  update_cdrom_symlink();

#ifdef SCSI_FLOPPY
  update_sfd0_symlink();
#endif

  if (!strncmp(real_kver,"2.0",3)) {
	  /* 2.0 kernel only: first update /dev/console then eventually
	   * change it to /dev/ttyS<n> latter in update_console_info() */
	  unlink("/target/dev/console");
	  symlink("tty0", "/target/dev/console");
  }

#if #cpu (m68k)
  if (strcmp(Arch2, "VME") == 0)
    update_console_info();
  update_fdisk_symlink();
#endif

#if #cpu (powerpc)
  update_console_info();
  update_fdisk_symlink();
#endif

#if #cpu (sparc)
  update_console_info();
#endif

  write_environment();

  unlink("/target/sbin/unconfigured.sh");

  return 0;
}

int configure_drivers (void) {
  struct stat statbuf;
#if #cpu (m68k) || #cpu (powerpc)
  const char *arch2name;
#endif
  
  if (NAME_ISDIR("/lib/modules",&statbuf) ) {
    rename("/lib/modules","/lib/modules.old");
  }
  unlink("/lib/modules");
  chdir("/lib");
  symlink("/target/lib/modules","modules");

  boxSuspend();
  setenv("LANG", LINGUA, 1);
  sprintf(prtbuf,"depmod -a ; /target/usr/sbin/modconf "
	" --libdir /target/usr/lib/module_help --exclude-section pcmcia"
	" --target /target --run-shell cdromsymlink");
  if (strncmp(real_kver,"2.0",3)) {
    /* not on 2.0 kernels:
     * workaround for serial consoles (/dev/tty is not avail) */
    strcat(prtbuf," --tty /dev/console");
  }
  system(prtbuf);
  boxResume();

  update_cdrom_symlink();

  chdir("/target/etc");
  sprintf(prtbuf,"cp %s %s","/etc/modules","modules");
  system(prtbuf);
  sprintf(prtbuf,"cp /etc/conf.modules conf.modules");
  system(prtbuf);

  chdir("/");
  return 0;
}
