/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 *
 * $RCSfile: plugin_m.cpp,v $
 *
 * $Revision: 1.2 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 *
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 *
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#include "plugin_m.h"

#ifndef HAVE_RTLD_LAZY_DEFINE
#define RTLD_LAZY 1
#endif // RTLD_LAZY

#ifdef HAVE_DLSYM_UNDERSCORE
#define MKDLSYM(a) "_" ## a
const char *DynObj::makeDlSym(const char *szSymname)
{
	strcpy(symnamebuffer, "_");
	strcat(symnamebuffer, szSymname);
	return symnamebuffer;
}
#else
#define MKDLSYM(a) a
const char *DynObj::makeDlSym(const char *szSymname)
{
	strcpy(symnamebuffer, szSymname);
	return symnamebuffer;
}
#endif	 /* HAVE_DLSYM_UNDERSCORE */

char   *plugin_functions[] =
{
	"init_plugin",
	"query_plugin",
	"close_plugin",
	"dist_plugin_inf",
	"read_pl_dir"
};

char    insert_text[PATH_MAX];
char    print_text[PATH_MAX];
char    plugin_file_name[] = "eplugin.so";	// default plugin template, you got to have
									   		// this one

#ifdef HAVE_DLFCN_H
#include <dlfcn.h>

/*---------------------------------------------------------------------------*/
DynObj::DynObj(const char *szDlName, int dlflags):dynobjHandle(NULL)
{
	dlflags = RTLD_LAZY;
	dynobjHandle = dlopen((char*)szDlName, dlflags);
}
/*---------------------------------------------------------------------------*/
DynObj::~DynObj()
{
	dlclose(dynobjHandle);
	dynobjHandle = NULL;
}
/*---------------------------------------------------------------------------*/
const char *DynObj::getError()
{
	return dlerror();
}
/*---------------------------------------------------------------------------*/
void   *DynObj::getSymbol(const char *symbol)
{
	return dlsym(dynobjHandle, (char*)makeDlSym(symbol));
}
/*---------------------------------------------------------------------------*/
#elif defined(HAVE_DL_H)
#include <dl.h>

/*
 * HP-UX section, thanks to Alf Clement <alf@hpbidrd.bbn.hp.com>
 * for providing me the details
 *
 */
 
 /*---------------------------------------------------------------------------*/
DynObj::DynObj(const char *szDlName, int dlflags):dynobjHandle(NULL)
{
	dlflags = BIND_IMMEDIATE | BIND_VERBOSE;
	dynobjHandle = shl_load(szDlName, dlflags, 0);
}
/*---------------------------------------------------------------------------*/
DynObj::~DynObj()
{
	// No docs yet.

	shl_close(dynobjHandle);
	dynobjHandle = NULL;
}
/*---------------------------------------------------------------------------*/
const char *DynObj::getError()
{
	return "undefined yet";
}
/*---------------------------------------------------------------------------*/
void   *DynObj::getSymbol(const char *symbol)
{
	void   *addr;

	return shl_findsym(&dynobjHandle, symbol, TYPE_UNDEFINED, &addr);
}
/*---------------------------------------------------------------------------*/
#else	 /* HAVE_DL_H    */
/*
 * Braindead section. no means of dynamic linking is available
 * for for some Linuxes, dlfcn.h could not be found/opened
 * while running configure  
 */
DynObj::DynObj(const char *szDlName, int dlflags):dynobjHandle(NULL)
{
	/*NOP*/
}
/*---------------------------------------------------------------------------*/
DynObj::~DynObj()
{
	/*NOP*/
}
/*---------------------------------------------------------------------------*/
const char *DynObj::getError()
{
	return "Not implemented";
}
/*---------------------------------------------------------------------------*/
void   *DynObj::getSymbol(const char *symbol)
{
	return NULL;
}
#endif	 /* HAVE_DLFCN_H */

				// here starts the actual plugin loader/manager

/*---------------------------------------------------------------------------*/
EPluginManager::EPluginManager(QWidget * parent,
const char *name):QMultiLineEdit(parent,
							  name)
{
	plugins_avail = TRUE;		// assume we can load plugins

	scrollb = 25;				// initialise the buffer to 25 lines

	entry_top = NULL;
	entry_current = NULL;

	// determen plugin path

	char   *pldir = getenv("EXPLOREDIR");

#ifdef EXPLORERDATADIR
	if (pldir == NULL)
		pldir = EXPLORERDATADIR;
#endif	 // EXPLORERDATADIR

		if (pldir == NULL)
		{
			eprintf("Unable to locate explorerdir [EXPLOREDIR]");
			plugins_avail = FALSE;
		}
		else
		{

			plugin_path[0] = 0;
			sprintf(plugin_path,
					"%s/plugins",
					pldir);

			struct DIR *checkdir;

			checkdir = opendir(plugin_path);
			if (checkdir == NULL)
			{
				eprintf("Plugin directory [%s] does not exist", plugin_path);
				eprintf("Disabling plugins support");
				plugins_avail = FALSE;
			}
			else
				closedir(checkdir);
		}
}
/*---------------------------------------------------------------------------*/
EPluginManager::~EPluginManager()
{
	// don't forget to remove the plugin list
}
/*---------------------------------------------------------------------------*/
/* This is the plugin manager's function of printf, use it just like the     */
/* real thing.                                                               */
/*---------------------------------------------------------------------------*/
void    EPluginManager::eprintf(const char *print_string,...)
{
	va_list ap;

	va_start(ap, print_string);

	print_text[0] = 0;
	vsprintf(print_text, print_string, ap);

	// >----------- check for '\n'

	if (print_text[strlen(print_text) - 2] == '\n')
		print_text[strlen(print_text) - 2] = 0;

	if (numLines() > scrollb)
		removeLine(0);

	insertLine(print_text, -1);

	va_end(ap);
}
/*--------------------------------------------------------------------------*/
void    EPluginManager::load_a_plugin(char *plugin_name)
{
	FILE   *plugin_file;
	void   *plugin_lib;

	void    (*init_pl) ();

	insert_text[0] = 0;
	sprintf(insert_text,
			"%s/%s",
			plugin_path,
			plugin_name);

	plugin_file = fopen(insert_text, "rb");

	if (plugin_file != NULL)
	{
		fclose(plugin_file);

		DynObj *temp_loader = new DynObj(insert_text);

		plugin_lib = temp_loader->get_handle();

		if (plugin_lib != NULL)
		{
			init_pl = (void (*)(void)) temp_loader->getSymbol(plugin_functions[PLUGIN_INIT]);
			if (init_pl == NULL)
			{
				eprintf("%s [%s] in [%s]",
						temp_loader->getError(),
					  temp_loader->makeDlSym(plugin_functions[PLUGIN_INIT]),
						plugin_name);

				eprintf("Closing plugin [%s]", plugin_name);
				delete  temp_loader;
			}
			else
			{
				eprintf("Executing plugin: [%s]",
						insert_text);
				(*init_pl) ();

				// if the plugin's init executed succesfully we add it to the
				// plugin list entries

				struct pl_inf *temp_inf = query_a_plugin(temp_loader, plugin_name);

				add_pl_entry(insert_text, temp_inf);

				// now unload the plugin, after this we only load it at
				// runtime

				eprintf("Closing plugin [%s]", plugin_name);
				delete  temp_loader;
			}
		}
		else
		{
			eprintf("Error loading: [%s]",
					insert_text);
		}
	}
	else
	{
		eprintf("Error opening plugin file: [%s]",
				insert_text);
	}
}
/*---------------------------------------------------------------------------*/
void    EPluginManager::load_plugins(void)
{
	if ((plugin_path[0] != 0) && (plugins_avail == TRUE))
	{
		eprintf("Scanning for plugins in: [%s]",
				plugin_path);

		load_a_plugin(plugin_file_name);
	}
}
/*---------------------------------------------------------------------------*/
struct pl_inf *EPluginManager::query_a_plugin(DynObj * temp_loader,
											  char *plugin_name)
{
	void    (*query_pl) (struct pl_inf *);

	query_pl = (void (*)(struct pl_inf *)) temp_loader->getSymbol(plugin_functions[PLUGIN_QUERY]);

	if (query_pl == NULL)
	{
		eprintf("%s [%s] in [%s]",
				temp_loader->getError(),
				temp_loader->makeDlSym(plugin_functions[PLUGIN_QUERY]),
				plugin_name);
	}
	else
	{
		struct pl_inf *temp_inf = new pl_inf;

		(*query_pl) (temp_inf);

		eprintf("Querying plugin: <%s> [%s] (%s)",
				temp_inf->pl_name,
				temp_inf->pl_author,
				temp_inf->pl_ver);

		return (temp_inf);
	}

	return (NULL);
}
/*---------------------------------------------------------------------------*/
void    EPluginManager::unload_plugins(void)
{

}
/*---------------------------------------------------------------------------*/
void    EPluginManager::add_pl_entry(char *path_to_plug, struct pl_inf *new_inf)
{
	if (entry_top == NULL)
	{
		entry_top = new plugin_entry;
		entry_current = entry_top;
		entry_current->next = NULL;
	}
	else
	{
		entry_current->next = new plugin_entry;
		entry_current = entry_current->next;
		entry_current->next = NULL;
	}

	entry_current->path_to_plugin = (char *) malloc(strlen(path_to_plug) + 1);
	strcpy(entry_current->path_to_plugin, path_to_plug);

	entry_current->plugin_info = new_inf;
}
/*---------------------------------------------------------------------------*/
struct plugin_entry *EPluginManager::get_plugin_list(void)
{
	return (entry_top);
}
/*---------------------------------------------------------------------------*/
