/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: dir_tree.h,v $
 *
 * $Revision: 1.2 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 *
 */

#ifndef __DIR_TREE_H__
#define __DIR_TREE_H__

#include "data_tree.h"
#include "expl_vfsl.h"
#include "dialogs.h"

#include <data_win.h>

//>------------- This widget forms the left part of the screen ( if you want )

class   DirTreeWidget:public QWidget
{
	Q_OBJECT

  protected:

	void    paintEvent(QPaintEvent *);
	void    resizeEvent(QResizeEvent *);
	void    mousePressEvent(QMouseEvent *);
	void    mouseReleaseEvent(QMouseEvent *);
	void    mouseMoveEvent(QMouseEvent *);
	void    mouseDoubleClickEvent(QMouseEvent *);

	void    closeEvent(QCloseEvent *);

  private:

	VFSL_Class * io_class;

	OptionsPopup *mouse_popup;
	OperationPopup *op_popup;	

	FileTreeNode *tree_top;
	FileTreeNode *tree_node;

	UpDownScroll *scroll_ud;
	LeftRightScroll *scroll_lr;

	char    dnd_active;
	char    select_active;
	//char    multiple_select;
	char    has_focus;

	int     x_start,
	        y_start;
	int     x_new,
	        y_new;
	int     x_old,
	        y_old;

	char    still_dragging_on;

	void    compose_directory(FileTreeNode *);

  public:

	DirTreeWidget(QWidget *,
                      const char *,
                      UpDownScroll *,
                      LeftRightScroll *,
                      VFSL_Class *,
                      OptionsPopup *,
                      OperationPopup *);

	void deselect(void);
	void select(QMouseEvent *);
	void redraw(void);
	int  count_selection(); 
	void update_uds(int);
	void set_root_node(FileTreeNode *);
	char get_focus ();
	FileTreeNode *get_target (void);

  public  slots:

	void update_pane();
	void selection_removed(); 
	void drag_and_drop(bool);
	void change_dir(FileTreeNode *);
	void reread_dir (const char *);

	FileTreeNode *search_for_dir(FileTreeNode *,const char *);

	void goto_dir(const char *);
	void un_mount(const char *);
	
	void remove_focus ();
	void set_focus ();
	
	void remoteMoveEvent (QPoint &);

  signals:

	void    update_widgets();
	void    update_root_node(FileTreeNode *);

	void    set_dir_info(const char *);
        void    remove_selection ();
        
	void    take_focus ();        

	void    dragging_and_dropping(bool);
};

//>-----------------

class   DirTreeContainer:public QFrame
{
	Q_OBJECT

	protected:

	void    resizeEvent(QResizeEvent *);

	UpDownScroll *scroll_ud;
	LeftRightScroll *scroll_lr;

	QPushButton *fill_btn1;
	DirTreeWidget *child_widget;

	public:

	DirTreeContainer (QWidget *, 
	                  const char *, 
	                  VFSL_Class *,
                          OptionsPopup *,
                          OperationPopup *);
	DirTreeWidget *get_child();
};

#endif
