
#include "run.h"

char  temp_string [512];
char *home_path;

QPixmap *icon_map;

/*---------------------------------------------------------------------------*/
void RunClass::paintEvent (QPaintEvent *e)
{
 QPen     paint_pen    (QColor (0,0,0),0,SolidLine);
 e=e;     // compiler trick

 QPainter paint;
 paint.begin (this);
 paint.setPen (paint_pen);
 paint.drawText (60,25,"Type the name of a program, folder or document and");
 paint.drawText (60,38,"the system will open it for you");
 paint.drawText (10,65,"Open:");

 paint.drawPixmap (10,
                   15,
                   *icon_map);
 paint.end ();
}
/*---------------------------------------------------------------------------*/
void RunClass::browse ()
{
 
}
/*---------------------------------------------------------------------------*/
int main (int argc, char **argv)
{
    //>----------- make sure we have an QApplication class
    QApplication::setColorMode (QApplication::CustomColors);
    QApplication a (argc,argv);

    QFont *adj_font=new QFont ("Helvetica",10);
    a.setFont (*adj_font,TRUE);
    a.setStyle (WindowsStyle); 

    home_path=getenv ("HOME");
    if (home_path==NULL)
    {
     printf ("Unable to find environment variable [HOME]\n");
     return (1);
    }     

    icon_map=new QPixmap;
    sprintf (temp_string,"%s/run_ico.bmp",home_path);
    if (!(icon_map->load (temp_string)))
    {
      printf ("Unable to open [%s]\n",temp_string);
      return (1);
    }     

    RunClass *run_dialog=new RunClass (0,0);
   
    a.setMainWidget (run_dialog);

    run_dialog->show ();

    a.exec();

  return (0);
}
/*---------------------------------------------------------------------------*/



