#include <TimeLCD.h>

static const int timeDigitMax[] =
{
    // 60 sec, 60 min
    // '9'++, '6', '9'++, '6'
    0x3a, 0x36, 0x3a, 0x36, -1
};

static const int timeDigitIndex[] =
{
    // Order in which to increase the digits;
    4, 3, 1, 0, -1
};

TimeLCD::TimeLCD(QWidget* parent, const char* name) : QLCDNumber(parent,name)
{
    init();
}

void TimeLCD::init()
{	
    timeInSecs = 0;
    timeString[0] = ' ';
    timeString[1] = '0';
    timeString[2] = ':';
    timeString[3] = '0';
    timeString[4] = '0';
    timeString[5] = 0;
}

void TimeLCD::resetDisplay()
{
	init();
    display(timeString);
}

void TimeLCD::updateDisplay(const int secs)
{
    if (timeInSecs != secs)
    {
        while (timeInSecs < secs)
        {
            timeInSecs++;
            int i = 0;
            while (timeDigitIndex[i] != (-1))
            {
                int d = timeDigitIndex[i];  // get digit number
                if (timeString[d] == ' ')   // digit not used so far
                    timeString[d] = '1';
				else
                    timeString[d]++;        // increase digit
                if (timeString[d] == timeDigitMax[i])
                {
                    timeString[d] = '0';
                    i++;  // proceed to next digit only if necessary
                }
                else
                    break;
            };
        };
        display(timeString);
    }
}
