#ifndef HistoryDialog_h
#define HistoryDialog_h

#include <stdlib.h>
#include <qlist.h>
#include <qevent.h>
#include <qmessagebox.h>
#include <qsize.h>
#include <qstring.h>
#include <sidplay/sidtune.h>

#include "HistoryDialogData.h"
#include "HistoryItem.h"
#include "HistoryFile.h"
#include "GlobalIcon.h"

class HistoryDialog : public HistoryDialogData
{
    Q_OBJECT

    friend class HistoryFile;
    
public:

    HistoryDialog(QWidget* parent=0, const char* name=0);
    ~HistoryDialog();
    
    bool save();
    void add(const char* file, const char* title);

 protected:
    
    void resizeEvent(QResizeEvent*);
    
 protected slots:
    
    void historyItemHighlighted(int);
    void historySizeChanged();
    void prevButtonClicked();
    void nextButtonClicked();
    void deleteButtonClicked();
    void clearButtonClicked();

 signals:
    
    void playHistoryEntry(const char*);
    
 private:
    
    QList<HistoryItem> list;
    unsigned int maxItems;
    bool autoAdd;

    HistoryFile* file;
};

#endif  // HistoryDialog_h
