#ifndef ConfigFile_h
#define ConfigFile_h

#if defined(WB_DEBUG)
# include <iomanip.h>
# include <iostream.h>
#endif
#include <fstream.h>
#include <stdlib.h>
#include <unistd.h>
#include <qstring.h>
#include <sidplay/mytypes.h>
#include <sidplay/emucfg.h>

#include "AudioConfig.h"
#include "HVSCconfig.h"
#include "MixerConfig.h"
#include "TextFile.h"

class Geom  // window/dialog geometry
{
 public:
    int x, y, w, h;
    Geom() { x = y = w = h = (-1); }
    bool good() const { return ((x>=0)||(y>=0)||(w>0)||(h>0)); }
};

class VariousConfig
{
    
 public:
    
    udword usage;  // listening mileage in seconds
    
    bool enableSTILview;
    
    QString currentDir;
    QString nameFilter;
    bool showDirDlg;
    Geom geomDirDlg;
    Geom geomMainDlg;
 
    MixerConfig myMixerConfig;
    
    VariousConfig()
    {
        enableSTILview = false;
        usage = 0;
        currentDir = ".";
        nameFilter = "*.sid";
        showDirDlg = 0;
    }
};

class ConfigFile : private TextFile
{
 public:

    ConfigFile(const char*);

    bool load();
    bool save();
    void print() const;  // debug only
    
    const AudioConfig& getAudioConfig() const;
    const emuConfig& getEmuConfig() const;
    const HVSCconfig& getHVSCconfig() const;
    const VariousConfig& getVariousConfig() const;

    void setAudioConfig(const AudioConfig&);
    void setEmuConfig(const emuConfig&);
    void setHVSCconfig(const HVSCconfig&);
    void setVariousConfig(const VariousConfig&);

 protected:

    QString configPath;

    AudioConfig myAudioConfig;  // the audio driver settings
    emuConfig myEmuConfig;      // the emulator engine settings
    HVSCconfig myHVSCconfig;    // the HVSC/STIL settings
    VariousConfig myConfig;     // everything else

};

#endif  // ConfigFile_h
