.TH xtrs 1
.SH Name
xtrs \- TRS-80 Model I/III/4 emulator for the X Window System
.SH Syntax
.B xtrs [-model m] [-diskdir d] [-debug]
.I [other options]
.SH Description
\fBxtrs\fP is built on top of a Z-80 emulator, with added routines to support
keyboard and video I/O through an X interface.
The hardware emulation can operate as a TRS-80 Model I, Model III,
Model 4, or Model 4P.

\fBxtrs\fP supports 48K of RAM in Model I or Model III mode,
128K in Model 4 or Model 4P mode. 
Floppy disks and hard disks are emulated using files to store the data;
or under Linux only, real floppy drives can be used.
A printer is emulated by
sending its output to standard output.  
There is also a rudimentary emulation of cassette I/O
that uses files for cassette tapes (Model I mode only).
Crude sound support is available under Linux if you have 
SoundBlaster-compatible hardware.
In Model 4/4P mode, a hi-res graphics card is emulated; you can select either
the Radio Shack card or the Micro Labs Grafyx Solution card.
There is also a mouse driver for Model 4/4P mode.

The Z-80 emulator has a debugger called zbx.  It works sort of
like dbx.  If you run with debugging turned on (see the options section for
how to do this), you'll enter the debugger, and
you can type "help" for more information.

Special support in the emulator allows the program to block when
waiting for information from the keyboard.  This will work only for
programs that wait for keyboard input using the standard Model I/III
ROM call; the emulator decides whether to block the Z-80 program when
it tries to read from the keyboard memory by pattern-matching its
stack.
.SH Keys
The following keys have special meanings to \fBxtrs\fP:

LeftArrow, Backspace, or Delete is the TRS-80 left arrow key.
RightArrow or Tab is the right arrow key.  UpArrow is the up arrow
key.  DownArrow or Linefeed is the down arrow key.  Esc or Break is
the Break key.  Home, Clear, or LeftAlt is the Clear key.  Control is
the Model 4 Ctrl key (address bit 7, data bit 2).  RightAlt is
equivalent to the shifted down arrow key (used as a control key with
some TRS-80 software).

F1, F2, and F3 are the Model 4/4P function keys (address bit 7, data bits
4, 5, and 6).  F1 is also the Model I Electric Pencil control key that
some users added to their machines.  F4 is the Model 4 Caps Lock key
(address bit 7, data bit 3).  F5, Compose, or ScrollLock is equivalent
to the @ key (so that @ can be used as a modifier key).  F6 is
equivalent to the 0 key (so that a shifted 0 can be obtained).  F7
signals a disk change in the emulated floppy drives (see below).  F8
exits the program.  F9 requests entry to the debugger if it is active.
F10 is the reset button.

In Model III, 4, and 4P modes, the left and right shift keys are distinct; in
Model I mode, they are the same.  The F11 or F14 key activates the
position in the TRS-80 keyboard matrix that corresponds to the Model
III/4/4P right shift key (address bit 7, data bit 1) even in Model I mode.
F12 or End activates an unused position in the keyboard matrix
(address bit 7, data bit 7).  The keys [, \\, ], ^, _, {, |, },
and ~ also activate unused positions in the keyboard matrix (address
bit 3, data bits 3-7).  These keys map to the corresponding ASCII
characters under some TRS-80 keyboard drivers; under others, they do
nothing.  F13 or Insert is equivalent to underscore (address bit 3,
data bit 7), so that a shifted underscore can be obtained; this maps
to ASCII code 0x7f under some TRS-80 keyboard drivers.
.SH Emulated cassette
To control the emulated cassette, a file called ".cassette.ctl" in the
current directory keeps track of what file is currently "loaded" as
the cassette tape and the current position within that file.  The
"cassette" shell script provides a way to manipulate this file; typing
"help" shows its commands.  You may use this script to load and
position cassette tape files.  The operation works very much like an
actual tape recorder.  The cassette emulation works only in Model I mode.
.SH Printer
For printer support, any text sent to the TRS-80's printer (using LPRINT
or LLIST, for example) is sent to the standard output.
.SH Emulated floppy disks
In Model I mode, \fBxtrs\fP emulates a Radio Shack Expansion Interface
with the Percom Doubler or Radio Shack Doubler installed.  The Doubler
provided double-density disk access by allowing either the stock
WD1771 FDC chip or a WD1791 chip to be selected under program control.
At powerup the 1771 is selected, so operating systems with no Doubler
driver see a stock system.  By default, the emulator pretends to be
both a Percom and Radio Shack Doubler at the same time -- it responds
to the special commands of both -- so a driver for either should work.
Under LDOS, use the command "FDUBL" (newer versions of LDOS), or
"PDUBL" or "RDUBL" (older versions) to install the driver. Software that
tries to detect which doubler you have (such as Super Utility) may be
confused by the emulation of both at once, so you can choose to emulate
only one with a command line option; see below.

In Model III, 4, or 4P mode, \fBxtrs\fP emulates the stock floppy
controller, which used a WD1793 chip (software-compatible with the
WD1791) to provide both single and double density.

Four 5.25-inch floppy drives are emulated, with storage in files named
diskM-U, where M is the TRS-80 model (1, 3, 4, or 4p) and U is the drive
unit number (0, 1, 2, or 3).  If a file of the required name is not
found, a drive with no disk in it is emulated (but see below).  If the
user does not have write permission for a floppy file, a write-protect
tab is emulated.  To change floppies in an emulated drive, rename the
existing file for the drive (if any), rename the new floppy file to
the proper name, and hit function key F7 in the emulator.

If you try to boot with no file named diskM-0 (that is, no disk in
drive 0), \fBxtrs\fP emulates having no disk controller.  The behavior of a
real machine with a disk controller in this case didn't seem useful to
emulate faithfully: A real Model I hangs with a screen full of
garbage; a real Model III or 4 goes into a retry loop printing
"Diskette?" on the screen and rechecking whether you've inserted one.

Due to a limitation of the original Model I hardware, drive :3 cannot
be double-sided in Model I mode.  In the original Model I, you could
not have a drive :3 at all if any drive in the system was
double-sided, but the emulator is able to be more forgiving.

Emulated floppy image files can be of either of two types: JV1,
compatible with Jeff Vavasour's popular freeware Model I emulator for
the PC; or JV3, a compatible extension of a format first used in
Vavasour's commercial Model III/4 emulator.  Both types work in
\fBxtrs\fP regardless of what model it is emulating.  A heuristic is
used to decide which type of image is in a drive, as neither type has
a "magic number" or signature.

JV1 supports only single density, single sided, with directory on
track 17.  Sectors must be 256 bytes long.  Use FORMAT (DIR=17) to
format JV1 disks with more (or less) than 35 tracks under LDOS.

JV3 is much more flexible, though it still does not support everything
the real controllers could do.  It is best to use JV3 for all the disk
images you create, unless you need to exchange images with someone who
is using the Vavasour Model I emulator.  A JV3 disk can be formatted
with 128, 256, 512, or 1024-byte sectors, 1 or 2 sides, single or
double density, with either FB (normal) or F8 (deleted) data address
mark on any sector.  You cannot format a sector with an incorrect
track number or head number.  You can format a sector with an
intentional CRC error in the data field.  \fBxtrs\fP supports at most
96 cylinders and at most 5802 total sectors on a JV3 image.

The original Vavasour JV3 format supported only 256-byte sectors, and
had a limit of 2901 total sectors.  If you use sectors sizes other
than 256 bytes or format more than 2901 sectors on a disk image,
emulators other than \fBxtrs\fP may be unable to read it.  Note that
an 80 track, double-sided, double-density (18 sector) 5.25-inch floppy
will fit within the original 2901 sector limit; the extension to 5802
is primarily for emulation of 8-inch drives (see below).

The program \fBmkdisk\fP(1) makes a blank emulated floppy or "bulk
erases" an existing one.  By default, mkdisk makes a JV3 floppy, but
with the -1 flag it makes a JV1 floppy.  See the \fBmkdisk\fP man page
for more information.

Early Model I operating systems used an FA data address mark for the
directory (a nonstandard value supported only by the WD1771, but not
the WD1791/3), while later ones wrote F8 (for Model III/4/4P compatibility)
but could read either.  To deal nicely with this problem, \fBxtrs\fP
implements the following kludge.  On writing, any data address mark
other than FB is recorded as F8.  On reading in single density with
the emulated WD1771 (available in Model I mode only), F8 is returned
as FA.  In all other modes, F8 is returned as F8.  This trick makes
the different operating systems perfectly compatible with each other,
which is better than on a real Model I!

TRS-80 programs that attempt to measure the rotational
speed of their floppy disk drives using timing loops will get the
answers they expect, even though \fBxtrs\fP does not
emulate instructions at the same speed as the original
machines. This works because \fBxtrs\fP keeps a virtual clock 
(technically, a T-state counter),
which measures how much time it should have taken to execute the
instruction stream on a real machine, and it ties the emulation of
floppy disk index holes to this clock.
.SH Emulated 8-inch floppy disks
In addition to the four standard 5.25-inch drives, \fBxtrs\fP also
emulates four 8-inch floppy drives.  There is no widely-accepted
standard hardware interface for 8-inch floppies on the TRS-80, so \fBxtrs\fP
emulates a pseudo-hardware interface of its own and provides a driver for it.

Storage for the emulated 8-inch disks is in files named diskM-U, where
M is the TRS-80 model number (1, 3, 4, or 4P) and U is a unit number (4,
5, 6, or 7).  These files are in exactly the same JV3 format as 5.25-inch
floppy files.  A new JV3 floppy can be formatted as either 5.25-inch or
8-inch depending on whether you initially put it into a 5.25-inch or
8-inch emulated drive.  The only difference between 5.25-inch and 8-inch
emulated drives is that the emulator allows you to format more sectors
per track in the latter.  Be careful not to put a 5.25-inch formatted
emulated floppy into an 8-inch emulated drive or vice versa; the
results are likely to be confusing.

To use the emulated 8-inch drives, you'll need a driver.  Under LDOS
or LS-DOS, use the program XTRS8/DCT supplied on the emulated floppy
\fIutility.dsk\fP.  This driver is a very simple wrapper around the
native LDOS/LS-DOS floppy driver.  Here are detailed instructions.

First, make sure an appropriate version of LDOS is in emulated floppy
drive 0, and the supplied file \fIutility.dsk\fP is in another
emulated floppy drive.  Boot LDOS.  If you are using Model I LDOS, be
sure FDUBL is running.

Second, type the following commands.  Here \fId\fP is the LDOS drive
number you want to use for the 8-inch drive and \fIu\fP is the
unit number you chose when naming the file.  Most likely you will
choose \fId\fP and \fIu\fP to be equal to reduce confusion.

.nf
    SYSTEM (DRIVE=\fId\fP,DRIVER="XTRS8",ENABLE)
    Enter unit number ([4]-7): \fIu\fP
.fi

You can repeat these steps with different values of \fId\fP and
\fIu\fP to have more than one 8-inch drive.  You might want to repeat
four times using 4, 5, 6, and 7, or you might want to save some drive
numbers for hard drives (see below).

Finally, it's a good idea to give the SYSTEM (SYSGEN) command (Model
I/III) or SYSGEN command (Model 4/4P).  This command saves the SYSTEM
settings, so the 8-inch drives will be available again the next time
you reboot or restart the emulator.  If you need to access an 8-inch
drive after booting from a disk that hasn't been SYSGENed, simply use
the same SYSTEM command again.

In case you want to write your own driver for another TRS-80 operating
system, here are details on the emulated pseudo-hardware.  The 8-inch
drives are accessed through the normal floppy disk controller, exactly
like 5.25-inch drives.  The four 5.25-inch drives have hardware select codes
1, 2, 4, and 8, corresponding respectively to files diskM-0, -1, -2, and
-3.  The four 8-inch drives have hardware select codes 3, 5, 6, and 7,
corresponding respectively to files diskM-4, -5, -6, and -7.
.SH Real floppy disks
Under Linux only, any diskM-U file can be a symbolic link to a real
floppy disk drive, typically /dev/fd0 or /dev/fd1.  Most PCs should be
able to read and write TRS-80 compatible floppies in this way.  Many
PC floppy controllers cannot handle single density, however, and some
may have problems even with double density disks written on a real
TRS-80, especially disks formatted by older TRS-80 operating systems.
Use the -doublestep flag if you need to read 35-track or 40-track
media in an 80-track drive.  If you need to write 35-track or 40-track
media in an 80-track drive, bulk-erase the media first and format it
in the 80-track drive.  Don't write to a disk in an 80-track drive if it
has ever been written to in a 40-track drive.  The narrower head used
in an 80-track drive cannot erase the full track width written by the
head in a 40-track drive.

If you link one of the 5.25-inch floppy files (diskM-0 through
diskM-3) to a real floppy drive, TRS-80 programs will see it as a
5.25-inch drive, but the actual drive can be either 3.5-inch or
5.25-inch.  The drive will be operated in double density (or single
density), not high density, so be sure to use the appropriate media.

If you link one of the 8-inch floppy files (diskM-4 through diskM-7)
to a real floppy drive, TRS-80 programs will see it as an 8-inch
drive.  Again, you need to use the XTRS8/DCT driver described above to
enable LDOS/LS-DOS to access an 8-inch drive.  The real drive can be
either 3.5-inch, 5.25-inch, or 8-inch.  A 3.5-inch or 5.25-inch drive
will be operated in high-density mode, using MFM recording if the
TRS-80 is trying to do double density, FM recording if the TRS-80 is
trying to do single density.  In this mode, these drives can hold as
much data as a standard 8-inch drive.  In fact, a 5.25-inch HD drive
holds exactly the same number of bits per track as an 8-inch drive; a
3.5-inch HD drive can hold 20% more, but we waste that space when
using one to emulate an 8-inch drive.  In both cases we also waste the
top three tracks, since an 8-inch drive has only 77 tracks, not 80.

If you try to access a real floppy drive with no disk in it,
\fBxtrs\fP will print an error message, and the Z-80 program will get
a somewhat different error than it should.  After inserting a disk,
you must press F7 to clear the error condition.
.SH Emulated hard disks
\fBxtrs\fP can emulate a hard disk in a file with the aid of a special
LDOS driver called XTRSHARD/DCT.  This driver has been tested and
works under both LDOS 5.3.1 for Model I or III and TRSDOS/LS-DOS 6.3.1
for Model 4/4P.  It may or may not work under earlier LDOS versions.  It
definitely will not work under other TRS-80 operating systems or with
emulators other than \fBxtrs\fP.  The hard disk format was designed by
Matthew Reed for his Model I/III and Model 4 emulators; \fBxtrs\fP
duplicates the format so that users can exchange hard drive images
across the emulators.

To use the hard disk emulation, first run the \fBmkdisk\fP program
under Unix to create a blank hard drive (.hdv) file.  Typical usage
would be: \fImkdisk -h mydisk.hdv\fP.  See the \fBmkdisk\fP(1) man
page for other options.

Second, link the file to an appropriate name.  \fBxtrs\fP supports up
to eight hard drives, with names of the form hardM-U, where M is the
TRS-80 model (1, 3, or 4; in this case Model 4P also uses M=4) and U
is a unit number from 0 to 7.  It looks for these files in the same
directory as the floppy disk files diskM-U.

Third, make sure an appropriate version of LDOS is in emulated floppy
drive 0, and the supplied file \fIutility.dsk\fP is in another
emulated floppy drive.  Boot LDOS.  If you are using Model I LDOS
5.3.1, patch a bug in the FORMAT command by typing \fIPATCH
FORMAT/CMD.UTILITY M1FORMAT/FIX\fP.  You need to apply this patch only
once.  It must not be applied to Model III or Model 4/4P LDOS.

Fourth, type the following commands.  Here \fId\fP is the LDOS drive number
you want to use for the hard drive (a typical choice would be 4) and \fIu\fP
is the unit number you chose when naming the file (most likely 0).

.nf
    SYSTEM (DRIVE=\fId\fP,DRIVER="XTRSHARD",ENABLE)
    Enter unit number ([0]-7): \fIu\fP
    FORMAT \fId\fP (DIR=1)
.fi

Answer the questions asked by FORMAT as you prefer.  If you are
curious about the \fIDIR=1\fP parameter to FORMAT, see
\fBmkdisk\fP(1).  You can repeat these steps with different values of
\fId\fP and \fIu\fP to have more than one hard drive.

Finally, it's a good idea to give the SYSTEM (SYSGEN) command (Model
I/III) or SYSGEN command (Model 4/4P).  This command saves the SYSTEM
settings, so the drive will be available again the next time you
reboot or restart the emulator.  If you need to access the hard disk
file after booting from a floppy that hasn't been SYSGENed, simply use
the same SYSTEM command(s) again, but don't FORMAT.  You can freely
use a different drive number or (if you renamed the hard disk file) a
different unit number.

The F7 key currently doesn't allow hard disk changes to be recognized,
but you can change to a different hard disk file for the same unit by
renaming files as needed and rebooting LDOS.

Technical note: XTRSHARD/DCT is a small Z-80 program that implements
all the required functions of an LDOS disk driver.  Instead of talking
to a real (or emulated) hard disk controller, however, it uses special
support in \fBxtrs\fP that allows Z-80 programs to open, close, read,
and write Unix files directly.  This support is described further in
the next section.  Because \fBxtrs\fP does not emulate real hard drive
controller hardware, hard disk drivers other than XTRSHARD/DCT will
not work with it.
.SH Data import and export
The emulated floppy \fIutility.dsk\fP contains some programs for
transferring data between the emulator and ordinary Unix files.  All
these programs run on the emulator under Model I/III LDOS, Model I/III
Newdos/80, and Model 4/4P TRSDOS/LS-DOS 6; they may also work under other
TRS-80 operating systems.

IMPORT/CMD imports a Unix file and writes it to an emulated disk.
Usage: \fIIMPORT [-ln] unixfile trsfile\fP.  The -n flag converts Unix
newlines (\\n) to TRS-80 newlines (\\r).  The -l flag converts the Unix
filename to lower case, to compensate for TRS-80 operating systems
such as Newdos/80 that convert all command line arguments to upper case.
IMPORT/BAS is a much slower program that performs the same function
but may work under more operating systems.  Simply run it under Disk
Basic and answer the prompts.

EXPORT/CMD reads a file from an emulated disk and exports it to a Unix
file. Usage: \fIEXPORT [-ln] trsfile unixfile\fP.  The -n flag
converts TRS-80 newlines (\\r) to Unix newlines (\\n).  The -l flag
converts the Unix filename to lower case, to compensate for TRS-80
operating systems such as Newdos/80 that convert all command line
arguments to upper case.  EXPORT/BAS is a much slower program that
performs the same function but may work under more operating systems.
Simply run it under Disk Basic and answer the prompts.

SETTIME/CMD reads the date and time from Unix and sets the TRS-80
DOS's date and time accordingly.

The emulated floppy \fIcpmutil.dsk\fP contains similar programs
for Montezuma CP/M, written by Roland Gerlach. 
It was formatted as a ``Montezuma Micro Standard SYSTEM disk
(40T, SS, DD, 170K),'' but does not contain a copy of CP/M.
Source code is included on the floppy; please pass any improvements
you make back to the author.

IMPORT.COM imports a Unix file and writes it to an emulated CP/M disk.
Usage: \fIIMPORT [-n] [unixfile [cpmfile]]\fP.  The -n flag converts
Unix newlines (\\n) to CP/M newlines (\\r\\n).  If the second filename
is omitted, it is taken to be the same as the first. If both names are
omitted, the program prompts for filenames.  Note that the CP/M CCP
converts all command line arguments to upper case, which is
inconvenient if your Unix file names are in lower case; in that case
you'll need to let the program prompt for the filenames.

EXPORT.COM reads a file from an emulated CP/M disk and exports it to a
Unix file.  Usage: \fIEXPORT [-n] [cpmfile [unixfile]]\fP.  The -n
flag converts CP/M newlines (\\r\\n) to Unix newlines (\\n).  If the
second filename is omitted, it is taken to be the same as the
first. If both names are omitted, the program prompts for filenames.
Note that the CP/M CCP converts all command line arguments to upper
case, which is inconvenient if your Unix file names are in lower case;
in that case you'll need to let the program prompt for the filenames.

The emulator implements a set of pseudo-instructions (emulator traps)
that give TRS-80 programs access to Unix files.  The programs listed
above use them.  If you would like to write your own such programs,
the traps are documented in the file trs_imp_exp.h.  Assembler
source code for the existing programs is supplied in xtrshard.z,
import.z, export.z, and settime.z.  You can also write programs that
use the traps in Misosys C, using the files xtrsemt.h and xtrsemt.ccc
as an interface; a simple example is in settime.ccc.  The Basic
programs import.bas and export.bas should not be used as a basis for
further development, however; they use an old, slow mechanism in the
emulator that may be removed in a future release rather than the
emulator traps.
.SH Interrupts
The emulator supports only interrupt mode 1.  It will complain if your
program enables interrupts after powerup without executing an IM 1
instruction first.  All Model I/III/4/4P software does this, as the
built-in peripherals in these machines supported only IM 1.

The Model I has a 40 Hz "heartbeat" clock interrupt, while the Model
III used 30 Hz, and the Model 4/4P could run at either 30 Hz or 60 Hz.
The emulator approximates this rather well even on a system where
clock ticks come at some frequency that isn't divisible by the
emulated frequency (e.g., 100 Hz on Intel Linux), as long as the true
frequency is not slower than the emulated frequency.  The emulator has
a notion of the absolute time at which each tick is supposed to occur,
and it asks the host system to wake it up at each of those times.  The
net result is that some ticks may be late, but there are always the
proper number of ticks per second.  For example, running in Model I
mode on Intel Linux you'd see this pattern: (tick, 30ms, tick,
20ms,...) instead of seeing ticks every 25ms.
.SH Sound
Crude sound support is available on Linux.  Unfortunately, the Linux
sound drivers do not provide sufficiently low-level functionality, so
the emulator must write directly to the hardware.  Thus in order for
the sound support to work, you must have a true
SoundBlaster-compatible sound card, and you must start \fBxtrs\fP as
root.  (If you make \fBxtrs\fP setuid to root, it will disable its
root privileges immediately after sound initialization.)

Sound support is off by default, but can be turned on with the -sb
option described below.  When sound support is on, any data written to
the TRS-80 cassette port when the cassette motor is off, and any data
written to the Model 4/4P optional sound port, is copied to the
SoundBlaster.  TRS-80 sound depends on timing loops, so the pitches
will be wildly wrong unless you use the -autodelay option described
below.  Even with -autodelay, don't expect pitches to be accurate or stable.
.SH Mouse
A few Model 4 programs could use a mouse, such as the shareware hi-res
drawing program MDRAW-II. The program XTRSMOUS/CMD on the utility disk
(utility.dsk) is a mouse driver for Model 4/4P mode that should work
with most such programs.  \fBxtrs\fP does not emulate the actual mouse
hardware (a serial mouse plugged into the Model 4 RS-232 port), so the
original mouse drivers will not work under \fBxtrs\fP.  Instead,
XTRSMOUS accesses the X mouse pointer using an emulator trap.
XTRSMOUS implements the same TRSDOS/LS-DOS 6 SVC interface as the
David Goben and Matthew Reed mouse drivers. (It does not implement the
interface of the older Scott McBurney mouse driver, which may be
required by some older programs.)

By default XTRSMOUS installs itself in high memory. This is done
because MDRAW-II tests for the presence of a mouse by
looking to see whether the mouse SVC is vectored to high memory. If the
driver is installed in low memory, MDRAW thinks it is not there at
all. If you use mouse-aware programs that don't have this bug, or if
you edit the first line of MDRAW to remove the test, you can install
XTRSMOUS in low memory using the syntax ``XTRSMOUS (LOW)''.
.SH Running games
Some games run rather well under \fBxtrs\fP now, 
provided that your
machine is fast enough to run the emulation in real time and that you
choose the right command line options.  
Galaxy Invaders Plus by Big 5 Software is particularly good.
You will usually want to turn on sound support and autodelay, and
you'll often need to tweak the keystretch setting.  
Running your X server in 8-bit/pixel mode 
also seems to help. Sample command lines:

.nf
    startx -- -bpp 8
    xtrs -sb 0x220,60 -keystretch 2,1,2 -autodelay
.fi

If the keyboard seems to miss keystrokes entirely, you may need to
increase the first number in the keystretch setting.  If you get an
unwanted type-ahead effect, where keys that you hit after one screen
is finished show up on the next screen, try reducing the first number,
and set the last number equal to the first number.
See -keystretch below for more information.  This aspect of the
emulator seems to need a bit more work.
.SH Options
Defaults for all options can be specified using the standard X resource
mechanism, and the class name for \fBxtrs\fP is "Xtrs".
.TP
.B \-display \fIdisplay\fP
Set your X display to \fIdisplay\fP. The default is to
use the DISPLAY environment variable.
.TP
.B \-background \fIcolor\fP
.PD 0
.TP
.B \-bg \fIcolor\fP
.PD
Specifies the background color of the \fBxtrs\fP window.
.TP
.B \-foreground \fIcolor\fP
.PD 0
.TP
.B \-fg \fIcolor\fP
.PD
Specifies the foreground color of the \fBxtrs\fP window.
.TP
.B \-borderwidth \fIwidth\fP
Put a border of \fIwidth\fP pixels
around the TRS-80 display.  The default is 2.
.TP
.B \-resize
In Model 4/4P mode, resize the X window whenever the emulated display
mode changes between 64x16 and 80x24.
.TP
.B \-noresize
In Model 4/4P mode, always keep the X window large enough for 80x24
characters, putting a blank margin around the outside when the emulated
display mode is 64x16.  This is the default.
.TP
.B \-usefont
Use X fonts instead of the built-in character bitmaps.
Some suitable fonts are supplied with \fBxtrs\fP; they are
exactly the same as the built-in bitmaps, but drawing performance
may be better when using fonts.  See the \fBxset\fP(1) man page for
documentation on how to install fonts in your X server.
.TP
.B \-nofont
Use the built-in character bitmaps, not a X font.  This is the default.
.TP
.B \-font \fIfontname\fP
If -usefont is also given,
use the specified X font for normal width characters.
The default uses the supplied fonts.
.TP
.B \-widefont \fIfontname\fP
If -usefont is also given,
use the specified X font for double width characters.
The default uses the supplied fonts, scaled to double width.
.TP
.B \-trsfont
Use the specified X fonts for TRS-80 graphics blocks as well as
characters.  Meaningful only if -usefont is given.  This is the
default if the X font name begins with "-trs80".
.TP
.B \-notrsfont
Draw TRS-80 graphics blocks as bitmaps even if X fonts are being used
for characters.  This is the
default if the X font name does not begin with "-trs80".
.TP
.B \-microlabs
In Model 4/4P mode, emulate the Micro Labs Grafyx Solution hi-res
graphics card.  This is the default.
.TP
.B \-nomicrolabs
In Model 4/4P mode, emulate the Radio Shack hi-res card.
.TP
.B \-debug
Enter zbx, the z80 debugger.
.TP
.B \-romfile \fIfilename\fP
.PD 0
.TP
.B \-romfile3 \fIfilename3\fP
.TP
.B \-romfile4p \fIfilename4p\fP
.PD
Use the romfile specified by \fIfilename\fP in Model I mode, the
romfile specified by \fIfilename3\fP in Model III and Model 4 mode,
or the romfile specified by \fIfilename4p\fP in Model 4P mode,
A romfile can be either a raw binary dump, Intel hex format, or
TRS-80 cmd format (for example, a modela/iii file).
If you do not set this option or the corresponding X resource, a default
established at compile time is used (if any); see Makefile.local for
instructions on compiling in default romfiles or default romfile names.
.TP
.B \-model \fIm\fP
Specifies which TRS-80 model to emulate.  Values accepted are 1 or I (Model
I), 3 or III (Model III), 4 or IV (Model 4), and 4P or IVP (Model 4P).
Model I is the default. 
.TP
.B \-delay \fId\fP
A crude speed control.  After each Z-80 instruction, xtrs busy-waits
for \fId\fP iterations around an empty loop.  A really smart C optimizer
might delete this loop entirely, so it's possible that this option
won't work if you compile xtrs with too high an optimization level.
The default delay is 0.
.TP
.B \-autodelay
Dynamically adjusts the value of -delay to run instructions at roughly
the same rate as a real machine.  The tracking is only approximate,
but it can be useful for running games and playing sounds.
.TP
.B \-autodelay
Turn off -autodelay. This is the default.
.TP
.B \-keystretch \fIamount,poll,heartbeat\fP
Fine-tune the keyboard behavior.  To prevent keystrokes from being
lost, xtrs "stretches" the intervals between key transitions, so that
the Z-80 program has time to see each transition before the next one
occurs.  Whenever an emulated key goes up or down, xtrs sets a counter
to \fIamount\fP.  While the counter is greater than zero, (1) any
further key transitions are held in a queue instead of being passed
immediately to the Z-80, (2) whenever the Z-80 program reads from the
keyboard matrix, the counter is decremented by \fIpoll\fP, and (3)
whenever a TRS-80 heartbeat interrupt is scheduled to occur (even if
interrupts are disabled), the counter is decremented by
\fIheartbeat\fP.  The default setting is "16,1,1"; this seems to work
well with ordinary keyboard drivers, but you may want to experiment
with different values for games if keyboard response seem sluggish.
.TP
.B \-doubler \fItype\fP
Specify what type of double density adaptor to emulate (Model I mode only).
The \fItype\fP may be \fIpercom\fP, \fIradioshack\fP (or \fItandy\fP),
\fIboth\fP, or \fInone\fP. The type may be abbreviated to one character.
The default is \fIboth\fP, which causes the double density adaptor emulation
to respond to the special commands of both the Percom and Radio Shack cards.
.TP
.B \-doublestep
Make real floppy drives double-step, allowing access to 35-track or
40-track media in an 80-track drive.  Linux only.  See the Floppy Disks
section for limitations.
.TP
.B \-nodoublestep
Turn off double-step mode.  Linux only.  This is the default.
.TP
.B \-sb \fIportbase,vol\fP
Enable sound support, using a SoundBlaster with I/O port base 
at \fIportbase\fP, and playing sounds at \fIvol\fP percent of maximum
volume.  A typical setting would be -sb 0x220,30.
.SH Additional resources
There are many other TRS-80 resources available on the Web, including
shareware and freeware emulators that run under MSDOS and other
operating systems, software for converting TRS-80 physical media to
the emulator's disk file format, ROM images, and TRS-80 software that
has already been converted.  For pointers, see
http://www.research.digital.com/SRC/personal/Tim_Mann/trs80.html.
.SH Bugs and limitations
There may be bugs in the Z-80 emulator which we haven't found yet.
Some of the more bizarre undocumented Z-80 instructions and behaviors
are not implemented.

Cassette emulation works only in Model I mode, and only for programs
that use the Level II ROM routines to access the cassette; the
emulator looks for access to the cassette port from specific PC values
to activate the feature.  If someone wants to disassemble the Model
III ROM and figure out what PC values to look for, cassette emulation
could be made to work there too.

Serial ports are not emulated.

The Model III/4/4P alternate character set is not emulated.

Some features of the disk controller are not currently emulated.  (1)
Force Interrupt with condition bits 0x01, 0x02, or 0x04 is not
implemented.  (2) Read Track is not implemented.  (3) The
multiple-sector flags in Read and Write are not implemented.  Certain
errors (such as Lost Data) cannot occur, which makes disk diagnostic
programs that try to generate them on purpose unhappy.

Real physical floppy disks are supported only under Linux, because
Unix does not provide a portable interface to the low-level floppy
controller functionality that \fBxtrs\fP needs.  There are some
limitations even under Linux: Index holes are faked, not detected on
the real disk.  Attempts to access a real drive with no disk in it are
dealt with awkwardly (as documented above).  Due to a limitation of
PC-style floppy disk controllers, \fBxtrs\fP does not support mixing
sectors of different sizes on the same track when formatting a real
floppy. However, \fBxtrs\fP can read and write to such floppies if
they are already formatted (perhaps by a real TRS-80).

The emulator arbitrarily limits both JV1 and JV3 disk images to 96
tracks.  The limit could easily be increased to 255 or maybe 256, but
that would probably not be useful with existing TRS-80 operating
systems, which don't expect floppies to have so many tracks.  For
example, LDOS 5.3.1 allows at most 95 tracks on a floppy, though it
allows more on hard drives.  256 tracks is an absolute maximum for the
TRS-80 floppy disk controller and for the JV3 format.

The extended JV3 limit of 5802 sectors is somewhat arbitrary as well.
It could be raised by generalizing the code to permit more than two
blocks of 2901.  Again, this does not seem too useful.  5802 sectors
is already enough for a 3.5-inch HD (1.44MB) floppy, which the TRS-80 didn't
support anyway.

The emulator uses a heuristic to decide what format a ROM file is in.
If a raw binary ROM image starts with 0x01, 0x05, or 0x22, it can be
misidentified as being in a different format.  This is rather unlikely
to occur, as ROMs typically begin with 0xF3, the DI instruction.

If you discover other bugs, or write fixes for any of these, please let
us know.  We expect to incorporate fixes into future releases.
.SH Authors and acknowledgements
\fBxtrs\fP was written by David Gingold <gingold@think.com> of
Thinking Machines Corporation, Alec Wolman <wolman@crl.dec.com> of
Digital Equipment Corporation, and Timothy Mann <mann@pa.dec.com> of
Digital Equipment Corporation.  See README and README.tpm for
additional notes from the authors.

We also thank the following people for their help.  The floppy disk
file formats were designed by Jeff Vavasour, originally for his
MSDOS-based TRS-80 emulators.  The hard disk file format was designed
by Matthew Reed for his MSDOS-based TRS-80 emulators.  Al Petrofsky
supplied the TRS-80 fonts in bdf format.  Roland Gerlach contributed
the CP/M import and export programs as well as several bug reports
and fixes for the emulator itself.  Fabio Ferrari contributed the
sound support.  Ulrich Mueller added the -borderwidth option and
ported the import, export, and settime utilities to Newdos/80.
Branden Robinson supplied the cassette man page and fixed Makefile
bugs.  Mark McDougall provided documentation for the Micro Labs Grafyx
Solution card.

