#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

extern struct setup Setup;
extern struct stat Stat;
FD_configure *f_configure;
struct setup backup;

void configure_setfields(struct setup *val);
void configure_getfields(struct setup *val);
int fileStrInput(FILE *fichier, char *string, char chr);
void configure_readfile(struct setup *val);



int fileStrInput(FILE *fichier, char *string, char chr)
									       /* fichier d'ou lire le string     */
									       /* pointe ou mettre le string lu   */
									       /* caractere de fin de string      */
{
  int i, c;

  i = 0;
  for(;;)
  {
    c = fgetc(fichier);
    if(c != '\n' && c != EOF)
    {
      if(c == chr) break;
      string[i++] = (unsigned char) c;
    }
    else break;
  }
  string[i] = '\0';

  if(c == EOF && i == 0)  return(EOF); else return(i);
}




void configure_setfields(struct setup *val)
{
  char str[11];
  fl_set_input(f_configure->host           , val->host);
  fl_set_input(f_configure->user           , val->user);
  fl_set_input(f_configure->password       , val->password);
  fl_set_input(f_configure->datapath       , val->datapath);
  fl_set_input(f_configure->port           , val->port);

  sprintf(str, "%d", val->statusRefreshTime);
  fl_set_input(f_configure->status_refresh , str);
  
  sprintf(str, "%d", val->threadsRefreshTime);
  fl_set_input(f_configure->threads_refresh, str);
  
  sprintf(str, "%d", val->reloadRefreshTime);
  fl_set_input(f_configure->reload_refresh , str);
  
  sprintf(str, "%d", val->statusMaxLines);
  fl_set_input(f_configure->status_lines   , str);
  
  sprintf(str, "%d", val->reloadMaxLines);
  fl_set_input(f_configure->reload_lines   , str);
}

void configure_getfields(struct setup *val)
{
  char str[11];

  strcpy(val->host, fl_get_input(f_configure->host));
  strcpy(val->user, fl_get_input(f_configure->user));
  strcpy(val->password, fl_get_input(f_configure->password));
  strcpy(val->datapath, fl_get_input(f_configure->datapath));
  strcpy(val->port, fl_get_input(f_configure->port));
  
  strcpy(str, fl_get_input(f_configure->status_refresh));
  val->statusRefreshTime = atoi(str);

  strcpy(str, fl_get_input(f_configure->threads_refresh));
  val->threadsRefreshTime = atoi(str);
  
  strcpy(str, fl_get_input(f_configure->reload_refresh));
  val->reloadRefreshTime = atoi(str);
  
  strcpy(str, fl_get_input(f_configure->status_lines));
  val->statusMaxLines = atoi(str);
  
  strcpy(str, fl_get_input(f_configure->reload_lines));
  val->reloadMaxLines = atoi(str);
}


void main_configure(FL_OBJECT *obj, long data)
{
  if(Stat.flagConfigure) return;
  Stat.flagConfigure=1;

  memcpy(&backup, &Setup, sizeof(struct setup));
  
  f_configure = create_form_configure();

  fl_set_input_maxchars(f_configure->host            , 60);
  fl_set_input_maxchars(f_configure->user            , 14);
  fl_set_input_maxchars(f_configure->password        , 20);
  fl_set_input_maxchars(f_configure->port            , 4);
  fl_set_input_maxchars(f_configure->datapath        , 128);
  fl_set_input_maxchars(f_configure->status_refresh  , 4);
  fl_set_input_maxchars(f_configure->threads_refresh , 4);
  fl_set_input_maxchars(f_configure->reload_refresh  , 4);
  fl_set_input_maxchars(f_configure->status_lines    , 3);
  fl_set_input_maxchars(f_configure->reload_lines    , 3);
  configure_setfields(&Setup);
  fl_show_form(f_configure->configure, FL_PLACE_MOUSE, FL_TRANSIENT, "xMySQLadmin configure");
}

void configure_close(FL_OBJECT *obj, long data)
{
  fl_hide_form(f_configure->configure);
  fl_free_form(f_configure->configure);
  free(f_configure);
  Stat.flagConfigure=0;
}

void configure_readfile(struct setup *val)
{
  FILE *f1;

  {
    char filename[81];
  
    sprintf(filename, "%s/.xmysqladminrc", getenv("HOME"));
    f1 = fopen(filename, "r");
    if(f1 == NULL)
    {
      fl_show_messages("Can't read the config file!");
      return;
    }
  }
  
  {
    char scmd[41], value[128];
    int c;
    
    do
    {
      c = fileStrInput(f1, scmd, ',');
      if(c != EOF) c = fileStrInput(f1, value, ',');
      if(c != EOF)
      {
  	if(!strcmp(scmd, "host"))     strcpy(val->host, value);
	if(!strcmp(scmd, "user"))     strcpy(val->user, value);
	if(!strcmp(scmd, "datapath")) strcpy(val->datapath, value);
	if(!strcmp(scmd, "port"))     strcpy(val->port, value);
	if(!strcmp(scmd, "statusRefreshTime")) 
	  val->statusRefreshTime = atoi(value);
	if(!strcmp(scmd, "threadsRefreshTime"))
	    val->threadsRefreshTime = atoi(value);
	if(!strcmp(scmd, "reloadRefreshTime"))
	    val->reloadRefreshTime = atoi(value);
	if(!strcmp(scmd, "statusMaxLines"))
	    val->statusMaxLines = atoi(value);
	if(!strcmp(scmd, "reloadMaxLines"))
	    val->reloadMaxLines = atoi(value);
      }
    } while( c != EOF);
    
  }
  
  fclose(f1);
}

void configure_load(FL_OBJECT *obj, long data)
{
  configure_readfile(&Setup); 
  configure_setfields(&Setup);  
}

void configure_save(FL_OBJECT *obj, long data)
{
  FILE *f1;
  char filename[81];
  
  sprintf(filename, "%s/.xmysqladminrc", getenv("HOME"));
  f1 = fopen(filename, "w");
  if(f1 == NULL)
    {
      fl_show_messages("Can't create the file!");
      return;
    }
  configure_getfields(&Setup);

  fprintf(f1, "host,%s\n", Setup.host);
  fprintf(f1, "user,%s\n", Setup.user);
  fprintf(f1, "port,%s\n", Setup.port);
  fprintf(f1, "datapath,%s\n", Setup.datapath);
  fprintf(f1, "statusRefreshTime,%d\n", Setup.statusRefreshTime);  
  fprintf(f1, "statusMaxLines,%d\n", Setup.statusMaxLines);  
  fprintf(f1, "threadsRefreshTime,%d\n", Setup.threadsRefreshTime);  
  fprintf(f1, "reloadRefreshTime,%d\n", Setup.reloadRefreshTime);  
  fprintf(f1, "reloadMaxLines,%d\n", Setup.reloadMaxLines);  
  
  fclose(f1);
}
void configure_apply(FL_OBJECT *obj, long data)
{
  configure_getfields(&Setup);
}
void configure_revert(FL_OBJECT *obj, long data)
{
  fl_freeze_form(f_configure->configure);
  configure_setfields(&backup);
  fl_unfreeze_form(f_configure->configure);
}

void configure_callback(FL_OBJECT *obj, long data)
{
  ;
}
