// Copyright (c) 1997,1998 Albrecht Kleine    All rights reserved
// Copyright (c) 1998 Artur Biesiadowski, Rene Schmit, Olivier Refalo
//
// tya file version #200

#include "tyaconfig.h"
#include <stdio.h>
#ifdef USE_SYSLOG
#include <syslog.h>
#endif
#include <native.h>
#include <monitor.h>
#include "tya.h"


#ifdef VERBOSE_ASM86
const char* rname[] =
{
	"eax", "ecx", "edx", "ebx", "esp", "ebp","esi", "edi"
};

const char* rname8[] =
{
	"al","cl","dl","bl","ah","ch","dh","bh"
};

int decode_sib_scale[] =
{
	1, 2 , 4 ,8
};

// utility function do decode sib encodings
const char * sibdecode( int sibbyte )
{
	static char answer[20];
	int regscaled;
	int regoffset;
	int scale;
	regoffset = sibbyte & 0x07;
	regscaled = (sibbyte & 0x38) >> 3;
	scale = decode_sib_scale[ (sibbyte & 0xc0)>>6];
	sprintf( answer, "%s+%d*%s", rname[regoffset], scale, rname[regscaled]);
	return answer;
}

//----------------utility functions to decode bytecode-------------------- 

int readU2(unsigned char *p)
{
   int x;
   x =*(p)<<8;
   p++;
   x+=*p;
   return x;
}

int readU4(unsigned char *p)
{
  int x;
  x =*(p)<<24;
  p++;
  x+=*(p)<<16;
  p++;
  x+=*(p)<<8;
  p++;
  x+=*p;
  return x;
}

int oneParamByte(unsigned char *code)
{
        char b=*code;
        iprintf("%d",b);
        return 1;
}

int twoParamByte(unsigned char *code)
{
        char b,c;
        b=*code;
        c=*(code+1);
        iprintf("%d %d",b,c);
        return 2;
}


int newArrayParam(unsigned char *code)
{
   char c;
   iprintf("%d",readU2(code));
   c=*(code+2);
   iprintf(" %d",c);
   return 3;
}


int oneParamLong(unsigned char *code)
{
        iprintf("%d",readU4(code));
        return 4;
}       


int oneParamShort(unsigned char *code)
{
        iprintf("%d",readU2(code) );
        return 2;
}

int interfaceParam(unsigned char *code)
{
        char c;
        iprintf("%d",readU2(code));
        c=*code;
        iprintf("%d",c);
        return 4;
}

int nopParam(unsigned char *code)
{
	return 1;
}

               
struct java_opcodes
{
   char *name;                           /* opcode name */
   int (*print_param)(unsigned char *code); /* function to print its parameters */
};

struct java_opcodes opcodes[256] = {
        { "nop", nopParam },
        { "aconst_null", NULL },
        { "iconst_m1", NULL },
        { "iconst_0", NULL },
        { "iconst_1", NULL },
        { "iconst_2", NULL },
        { "iconst_3", NULL },
        { "iconst_4", NULL },
        { "iconst_5", NULL },
        { "lconst_0", NULL },
        { "lconst_1", NULL },
        { "fconst_0", NULL },
        { "fconst_1", NULL },
        { "fconst_2", NULL },
        { "dconst_0", NULL },
        { "dconst_1",NULL },
        { "bipush", oneParamByte },
        { "sipush", oneParamShort },
        { "ldc" , oneParamByte },
        { "ldc_w",  oneParamShort },
        { "ldc2_w", oneParamShort },
        { "iload", oneParamByte },
        { "lload", oneParamByte  },
        { "fload", oneParamByte },
        { "dload", oneParamByte },
        { "aload", oneParamByte },
        { "iload_0",NULL },
        { "iload_1",NULL },
        { "iload_2",NULL },
        { "iload_3",NULL },
        { "lload_0",NULL },
        { "lload_1",NULL },
        { "lload_2",NULL },
        { "lload_3",NULL },
        { "fload_0",NULL },
        { "fload_1",NULL },
        { "fload_2",NULL },
        { "fload_3",NULL },
        { "dload_0",NULL },
        { "dload_1",NULL },
        { "dload_2",NULL },
        { "dload_3",NULL },
        { "aload_0",NULL },
        { "aload_1",NULL },
        { "aload_2",NULL },
        { "aload_3",NULL },
        { "iaload", NULL }, 
        { "laload", NULL },
        { "faload", NULL },
        { "daload", NULL },
        { "aaload", NULL },
        { "baload", NULL },
        { "caload", NULL },
        { "saload", NULL },
        { "istore", oneParamByte },
        { "lstore", oneParamByte },
        { "fstore", oneParamByte },
        { "dstore", oneParamByte },
        { "astore", oneParamByte },
        { "istore_0", NULL },
        { "istore_1", NULL },
        { "istore_2", NULL },
        { "istore_3", NULL },
        { "lstore_0", NULL },
        { "lstore_1", NULL },
        { "lstore_2", NULL },
        { "lstore_3", NULL },
        { "fstore_0", NULL },
        { "fstore_1", NULL },
        { "fstore_2", NULL },
        { "fstore_3", NULL },
        { "dstore_0", NULL },
        { "dstore_1", NULL },
        { "dstore_2", NULL },
        { "dstore_3", NULL },
        { "astore_0", NULL },
        { "astore_1", NULL },
        { "astore_2", NULL },
        { "astore_3", NULL },
        { "iastore",  NULL },
        { "lastore",  NULL },
        { "fastore",  NULL },
        { "dastore",  NULL },
        { "aastore",  NULL },
        { "bastore",  NULL },
        { "castore",  NULL },
        { "sastore",  NULL },
        { "pop",      NULL },
        { "pop2",     NULL },
        { "dup", NULL },
        { "dup_x1", NULL },
        { "dup_x2", NULL },
        { "dup2", NULL },
        { "dup2_x1", NULL },
        { "dup2_x2", NULL },
        { "swap", NULL},
        { "iadd", NULL },
        { "ladd", NULL },
        { "fadd", NULL },
        { "dadd", NULL},
        { "isub", NULL },
        { "lsub", NULL },
        { "fsub", NULL },
        { "dsub", NULL },
        { "imul", NULL },
        { "lmul", NULL },
        { "fmul", NULL },
        { "dmul", NULL },
        { "idiv", NULL },
        { "ldiv", NULL },
        { "fdiv", NULL },
        { "ddiv", NULL },
        { "irem", NULL },
        { "lrem", NULL },
        { "frem", NULL },
        { "drem", NULL },
        { "ineg", NULL },
        { "lneg", NULL },
        { "fneg", NULL },
        { "dneg", NULL },
        { "ishl", NULL },
        { "lshl", NULL },
        { "ishr", NULL },
        { "lshr", NULL },
        { "iushr", NULL },
        { "lushr", NULL },
        { "iand", NULL },
        { "land", NULL },
        { "ior", NULL },
        { "lor", NULL },
        { "ixor", NULL },
        { "lxor", NULL },
        { "iinc", twoParamByte },
        { "i2l", NULL },
        { "i2f", NULL },
        { "i2d", NULL },
        { "l2i", NULL },
        { "l2f", NULL },
        { "l2d", NULL },
        { "f2i", NULL },
        { "f2l", NULL },
        { "f2d", NULL },
        { "d2i", NULL },
        { "d2l", NULL },
        { "d2f", NULL },
        { "i2b", NULL },
        { "i2c", NULL },
        { "i2s", NULL },
        { "lcmp", oneParamShort },
        { "fcmpl", oneParamShort },
        { "fcmpg", oneParamShort },
        { "dcmpl", oneParamShort },
        { "dcmpg", oneParamShort },
        { "ifeq", oneParamShort  },
        { "ifne", oneParamShort  },
        { "iflt", oneParamShort  },
        { "ifge", oneParamShort  },
        { "ifgt", oneParamShort  },
        { "ifle", oneParamShort  },
        { "if_icmpeq",oneParamShort },
        { "if_icmpne",oneParamShort },
        { "if_icmplt",oneParamShort },
        { "if_icmpge",oneParamShort },
        { "if_icmpgt",oneParamShort },
        { "if_icmple",oneParamShort },
        { "if_acmpeq",oneParamShort },
        { "if_acmpne",oneParamShort },
        { "goto",oneParamShort },
        { "jsr",oneParamShort },
        { "ret", oneParamByte },
        { "tableswitch", NULL }, 
        { "lookupswitch", NULL }, 
        { "ireturn",NULL },
        { "lreturn",NULL },
        { "freturn",NULL },
        { "dreturn",NULL },
        { "areturn",NULL },
        { "return" ,NULL },
        { "getstatic",oneParamShort },
        { "putstatic",oneParamShort },
        { "getfield",oneParamShort },
        { "putfield",oneParamShort },
        { "invokevirtual", oneParamShort },
        { "invokespecial", oneParamShort },
        { "invokestatic",  oneParamShort },
        { "invokeinterface", interfaceParam},
        { "unknown",NULL },
        { "new", oneParamShort },
        { "newarray", oneParamByte },
        { "anewarray", oneParamShort },
        { "arraylength",NULL },
        { "athrow", NULL },
        { "checkcast", oneParamShort },
        { "instanceof", oneParamShort },
        { "monitorenter",NULL },
        { "monitorexit",NULL },
        { "wide",NULL },
        { "multianewarray", newArrayParam }, 
        { "ifnull", oneParamShort },
        { "ifnonnull", oneParamShort },
        { "goto_w", oneParamLong  },
        { "jsr_w" , oneParamLong },
        { "breakpoint", NULL },
        { "ldc_quick", oneParamByte }, /*203*/
        { "unknown" ,NULL },
        { "ldc2w_quick" , oneParamShort },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "ret_w"   ,NULL },
        { "getstatic_quick" ,oneParamShort },
        { "putstatic_quick" ,oneParamShort }, /*211*/
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "invokenonvirtual_quick" ,oneParamShort },
        { "unknown" ,NULL },
        { "invokestatic_quick" ,oneParamShort }, /*217*/
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "undocumented_invoke" ,oneParamShort }, /*220*/
        { "new_quick" ,oneParamShort },
        { "newarray_quick" ,oneParamShort },
        { "unknown" ,NULL },
        { "checkcast_quick" ,oneParamShort }, /*224*/
        { "instanceof_quick" ,oneParamShort },
        { "invokevirtual_quick" ,oneParamShort },
        { "getfield_quick_w" ,oneParamShort },
        { "putfield_quick_w" ,oneParamShort },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "unknown" ,NULL },
        { "impdep1" ,NULL },
        { "impdep2" ,NULL },
};

/*
print on stderr the bytecode pointed by p
returns the number of bytes read.
*/
int decode_bytecode(unsigned char *code)
{
        int (*param_ptr)(unsigned char *c);
        int current_bytecode=0;

        current_bytecode=(int)*code;
        lprintf("%s ",opcodes[current_bytecode].name);
        param_ptr=(opcodes[current_bytecode].print_param);
        if(param_ptr!=NULL)
           return 1+(*param_ptr)(code+1);
        else
           return 1;
}

#endif

//-----------------------------------------------------------------------------

// useful for special debugging
//
void printHexDump (unsigned char * p_Code,int p_Size, char * p_Label)
{
	int				l_Count = -1;
	unsigned char *	l_End	= p_Code + p_Size;
	
	iprintf("\n");
	while (p_Code < l_End)
	{
		if (++l_Count % 20)
			iprintf("%02x ",*p_Code++);
		else
		{
			iprintf("\n%s %5d (%p) : %02x ", p_Label, l_Count, p_Code, *p_Code);
			p_Code++;
		}
	}

	iprintf	("\n");
	fflush	(stderr);
}

//-----------------------------------------------------------------

#ifndef USE_SYSLOG
static FILE *log = NULL;
#endif

void
lprintf(char *fmt, ...)
{
    va_list ap;

#ifdef USE_SYSLOG
    char buf [1024];
    va_start (ap, fmt);
    vsnprintf (buf, sizeof (buf), fmt, ap);
    va_end (ap);
    syslog (LOG_USER | LOG_NOTICE, "%s", buf);
#else
    if(log == NULL)
        return;
    va_start(ap, fmt);
    vfprintf(log, fmt, ap);
    va_end(ap);
    fflush(log);
#endif
}

#ifdef USE_SYSLOG
void iprintf (char *fmt, ...)
{
    va_list ap;

    char buf [1024];
    va_start (ap, fmt);
    vsnprintf (buf, sizeof (buf), fmt, ap);
    va_end (ap);
    syslog (LOG_USER | LOG_INFO, "%s", buf);
}


#ifdef DEBUG
void
dprintf (FILE *ignore, char *fmt, ...)
{
    va_list ap;

    char buf [1024];
    va_start (ap, fmt);
    vsnprintf (buf, sizeof (buf), fmt, ap);
    va_end (ap);
    syslog (LOG_USER | LOG_DEBUG, "%s", buf);
}
#endif
#endif

void
lopen(void)
{
    time_t now;
    char s[1024];
#ifdef USE_SYSLOG
    openlog ("jit4java", LOG_PID, LOG_USER);
#else
    char *logname;
    if((logname = getenv("TYA_LOGFILE")) != NULL) {
        if(*logname == '\0')
	 {
	    log = stderr;
            return;
	 }
        log = fopen(logname, "a");
    }
    if(log == NULL)
      log = stderr;
    else
#endif
     {
       now = time(NULL);
       strftime(s, sizeof(s), "%Y.%m.%d-%H:%M:%S", localtime(&now));
       lprintf("%s\n", s);
     }
}

void
lclose(void)
{
#ifndef USE_SYSLOG
    if(log != NULL && log != stderr)
        fclose(log);
    log = NULL;
#endif
}
