/* genseq.h (definitions for genseq.c) */
/* Chris Jacobi, November 10, 1997 1:16 pm PST */

/*
 * Copyright (c) 1991-1996 Xerox Corporation.  All Rights Reserved.
 * Unlimited use, reproduction, and distribution of this software is permitted.
 * Any copy of this software must include both the above copyright notice of
 * Xerox Corporation and this paragraph.  Any distribution of this software
 * must comply with all applicable United States export control laws.  This
 * software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND
 * NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY LIABILITY FOR
 * DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED,
 * WHETHER ARISING IN CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT
 * LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGES.
 */
 
/* $Id: genseq.h,v 1.2 1997/11/10 21:35:33 jacobi Exp $ */

#include "genstub.h"
     
extern boolean sq_is_a(Type t);
extern void sq_assert(Type t);

extern char * sq_typeDeclarator(Type t);

extern char * sq_ioSzPiece(Type t, const char *arg);
extern char * sq_ioOutPiece(Type t, const char *arg);
extern char * sq_ioInPiece(Type t);
extern void sq_enumElementTypes(Type t, TypeProc tp, refany rock);

extern void sq_defineMain(Type t);



/* The following procedures areshared
 * between genarr.c and genseq.c,
 * but they are not really of general interest */

extern char *
ioSpecialElemSzPiece(const char *eName, const char *argName,
	                     const unsigned long length);
    /* Returns a marshaling sizing string piece for the special case of
     * one dimensional array of ISL BYTE, CHARACTER and SHORT CHARACTER.
     * Assumes arg designates the instance of T.
     */

extern char * 
ioSpecialElemOutPiece(const char *eName, const char *argName,
	                   const unsigned long length);

extern char * 
ioSpecialElemInPiece(const char *eName, const unsigned long length);
    


/* end */
