#ifndef _ILUIDL_H
#define _ILUIDL_H
/*
Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: iluidl.h,v 1.5 1997/11/08 03:23:45 janssen Exp $
*/

enum idltype_tag{
  NULLTYPEtag,BASICtag,REFERENCEDtag,
  SEQUENCEtag,STRUCTtag,STRINGtag,ARRAYtag,ENUMtag,UNIONtag,
  DEFINEDtag,ALIAStag,WSTRINGtag,FIXEDtag,NATIVEtag
};
enum idltk{
  idl_void,idl_short,idl_long,idl_float,idl_double,
  idl_unsigned_short,idl_unsigned_long,idl_octet,idl_boolean,
  idl_long_long,idl_unsigned_long_long,idl_wchar,
  idl_char,idl_any,idl_string,idl_enum,idl_object,
  /* untyped values */
  idl_int,
  /* expressions */
  idl_unary,idl_binary,idl_named
};

typedef struct idl_type{
  enum idltype_tag tag;
  boolean has_scope;
  union{
    /* long f(); */
    enum idltk basic;
    /* foo f(); */
    struct{
      struct idl_name* name;
      struct idl_type *val;
    }referenced;
    /* typedef sequence<long> foo; */
    struct{
      struct idl_type* type;
      struct idl_value* size;
    }sequence;
    /* typedef long foo[42]; */
    struct{
      struct idl_type* type;
      list dimensions;
    }array;
    /* union switch(long){case 3:long i;}; */
    struct{
      struct idl_type* head;
      list body;
      struct idl_name* _default;
    }_union;
    /* typedef fixed<10,2> foo; */
    struct{
      struct idl_value* digits;
      struct idl_value* fraction;
    }fixed;
    /* struct foo{short i;long l;}; */
    list structure;
    /* enum foo{red,blue,green}; */
    list enumerated;
    /* typedef string<10> foo; */
    struct idl_value *stringsize;
    /* typedef struct defined{long i;} alias; */
    struct idl_definition *defined;
    struct idl_type *alias;
  }u;
  refany isl;
  /* support for anonymous types */
  struct idl_name *name;
  struct idl_definition *anon_def;
} *IDLType;

IDLType new_type();
IDLType new_referenced();

typedef struct idl_name{
  int serial;
  char *file;
  int line;
  struct idl_definition *env;
  struct idl_name *scope;
  char* name;
  char *lifted;
  struct idl_definition* value;
  list array;
  boolean no_ordering; /* this use may occur before the definition: #pragma */
} *IDLName;

IDLName new_name();

typedef struct idl_value{
  enum idltk tag;
  union{
    int INT;
    char CHAR;
    boolean BOOL;
    struct{
      double val;
      /* those are used of no difficult computations are performed */
      boolean sign;
      char *integer;
      char *fraction;
      long exponent;
    }FLOAT;
    char* string;
    struct{
      struct idl_type *type;
      struct idl_name *name;
    }enumerated;
    struct{
      char operator;
      struct idl_value *arg;
    }unary;
    struct{
      char operator;
      struct idl_value *arg1,*arg2;
    }binary;
    struct idl_name *named;
  }u;
  struct idl_value *value;
  refany isl;
} *IDLValue;

IDLValue new_value();
IDLValue new_unary(char,IDLValue);
IDLValue new_binary(IDLValue,char,IDLValue);

enum idldefinition_tag{
  NILtag,TYPEtag,CONSTtag,EXCEPTIONtag,OPERATIONtag,INTERFACEtag,MODULEtag,
  MEMBERtag,PARAMETERtag,CASEtag,ATTRIBUTEtag,INTERFACEFWDtag,
  TYPELISTtag,MEMBERLISTtag,ATTRLISTtag,ENUMVALtag,
  PRAGMA_IDtag,PRAGMA_VERSIONtag,PRAGMA_PREFIXtag
};

typedef struct idl_definition{
  enum idldefinition_tag tag;
  IDLName name;
  union{
    IDLType type;
    struct{
      list definitions;
    }module;
    struct{
      boolean oneway;
      IDLType returntype;
      list parameters;
      refany raises;
      refany context;
    }operation;
    struct{
      /* 0 - unresolved, 1 - bases in progress, 2 - bases resolved */
      int resolution_state;
      list bases;
      list definitions;
    }interface;
    struct{
      struct idl_type *type;
      struct idl_value *val;
      boolean computed;
    }constant;
    struct{
      ArgDirection direction;
      IDLType type;
    }parameter;
    struct{
      list members;
    }exception;
    struct{
      struct idl_type *type;
      list labels;
    }_case;
    struct{
      boolean readonly;
      struct idl_type *type;
      list names;
      refany set;
    }attribute; /* both attribute and attribute list */
    struct{
      struct idl_type *type;
      list names;
    }typelist;  /* both typelist and member list */
    char *pragma;
    struct idl_type *member;
    struct idl_value *enumval;
  }u;
  struct idl_definition *env;
  char *id;      /* repository ID, either assigned via pragma or computed */
  char *prefix;  /* computed prefix, excluding pragma prefix */
  char *version; /* assigned version, if any */
  refany isl;
} *IDLDefinition;

IDLDefinition new_definition();
void deflist_insert(list,IDLDefinition);
void type_insert(list,IDLType);

typedef struct idl_case{
  IDLValue value;
  Argument isl;
  IDLDefinition env;
}*IDLCase;

IDLCase new_case();

#define isidlidentchar(x)	((isalnum(x))||((x)=='_'))

/* interface between scanner and parser */
char* idlcurrentfile();
int idlcurrentline();
void idlsetinitialfile(char* file);
int idlerror(char*);

/* support functions */
char* strndup(char* src,int len);
char* iluparser_basename(char* fullname);

#endif
