# Top level makefile to build Win 32 version of ILU using
# Microsoft Visual C++
#
# Assumes your PATH has the appropriate bin directory in it (e.g. msvc20\bin)
# Assumes your INCLUDE environment variable includes the appropriate directories (e.g. msvc20\include) 
# Assumes your LIB environment variable includes the appropriate directories (e.g. msvc20\lib) 

!IF "$(CFG)" == ""
CFG=Win32 Release
!MESSAGE No configuration specified.  Defaulting to Win32 Release.
!ENDIF 

!IF "$(CFG)" != "Win32 Release" && "$(CFG)" != "Win32 Debug"
!MESSAGE Invalid configuration "$(CFG)" specified.
!MESSAGE You can specify a configuration when running NMAKE on this makefile
!MESSAGE by defining the macro CFG on the command line.  For example:
!MESSAGE 
!MESSAGE NMAKE /f "iluwin32.mak" CFG="Win32 Release"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "Win32 Release"
!MESSAGE "Win32 Debug"
!MESSAGE 
!ERROR An invalid configuration is specified.
!ENDIF 



################################################################################

ALL : PMAKE

clean :
    if exist WinDebug\nul del /q WinDebug\*
    if exist WinDebug\nul rmdir WinDebug
    if exist WinRel\nul del /q Winrel\*
    if exist WinRel\nul rmdir Winrel

PMAKE :
!MESSAGE WARNING: By default, the Python Language Specific Runtime is NOT built!
!MESSAGE To build it, set PYTHONSRC to point to your Python directory which contains
!MESSAGE the Python Include directory, the Python PC directory, and the Python vc40
!MESSAGE directory (containing python14.lib).
!MESSAGE 
!MESSAGE If you need these files, please retrieve the python source from http://www.python.org,
!MESSAGE as python1.4.tar.gz.  They are NOT distributed with ILU.  Edit the file 
!MESSAGE in the PC directory called python_nt.def, so as to also export the following
!MESSAGE symbols: start_new_thread init_thread get_thread_ident exit_thread
!MESSAGE (and for compatibility with pythonwin, PyArg_ParseTupleAndKeywords).
!MESSAGE Then follow the instructions in the PC/readme.txt file to build python.
!MESSAGE
!MESSAGE After building python, uncomment the nmake line below, and re-start the make process.
!MESSAGE You will need to put ILUHOME/lib on your PYTHONPATH before
!MESSAGE using ILU with Python.
	copy pythonversion.win pythonversion.h
#	nmake -f iluPr.mak CFG="$(CFG)"


# End 
################################################################################
