#ifndef lint
static char sccsid[] = "@(#)dclock.c	3.11h 96/09/30 xlockmore";
 
#endif

/*-
 * dclock.c - floating digital clock screen for xlock,
 *            the X Window System lockscreen.
 * Copyright (C) 1995 by Michael Stembera <mrbig@fc.net>.
 * Use freely anywhere except on any Microsoft platform.
 * See xlock.c for more copying information.
 * Revision History:
 * 29-Aug-95: Written.
 */

#include <time.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <sys/time.h>
#include <sys/types.h>
#include "xlock.h"

ModeSpecOpt dclock_opts =
{0, NULL, 0, NULL, NULL};

static GC   gct1, gct2;		/* GC to draw with */
static XGCValues gcv;		/* Struct for creating GC */
static short height, width;

static unsigned long black;	/* Pixel values */
static XColor color, xcolor;	/* Temporary color */
static XColor actual_color;	/* Temporary color */
static Visual *visual;
static Colormap cmap, pcmap;	/* Color map to use */

static short count;
static long red, green, blue;
static char *str, *str1, *str2, *str1old, *str2old;
static char *str1pta, *str2pta, *str1ptb, *str2ptb, *tmppt;
static XFontStruct *fontStruct;
static char eight_bit;
static unsigned char pixcount;
static time_t timenew, timeold;
static short maxx, maxy, clockx, clocky, text_height, cent_offset;
static short hour;


static void
DrawDclock(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	Window      window = MI_WINDOW(mi);
	static short xold, yold, dx = 1, dy = 1;

	xold = clockx;
	yold = clocky;
	clockx += dx;
	clocky += dy;

	if (clockx > maxx || clockx < cent_offset) {
		dx = -dx;
		clockx += dx;
	}
	if (clocky > maxy || clocky < fontStruct->max_bounds.ascent) {
		dy = -dy;
		clocky += dy;
	}
	if (timeold != (timenew = time((long *) NULL))) {	/* only parse if time has changed */
		timeold = timenew;
		str = ctime(&timeold);

		/* keep last disp time so it can be cleared even if it changed */
		tmppt = str1ptb;
		str1ptb = str1pta;
		str1pta = tmppt;
		tmppt = str2ptb;
		str2ptb = str2pta;
		str2pta = tmppt;

		/* copy the hours portion for 24 to 12 hr conversion */
		(void) strncpy(str1pta, (str + 11), 8);
		hour = (short) (str1pta[0] - 48) * 10 + (short) (str1pta[1] - 48);
		if (hour > 12) {
			hour -= 12;
			(void) strcpy(str1pta + 8, " PM");
		} else {
			if (hour == 0)
				hour += 12;
			(void) strcpy(str1pta + 8, " AM");
		}
		str1pta[0] = (hour / 10) + 48;
		str1pta[1] = (hour % 10) + 48;
		if (str1pta[0] == '0')
			str1pta[0] = ' ';

		/* copy day month */
		(void) strncpy(str2pta, str, 11);
		/* copy year */
		(void) strncpy(str2pta + 11, (str + 20), 4);

		XDrawString(display, window, gct2, xold, yold,
			    str1ptb, strlen(str1ptb));	/* erase */
		XDrawString(display, window, gct1, clockx, clocky,
			    str1pta, strlen(str1pta));	/* draw */

		XDrawString(display, window, gct2,
			    xold - cent_offset, yold + text_height,
			    str2ptb, strlen(str2ptb));	/* erase */
		XDrawString(display, window, gct1,
			    clockx - cent_offset, clocky + text_height,
			    str2pta, strlen(str2pta));	/* draw */
	} else {		/* do this if time is the same */
		XDrawString(display, window, gct2, xold, yold,
			    str1pta, strlen(str1pta));	/* erase */
		XDrawString(display, window, gct1, clockx, clocky,
			    str1pta, strlen(str1pta));	/* draw */

		XDrawString(display, window, gct2,
			    xold - cent_offset, yold + text_height,
			    str2pta, strlen(str2pta));	/* erase */
		XDrawString(display, window, gct1,
			    clockx - cent_offset, clocky + text_height,
			    str2pta, strlen(str2pta));	/* draw */
	}
}

static void
ChangeDclkColor(ModeInfo * mi)
{
	static short delta;
	static char rflag = 1, gflag = 0, bflag = 1;


	if (eight_bit) {
		pixcount += (LRAND() & 1);
		gcv.foreground = MI_PIXEL(mi, pixcount % 64);
	} else {
/* increment cycle through one of RGB by no more than 4% */
		delta = NRAND(2621);	/* max 4% change, avg 2% change */
		switch NRAND
				(3) {
			case 0:
				if (rflag) {
					red += delta;
					if (red > 65535) {
						red = 65535;
						rflag = 0;
					}
				} else {
					red -= delta;
					if (red < 13107) {	/* 20% minimum */
						red = 13107;
						rflag = 1;
					}
				}
				break;
			case 1:
				if (gflag) {
					green += delta;
					if (green > 65535) {
						green = 65535;
						gflag = 0;
					}
				} else {
					green -= delta;
					if (green < 13107) {
						green = 13107;
						gflag = 1;
					}
				}
				break;
			case 2:
				if (bflag) {
					blue += delta;
					if (blue > 65535) {
						blue = 65535;
						bflag = 0;
					}
				} else {
					blue -= delta;
					if (blue < 13107) {
						blue = 13107;
						bflag = 1;
					}
				}
				}
		xcolor.red = red;
		xcolor.green = green;
		xcolor.blue = blue;
		(void) XAllocColor(MI_DISPLAY(mi), pcmap, &xcolor);
		gcv.foreground = xcolor.pixel;
	}
	XChangeGC(MI_DISPLAY(mi), gct1, (GCForeground), &gcv);
}

void
init_dclock(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	Window      window = MI_WINDOW(mi);

	XClearWindow(display, window);
	if (MI_WIN_DEPTH(mi) > 8)
		eight_bit = 0;
	else
		eight_bit = 1;

	str = (char *) malloc(40 * sizeof (char));	/* to hold time & date string */
	str1 = (char *) malloc(20 * sizeof (char));	/* to hold time */
	str2 = (char *) malloc(20 * sizeof (char));	/* to hold date */
	str1old = (char *) malloc(20 * sizeof (char));
	str2old = (char *) malloc(20 * sizeof (char));

	cmap = DefaultColormap(display, DefaultScreen(display));
	visual = DefaultVisual(display, DefaultScreen(display));
	pcmap = XCreateColormap(display, window, visual, AllocNone);

	XAllocNamedColor(display, cmap, "white", &color, &actual_color);
	XAllocNamedColor(display, cmap, "black", &color, &actual_color);
	black = color.pixel;
	XAllocNamedColor(display, cmap, "VioletRed1", &color, &actual_color);

	width = MI_WIN_WIDTH(mi);
	height = MI_WIN_HEIGHT(mi);

	gcv.foreground = black;
	gcv.background = black;

/* try to get a font for clock (preferably large) */
	fontStruct = XLoadQueryFont(display,
	    "-b&h-lucida-bold-r-normal-sans-34-240-100-100-p-216-iso8859-1");
	if (fontStruct == NULL)
		fontStruct = XLoadQueryFont(display,
					    "-adobe-helvetica-bold-r-normal--34-240-100-100-p-182-iso8859-1");
	if (fontStruct == NULL)
		fontStruct = XLoadQueryFont(display,
					    "-adobe-helvetica-bold-r-normal--24-240-75-75-p-138-iso8859-1");
	if (fontStruct == NULL)
		fontStruct = XLoadQueryFont(display,
					    "12x24");
	if (fontStruct == NULL)
		fontStruct = XLoadQueryFont(display,
					    "fixed");
	if (fontStruct == NULL) {
		(void) printf("Could not get font.\n");
		exit(1);
	}
	if (eight_bit) {
		gcv.foreground = MI_PIXEL(mi, NRAND(MI_NPIXELS(mi)));
	} else {
/* pick a RGB color for clock w/ a minimum 20% brightness */
		red = 13107 + NRAND(52429);	/* 20% minimum */
		green = 13107 + NRAND(52429);
		blue = 13107 + NRAND(52429);
		xcolor.red = red;
		xcolor.green = green;
		xcolor.blue = blue;
		(void) XAllocColor(display, pcmap, &xcolor);
		gcv.foreground = xcolor.pixel;
	}
	gcv.font = fontStruct->fid;
	gcv.function = GXcopy;
	gct1 = XCreateGC(display, window, (GCForeground | GCBackground
					   | GCFont | GCFunction), &gcv);


	gcv.foreground = black;
	gcv.background = black;
	gcv.function = GXcopy;
	gct2 = XCreateGC(display, window, (GCForeground | GCBackground |
					   GCFont | GCFunction), &gcv);

	/* (void)time(&timenew); */
	timeold = timenew = time((long *) NULL);
	str = ctime(&timeold);

	(void) strncpy(str1, (str + 11), 8);
	hour = (short) (str1[0] - 48) * 10 + (short) (str1[1] - 48);
	if (hour > 12) {
		hour -= 12;
		(void) strcpy(str1 + 8, " PM");
	} else {
		if (hour == 0)
			hour += 12;
		(void) strcpy(str1 + 8, " AM");
	}
	str1[0] = (hour / 10) + 48;
	str1[1] = (hour % 10) + 48;
	if (str1[0] == '0')
		str1[0] = ' ';
	str1[11] = 0;		/* terminate str1 */
	str1old[11] = 0;	/* terminate str1old */

	(void) strncpy(str2, str, 11);
	(void) strncpy(str2 + 11, (str + 20), 4);
	str2[15] = 0;		/* terminate str2 */
	str2old[15] = 0;	/* terminate str2old */

	text_height = fontStruct->max_bounds.descent + fontStruct->max_bounds.ascent;
	cent_offset = (XTextWidth(fontStruct, str2, strlen(str2)) -
		       XTextWidth(fontStruct, str1, strlen(str1))) / 2;
	maxx = (width - XTextWidth(fontStruct, str2, strlen(str2)) + cent_offset);
	maxy = (height - text_height - fontStruct->max_bounds.descent);
	clockx = NRAND(maxx - cent_offset) + cent_offset;
	clocky = NRAND(maxy - fontStruct->max_bounds.ascent) +
		fontStruct->max_bounds.ascent;

	str1pta = str1;
	str2pta = str2;
	str1ptb = str1old;
	str2ptb = str2old;

	count = 0;
}


void
draw_dclock(ModeInfo * mi)
{
/* static long unsigned tmpfirst; */

/* 
   if(!count) tmpfirst=time(t)-1; */

	DrawDclock(mi);

	count++;
	if (!(count % 30)) {
		ChangeDclkColor(mi);
		/*   (void) printf("%f tics/sec\n",(float)(count/(time(t)-tmpfirst)));  */
	}
}

void
release_dclock(ModeInfo * mi)
{
}

void
refresh_dclock(ModeInfo * mi)
{
 /* Do nothing, it will refresh by itself */
}
