/* snarf, the Simple Non-interactive All-purpose Resource Fetcher
** Copyright (C) 1995, 1996 Zachary Beane
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public LIcense as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is dsitributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILIY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** The author of this program may be reached via email at
** xach@mint.net or via USPS at 17 Talmadge Rd., Waite, ME 04492, USA.
*/
/* snarf.c */
#include "url.h"
#include "protocol.h"
#include <stdio.h>

#define MED_BUFFER_SIZE 100
#define BIG_BUFFER_SIZE 256

void print_usage(char *);

int main(int argc, char *argv[], char *environ[])
{
  struct url u;
  char string[BIG_BUFFER_SIZE];
  char outfile[BIG_BUFFER_SIZE];
  char config_file[MED_BUFFER_SIZE];

  if((strcpy(config_file, (char *)getenv("HOME"))) == NULL){
    fprintf(stderr, "Unable to find your home directory. Please report this bug!\n");
    exit(1);
  }

  strcat(config_file, "/.snarfrc");

  if(argc < 2){
    print_usage(argv[0]);
    exit(1);
  }
  else
    if(!aliastourl(config_file, argv[1], string)){
      strcpy(string, argv[1]);
    }
	 
  if(isurl(string))
    u = parse_url(string);
  else { 
    fprintf(stderr, "%s: not a recognized URL or alias.\n", string);
    exit(1);
  }


/*\
this is a bit of a complex if statement...it boils down to opening
the same local file as the remote one by default, and stdout if the
third argument is -. If the remote file is null, for example, if you
wanted a finger for a site, it would open snarf.out for writing.
\*/
  if(argc < 3){
    if(strlen(u.u_file) < 1)
      strcpy(outfile, "snarf.out");
    else
      strcpy(outfile, u.u_file);
  }
  else
    strcpy(outfile, argv[2]);

  if(getport(u.u_service) == 0){
    fprintf(stderr, "%s: unknown or unsupported service.\n", u.u_service);
    exit(1);
  }

  if(getport(u.u_service) != FTP)
    simple_get(u, outfile);
  else {
    ftp_get(u, outfile);
  }

  exit(0);
}

void print_usage(char *string)
{
  fprintf(stderr, "snarf version 1.0, Copyright (C) 1995, 1996 Zachary Beane\n");
  fprintf(stderr, "snarf comes with ABSOLUTELY NO WARRANTY; see the file COPYING for details.\n");
  fprintf(stderr, "Send any bug reports, etc. to xach@mint.net\n\n");  
  fprintf(stderr, "Usage: %s [url] {localfile | alias}\n\n", string);
  fprintf(stderr, "Example: %s http://www.unitedmedia.com/comics/dilbert/todays_dilbert.gif\n", string);
  fprintf(stderr, "Use a dash as the localfile to send data to standard output.\n");

}
