#ifndef UI_H
#define UI_H
#include "zoom.h"
#include "param.h"

#define BUTTON1 256
#define BUTTON2 512
#define BUTTON3 1024

#ifdef _UNDEFINED_
void ui_do_fractal(void);
void ui_init(zoom_context *, void (*)(), int (*)(), int, void (*)(int, int, char *), int);
void ui_savefile(void);
void ui_coloringmode(int);
void ui_mandelbrot(int, int);
void ui_incoloringmode(void);
int ui_autopilot(void);
void ui_speedup(void);
void ui_help(int);
void ui_slowdown(void);
int ui_mouse(int, int, int, int);
int ui_inverse(int);
#endif
void ui_message(void);
void ui_status(void);
void ui_updateparameters(void);
void ui_tbreak(void);
void ui_resize(void);
void ui_call_resize(void);
int ui_key(int);
zoom_context *ui_getcontext();

struct ui_driver {
    char *name;
    int (*init) (void);		/*initializing function. recturns 0 if fail */
    void (*getsize) (int *, int *);	/*get current size..in fullscreen versions
					   i.e svga and dos asks user for it */
    void (*processevents) (int, int *, int *, int *, int *);
    /*processevents..calls ui_resize,ui_key
       laso returns possitions of mouse..
       waits for event if first parameter is
       1 */
    void (*getmouse) (int *, int *, int *);
    /*returns current mouse possitions */
    void (*uninit) (void);
    /*called before exit */
    int (*set_color) (int, int, int, int);
    /*sets palette color and returns number */
    void (*print) (int, int, char *);	/*prints text */
    void (*display) (void);	/*displays bitmap */
    int (*alloc_buffers) (char **buffer1, char **buffer2);	/*makes buffers */
    void (*free_buffers) (char *buffer1, char *buffer2);	/*frees buffers */
    void (*flip_buffers) (void);	/*prints text */
    int randomsize;		/*random size of palette? */
    int maxsize;		/*maximal size of palette */
    int textheight;		/*width of text */
    int fullscreen;
    int updateafterpalette;
    int updateafterresize;
    char **help;
    int helpsize;
    struct params *params;
};

#endif				/* UI_H */
