/* e_card2.cc
 *$Header: /al/acs/src/RCS/e_card2.cc,v 9.24 95/10/24 22:44:29 al Exp $
 * Base class for "cards" in the circuit description file
 * This file contains factory methods -- to create and destroy them
 */
#include "error.h"
#include "u_prblst.h"
#include "u_opt.h"
#include "e_card.h"
/*--------------------------------------------------------------------------*/
//		CARD::CARD();
//		CARD::CARD(const CARD& proto);
//		CARD::~CARD();
     generic_t*	create_extra_stuff(const generic_t*);
static	void	freelist(generic_t**);
/*--------------------------------------------------------------------------*/
extern const char e_om[];
/*--------------------------------------------------------------------------*/
/* default constructor for the base class
 * IMPLICITLY called when any object of a derived class is constructed
 */
CARD::CARD()
{
  devclass = NOTSET;
  x = NULL;
  nextcard = prevcard = stnext = stprev = this;
  subckt = parent = NULL;
  label[0] = '\0';
  int ii;
  for (ii = 0;  ii <= NODESPERBRANCH;  ii++)
    nodes[ii].e = nodes[ii].t = nodes[ii].m = INVALIDNODE;
  n = nodes;
  label[0] = '\0';
  val = ic = 0.;
  method_u = mUNKNOWN;
  evaliter = probes = 0;
  bypass = nodamp = converged = FALSE;
  trfun = NULL;
  acfun  = NULL;
}
/*--------------------------------------------------------------------------*/
/* copy constructor for the base class
 * called by copy constructor of any derived class
 * most of this only makes sense for derived objects, but it is universal
 */
CARD::CARD(const CARD& proto)
{
  devclass = proto.devclass;
  x = create_extra_stuff(proto.x);
  nextcard = prevcard = stnext = stprev = this;
  subckt = parent = NULL;
  strcpy(label, proto.label);
  int ii;
  for (ii = 0;  ii <= NODESPERBRANCH;  ii++)
    nodes[ii] = proto.nodes[ii];
  n = nodes;
  val = proto.val;
  ic = proto.ic;
  method_u = proto.method_u;
  evaliter = probes = 0;
  bypass = nodamp = converged = FALSE;
  trfun = proto.trfun;
  acfun = proto.acfun;
}
/*--------------------------------------------------------------------------*/
CARD::~CARD()
{
  PROBE_LISTS::purge(this);
  unlink();
  freelist(&x);
  if (exists(subckt)){
    while (subckt != subckt->next()){
       delete subckt->next();
    }
    delete subckt;
  }
}
/*--------------------------------------------------------------------------*/
/* create_extra_stuff: copy the extra info for special parts (mosfets, etc)
 */
generic_t *create_extra_stuff(const generic_t *proto)
{
  if (proto){
    generic_t *x;
    x = (generic_t*)calloc(1,proto->ssize);
    if (!x)
      error(bERROR, e_om, "extra_stuff");
    memcpy((void*)x, (const void*)proto, proto->ssize);
    x->x = create_extra_stuff(x->x);
    return x;
  }else{
    return NULL;
  }
}
/*--------------------------------------------------------------------------*/
/* freelist: free a (singly linked) list of structures   (recursive)
 * struct generic is an attempt to tame type clashes
 */
static void freelist(generic_t **x)
{
  if (x  &&  *x  &&  (*x)->x  &&  (*x)->x != (*x)->x->x){
    freelist(&((*x)->x));
  }
  if (x  &&  *x){
    free((void*)*x);
    *x = NULL;
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
