/* d_admit.cc
 *$Header: /al/acs/src/RCS/d_admit.cc,v 9.20 95/10/15 22:30:40 al Exp $
 * functions for admittance (type 'Y')
 * does not exist in spice
 * x = volts, y.f0 = amps, ev = y.f1 = mhos.
 */
#include "d_admit.h"
/*--------------------------------------------------------------------------*/
//	void	DEV_ADMITTANCE::expand();
// 	int	DEV_ADMITTANCE::dotr();
// 	void	DEV_ADMITTANCE::doac();
/*--------------------------------------------------------------------------*/
void DEV_ADMITTANCE::expand()
{
  m0.f1 = y0.f1 = val;
  y0.f0 = LINEAR;
  m0.c0 = 0.;
  acg = ev = val;
  assert(loss == 0.);
}
/*--------------------------------------------------------------------------*/
int DEV_ADMITTANCE::dotr()
{
  if (trfun){
    trsetup();
    m0.x = volts_limited(n[OUT1],n[OUT2]);
    y0.x = m0.x;
    y0.f0 = m0.f1 * m0.x + m0.c0;	/* BUG:  patch for diode */
    (*trfun)(this);
    m0.c0 = y0.f0 - y0.x * y0.f1;
    m0.x = y0.x;			/* BUG: undo advance if bypassed */
    m0.f1 = y0.f1;
    return converged = conv_check();
  }else if (probes){
    trsetup();
    m0.x = n[OUT1].v0() - n[OUT2].v0();
    y0.x = m0.x;
    y0.f0 = y0.x * y0.f1;
    assert(y0.f1 == val);
    assert(m0.f1 == val);
    assert(m0.c0 == 0.);
    return converged = TRUE;
  }else{
    assert(m0.f1 == val);
    assert(m0.c0 == 0.);
    return converged = TRUE;
  }
}
/*--------------------------------------------------------------------------*/
void DEV_ADMITTANCE::doac()
{
  if (acfun){
    acbias = n[OUT1].vdc() - n[OUT2].vdc();
    ev = (*acfun)(this);
    acg = ev;
  }else if (trfun){
    acg = ev = y0.f1;
  }else{
    assert(acg == val);
  }
  acload_passive(); 
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
