/* c_help.cc
 *$Header: /al/acs/src/RCS/c_help.cc,v 9.24 95/10/24 22:43:46 al Exp $
 * Accesses a help file to provide on-line documentation.
 * Will follow the executables path to find it.
 */
#include "ap.h"
#include "error.h"
#include "io.h"
#include "c_comand.h"
/*--------------------------------------------------------------------------*/
//	void	CMD::help(CS&);
/*--------------------------------------------------------------------------*/
extern const char e_int[];
/*--------------------------------------------------------------------------*/
void CMD::help(CS& cmd)
{
  static FILE *hfn;
  char buffer[BUFLEN];
  char *name;
  
  if (hfn)
    fclose(hfn);
  name = findfile(HELPFILE, HELPPATH, R_OK);
  if (!name)
    error(bERROR, "Help not available\n");
  hfn = fopen(name, "r");
  if (!hfn)
    error(bERROR, e_int, "help");
  if (cmd.more())
    do {
      if (!fgets(buffer, BUFLEN, hfn)) {
	error(bWARNING, "No help on %s\n", cmd.tail());
	break;
      }
    } while (buffer[0]!=':'  ||  !cmd.pmatch(&buffer[1]));

  int line;
  for (line = 0; ; ++line){
    if (!fgets(buffer,BUFLEN,hfn))
      break;
    if (buffer[0]==':')
      break;
    if (line%23 == 22)		/* BUG: fixed screen length */
      pause(CS(""));
    mputs(buffer,IO::mstderr);
  }
  fclose(hfn);
  hfn = (FILE*)NULL;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
