#include "wily.h"
#include "key.h"

static Key		keytab[MAXKEYS];

/* We use a very simple hash function to associate libXg event keys
 * and our Key structures:  we know that every event key is a power of 2,
 * so we just take the log2
 */
static int
log2(ulong n)
{
	int i, v;

	for(i=0, v=1; i < 32; i++, v<<=1)
		if(n <= v)
			break;
	return i;
}

/* Allocate and return a new Key with the given key, fd and type */
Key*
key_new(ulong key, int fd, Keytype t)
{
	Key	*k;

	k = &keytab[log2(key)];
	assert(k->t == Kfree);
	k->fd = fd;
	k->t = t;
	return k;
}

Key*
key_find(ulong key)
{
	return &keytab[log2(key)];
}

/* 'key' is finished.  Free any resources that it was tying up.
 */
void
key_del(Key	*k)
{
	close(k->fd);
	estop(k->key);

	switch(k->t) {
	case Klisten:	error("Klisten closed");
	case Kout: 	rmrunning(k->cmd); break;
	case Kmsg:	data_fdstop(k->fd); break;
	default:		error("badkey type %d", k->t);
	}
	k->t = Kfree;
}

void
keytab_init(void)
{
	int	j;
	ulong	key = 1;
	Key	*k;

	for(j=0; j<MAXKEYS; j++) {
		k = &keytab[j];
		k->t = Kfree;
		k->key = key;
		key *= 2;
		k->buf = 0;
		k->n = 0;
		k->alloced = 0;
	}
}

Key*
key_findcmd(char*s)
{
	Key	*k;

	for(k = keytab; k < keytab + MAXKEYS; k++)
		if (k->t != Kfree)
			if (STRSAME(s, k->cmd))
				return k;
	return 0;
}

Key *
key_nextkey(Key *k)
{
	if (k) {
		while (++k < keytab + MAXKEYS)
			if (k->t == Kout)
				return k;
		return 0;
	} else
		for (k = keytab; k < keytab + MAXKEYS; k++)
			if (k->t == Kout)
				return k;
	return 0;
}
