#include "wily.h"
#include "view.h"
#include "key.h"

#include <signal.h>

/* Start listening to fifo in well-known location */
static void
well_known_init()
{
	int	fd;
	long	key;

	fd = wilyfifolisten();
	if(fd<0) {
		diag(0, "couldn't open fifo");
		return;
	}

	key = estart(0, fd, 0);
	if(!key)
		error("estart");
	key_new(key,fd, Klisten);
}

/* Prepare to catch some signals */
static void
signal_init(void)
{
	signal(SIGPIPE, SIG_IGN);       /* in case external process exits */

	signal(SIGHUP, cleanup_and_die); 
	signal(SIGINT, cleanup_and_die); 
	signal(SIGTERM, cleanup_and_die); 
	
	signal(SIGSEGV, cleanup_and_abort); 
	/* signal(SIGSYS, cleanup_and_abort);  */
	signal(SIGILL, cleanup_and_abort); 
}

/* Initialize whatever we need for dealing with external processes
 */
void
ex_init(void)
{
	keytab_init();
	well_known_init();
	signal_init();
	exec_init();
}
