#include "wily.h"
#include <stdlib.h>

typedef struct Abbrev Abbrev;
struct Abbrev {
	Path	key, val;
};

static struct Abbrev *abbrev = 0;
static int nabbrev = 0, maxabbrev = 0;

static void
newenv(char *key, char *val)
{
	Abbrev	*new;

	if(strlen(key)>=strlen(val))	/* not much good */
		return;

	if (nabbrev == maxabbrev) {
		maxabbrev = maxabbrev? maxabbrev*2 : maxabbrev + 2;
		abbrev = srealloc(abbrev, maxabbrev * sizeof(*abbrev));
	}
	new = &abbrev[nabbrev++];
	strcpy(new->key, key);
	strcpy(new->val, val);
}

/* Compare based on how much space they save */
static int
better(Abbrev *old, Abbrev *new)
{
	return  (strlen(new->val) - strlen(new->key)) - 
		(strlen(old->val) - strlen(old->key)) ;
}

/* Must be called _after_ wilydir is set */
void
env_init(char **envp)
{
	char	*env, *ptr;
	Path	key, val;

	/* Add environment variables */
	while ( (env = *envp++)) {
		if (! (ptr = strchr(env, '=')) )
			continue;
		*ptr ++ = 0;
		if (strlen(ptr)&&realpath(ptr, val)) {
			sprintf(key, "$%s", env);

			/* BUG - only works for directories */
			add_slash(key);
			add_slash(val);
			newenv(key, val);
		}
		*--ptr = '=';
	}
	qsort(abbrev, nabbrev, sizeof(*abbrev), (int(*)(const void*,const void*))better);
}

/* Copy shorter version of 'orig' into 'dest' */
void
pathcontract(char*dest, char *orig)
{
	Abbrev *	a;
	int		len, olen;

	olen = strlen(orig);

	for(a = abbrev; a < abbrev + nabbrev; a++) {
		len = strlen(a->val);
		if  ( (len > olen) ||
				( (len == olen) && !strlen(a->key) ) ||
				(strncmp(a->val, orig, len)) )
			continue;
		sprintf(dest, "%s%s", a->key, orig + len);
		return;
	}
	strcpy(dest,orig);
}


