#include <sys/param.h>	/* for MAXPATHLEN */
#ifndef DEFAULTSHELL
#define DEFAULTSHELL "/bin/sh"
#endif

enum {
	MAXLOOK = 256,	/* Max length we can 'Look' for */
	DEFAULTCOLWIDTH = 300, 
	COLSTEP = 30,
	GAPSIZE = 512,	/* buffer gap */
	K = 1024,
	BUFFERSIZE = 10*K,		/* chunk size for copying text */
	NGETC= 	128	,
	MINWIDTH = 50,			/* min width of a window or column */
	SCROLLWIDTH = 14,
	MINCOLWIDTH=150,
	SELECTEDBORDER=3,		/* width of border for selected view */
	MAXNAMES = 10240,		/* max names in a directory */
	LEFT =1, MIDDLE=2, RIGHT=4,	/* mouse buttons */
	Backspace =	0x7f,
	PageDown = 	0x80,		/* special keys */
	PageUp = 	0x81,
	LeftArrow =	0x82,
	RightArrow =	0x83,
	DownArrow = 0x84,
	UpArrow = 	0x85,
	Home =		0x86	,
	End =		0x87,

	NEWLINE = 	'\n',
	Ctrlh = 		010,
	Ctrlu = 		025,
	Ctrlw =  		027,
	Esc = 		27,

	DOUBLECLICK = 500,	/* ms for double-click */
	SCROLLTIME = 100,		/* ms for auto-scroll */
	CHUNK=512,	/* chunk of memory */
	INSET = 4,
	/* from stdio*/
#ifndef MAXPATH
	MAXPATH	= MAXPATHLEN,
#endif
#ifndef FOPEN_MAX
#define FOPEN_MAX NOFILE
#endif
	MAXKEY= FOPEN_MAX/2,

	SMALLDISTANCE = 25,	/* 5 pixels squared */
	NBLANK = 6,			/* minimum blank lines worth putting new win in */
	TEXTMARGIN=2*INSET,		/* upper margin + lower margin of text widget */
	MINLINES=3,		/* least lines a win can show to be useful */
	DELTA=2,			/* least lines a win should grow on win_grow */
	MINX  = 50,		/* least pixel width for a text widget */
	MINY = 20		/* least pixel height for a text widget */
};

#define SHRINK .8
