.lf 1 sql/rename.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /usr/local/devel/pglite/cvs/src/doc/ref/sql/rename.cmdsrc,v 1.1 1996/02/24 01:17:11 jolly Exp $
.TH RENAME COMMANDS 02/08/94
.XA 2 Rename
.SH NAME
rename \(em rename a class or an attribute in a class
.SH SYNOPSIS
.(l M
\fBalter table\fR classname1
        \fBrename to\fR classname2
\fBalter table\fR classname1 [\fB*\fR]
        \fBrename [column]\fR attname1 \fBto\fR attname2
.)l
.SH DESCRIPTION
The
.BR rename
command
causes the name of a class or attribute to change without changing any
of the data contained in the affected class.  Thus, the class or
attribute will remain of the same type and size after this command is
executed.
.PP
In order to rename an attribute in each class in an entire inheritance
hierarchy, use the 
.IR classname
of the superclass and append a \*(lq*\*(rq.  (By default, the attribute
will not be renamed in any of the subclasses.)  This should
.BR always
be done when changing an attribute name in a superclass.  If it is
not, queries on the inheritance hierarchy such as
.(C
select * from super* s
.)C
will not work because the subclasses will be (in effect) missing an
attribute found in the superclass.
.PP
You must own the class being modified in order to rename it or part of
its schema.  Renaming any part of the schema of a system catalog is
not permitted.
.SH EXAMPLE
.(C
--
-- change the emp class to personnel
--
alter table emp rename to personnel
.)C
.(C
--
-- change the sports attribute to hobbies
--
alter table emp rename column sports to hobbies
.)C
.(C
--
-- make a change to an inherited attribute
--
alter table person * rename column last_name to family_name
.)C
.SH BUGS
Execution of historical queries using classes and attributes whose
names have changed will produce incorrect results in many situations.
.PP
Renaming of types, operators, rules, etc., should also be supported.
