/**
 *
 * $Id: VaSimple.c,v 1.12 1996/04/30 23:59:32 toshok Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * Portions of this work are derived from X11R6/xc/lib/Xt/Varargs.c, which
 * is distributed under the following copyright:
 *
 * Copyright (c) 1985, 1986, 1987, 1988, 1989, 1994  X Consortium
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Except as contained in this notice, the name of the X Consortium shall not be
 * used in advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from the X Consortium.
 *
 **/

static char rcsid[] = "$Id: VaSimple.c,v 1.12 1996/04/30 23:59:32 toshok Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/ToggleBGP.h>
#include <Xm/PushBGP.h>
#include <Xm/CascadeBGP.h>
#include <Xm/SeparatoGP.h>
#include <Xm/RowColumnP.h>
#include <Xm/VaSimpleP.h>
#include <Xm/DebugUtil.h>
#include <X11/Xfuncs.h>
#include <stdio.h>

/* this seems realistic to me */
#define MAX_EMBEDDED_BUTTONS	512
static XmButtonType button_types[MAX_EMBEDDED_BUTTONS];
static XmString button_strings[MAX_EMBEDDED_BUTTONS];
static KeySym button_mnemonics[MAX_EMBEDDED_BUTTONS];
static String button_accel[MAX_EMBEDDED_BUTTONS];
static XmString button_acc_text[MAX_EMBEDDED_BUTTONS];

#define Offset(field) XtOffsetOf(XmSimpleMenuRec, field)
static XtResource simple_resources[] = {
    {XmNbuttonAccelerators, XmCButtonAccelerators, XmRStringTable, sizeof(String *),
     Offset(accelerator), XmRImmediate, (XtPointer)NULL},
    {XmNbuttonAcceleratorText, XmCButtonAcceleratorText, XmRXmStringTable, sizeof(XmStringTable),
     Offset(accelerator_text), XmRImmediate, (XtPointer)NULL},
    {XmNbuttonCount, XmCButtonCount, XmRInt, sizeof(int),
     Offset(count), XmRImmediate, (XtPointer)0},
    {XmNbuttonMnemonicCharSets, XmCButtonMnemonicCharSets, XmRStringTable, sizeof(String *),
     Offset(mnemonic_charset), XmRImmediate, (XtPointer)NULL},
    {XmNbuttonMnemonics, XmCButtonMnemonics, XmRKeySymTable, sizeof(XmKeySymTable),
     Offset(mnemonic), XmRImmediate, (XtPointer)NULL},
    {XmNbuttons, XmCButtons, XmRXmStringTable, sizeof(XmStringTable),
     Offset(label_string), XmRImmediate, (XtPointer)NULL},
    {XmNbuttonSet, XmCButtonSet, XmRInt, sizeof(int),
     Offset(button_set), XmRImmediate, (XtPointer)-1},
    {XmNbuttonType, XmCButtonType, XmRPointer, sizeof(XtPointer),
     Offset(button_type), XmRImmediate, (XtPointer)NULL},
    {XmNoptionLabel, XmCOptionLabel, XmRXmString, sizeof(XmString),
     Offset(option_label), XmRImmediate, (XtPointer)NULL},
    {XmNoptionLabel, XmCOptionLabel, XmRXmString, sizeof(XmString),
     Offset(option_label), XmRImmediate, (XtPointer)NULL},
    {XmNoptionMnemonic, XmCOptionMnemonic, XmRKeySym, sizeof(KeySym),
     Offset(option_mnemonic), XmRImmediate, (XtPointer)NULL},
    {XmNpostFromButton, XmCPostFromButton, XmRInt, sizeof(int),
     Offset(option_mnemonic), XmRImmediate, (XtPointer)NULL},
    {XmNsimpleCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
     Offset(callback), XmRImmediate, (XtPointer)NULL},
};

extern Widget _XtCreateWidget(String,
			      WidgetClass,
			      Widget,
			      ArgList, Cardinal,
			      XtTypedArgList, Cardinal);

extern Widget _XmCreateSimpleGadget(char *, 
				    Widget parent, 
				    int def_type,
				    XmSimpleMenu data, 
				    int which, 
				    ArgList args, int argc);

/*
 *    Given a nested list, _XmCountNestedList() returns counts of the
 *    total number of attribute-value pairs and the count of those
 *    attributes that are typed. The list is counted recursively.
 */
static  void
_XmCountNestedList(XtTypedArgList avlist, int *total_count, int *typed_count)
{
    for (; avlist->name != NULL; avlist++) {
        if (strcmp(avlist->name, XtVaNestedList) == 0) {
            _XmCountNestedList((XtTypedArgList)avlist->value, total_count,
                	       typed_count);
        }
	else {
            if (avlist->type != NULL) {
                ++(*typed_count);
            }
            ++(*total_count);
        }
    }    
}

/*
 *    Given a variable length attribute-value list, _XmCountVaList()
 *    returns counts of the total number of attribute-value pairs,
 *    and the count of the number of those attributes that are typed.
 *    The list is counted recursively.
 */
void
_XmCountVaList(va_list var, int *button_count, int *args_count,
	       int *typed_count, int *total_count)
{
    String          attr;
    
    *total_count = 0;
    *typed_count = 0;
    *button_count = 0;
    *args_count = 0;
    bzero((void *)button_types, MAX_EMBEDDED_BUTTONS * sizeof(unsigned char));
    bzero((void *)button_strings, MAX_EMBEDDED_BUTTONS * sizeof(XmString));
    bzero((void *)button_mnemonics, MAX_EMBEDDED_BUTTONS * sizeof(KeySym));
    bzero((void *)button_accel, MAX_EMBEDDED_BUTTONS * sizeof(String));
    bzero((void *)button_acc_text, MAX_EMBEDDED_BUTTONS * sizeof(XmString));
 
    for(attr = va_arg(var, String) ; attr != NULL;
                        attr = va_arg(var, String)) {
        if (strcmp(attr, XtVaTypedArg) == 0) {
            (void)va_arg(var, String);
            (void)va_arg(var, String);
            (void)va_arg(var, XtArgVal);
            (void)va_arg(var, int);
            ++(*total_count);
            ++(*typed_count);
        }
	else if (strcmp(attr, XtVaNestedList) == 0) {
            _XmCountNestedList(va_arg(var, XtTypedArgList),
				total_count,
				typed_count);
        }
	else if (strcmp(attr, XmVaCASCADEBUTTON) == 0) {
	    /* label - XmString, mnemonic - KeySym */
	    button_types[*button_count] = XmCASCADEBUTTON;
	    button_strings[*button_count] = va_arg(var, XmString);
	    button_mnemonics[*button_count] = va_arg(var, KeySym);
	    ++(*button_count);
	}
	else if (strcmp(attr, XmVaCHECKBUTTON) == 0 ||
		 strcmp(attr, XmVaPUSHBUTTON) == 0 ||
		 strcmp(attr, XmVaRADIOBUTTON) == 0 || 
		 strcmp(attr, XmVaTOGGLEBUTTON) == 0) {
	    if (strcmp(attr, XmVaCHECKBUTTON) == 0)
		    button_types[*button_count] = XmCHECKBUTTON;
	    else if (strcmp(attr, XmVaPUSHBUTTON) == 0)
		    button_types[*button_count] = XmPUSHBUTTON;
	    else if (strcmp(attr, XmVaRADIOBUTTON) == 0)
		    button_types[*button_count] = XmRADIOBUTTON;
	    else if (strcmp(attr, XmVaTOGGLEBUTTON) == 0)
		    button_types[*button_count] = XmTOGGLEBUTTON;
	    /* label - XmString, mnemonic - KeySym, accelerator - String,
	       accelerator_text - XmString */
	    button_strings[*button_count] = va_arg(var, XmString);
	    button_mnemonics[*button_count] = va_arg(var, KeySym);
	    button_accel[*button_count] = va_arg(var, String);
	    button_acc_text[*button_count] = va_arg(var, XmString);
	    ++(*button_count);
	}
	else if (strcmp(attr, XmVaTITLE) == 0) {
 	    /* title - XmString */
	    if (strcmp(attr, XmVaTITLE) == 0)
		    button_types[*button_count] = XmTITLE;
	    button_strings[*button_count] = va_arg(var, XmString);
	    ++(*button_count);
	}
	else if (strcmp(attr, XmVaDOUBLE_SEPARATOR) == 0 ||
		 strcmp(attr, XmVaSEPARATOR) == 0 ||
		 strcmp(attr, XmVaSINGLE_SEPARATOR) == 0) {
	    /* just eat it, and up the button count */
	    if (strcmp(attr, XmVaDOUBLE_SEPARATOR) == 0)
		    button_types[*button_count] = XmDOUBLE_SEPARATOR;
	    else if (strcmp(attr, XmVaSEPARATOR) == 0)
		    button_types[*button_count] = XmSEPARATOR;
	    else if (strcmp(attr, XmVaSINGLE_SEPARATOR) == 0)
		    button_types[*button_count] = XmSEPARATOR;
	    ++(*button_count);
	}
	else {
            (void)va_arg(var, XtArgVal);
            ++(*total_count);
	    ++(*args_count);
	}
    }
}

/*
 *    _XmTypedArgToArg() invokes a resource converter to convert the
 *    passed typed arg into a name/value pair and stores the name/value
 *    pair in the passed Arg structure.  If memory is allocated for the
 *    converted value, the address is returned in the value field of 
 *    memory_return; otherwise that field is NULL.  The function returns
 *    1 if the conversion succeeded and 0 if the conversion failed.
 */
static int
_XmTypedArgToArg(Widget widget, XtTypedArgList typed_arg, ArgList arg_return,
		 XtResourceList resources, Cardinal num_resources,
		 ArgList memory_return)
{     
    String              to_type = NULL;
    XrmValue            from_val, to_val;
      

    if (widget == NULL) {
	_XmWarning(NULL, "Attempt to convert TypedArg for NULL Widget.");
        return(0);
    }
       
    /* again we assume that the XtResourceList is un-compiled */

    for (; num_resources--; resources++)
	if (strcmp(typed_arg->name, resources->resource_name) == 0) {
	    to_type = resources->resource_type;
	    break;
	}

    if (to_type == NULL) {
        _XmWarning(widget, "Unable to find type of resource for conversion");
        return(0);
    }
       
    to_val.addr = NULL;
    from_val.size = typed_arg->size;
    if ((strcmp(typed_arg->type, XtRString) == 0) ||
            (typed_arg->size > sizeof(XtArgVal))) {
        from_val.addr = (XPointer)typed_arg->value;
    }
    else {
            from_val.addr = (XPointer)&typed_arg->value;
    }
       
    XtConvertAndStore(widget, typed_arg->type, &from_val, to_type, &to_val);
 
    if (to_val.addr == NULL) {
        _XmWarning(widget, "Type conversion failed");
        return(0);
    }

    arg_return->name = typed_arg->name;
    memory_return->value = (XtArgVal) NULL;

    if (strcmp(to_type, XtRString) == 0) {
	arg_return->value = (XtArgVal) to_val.addr;
    }
    else {
	if (to_val.size == sizeof(long))
	    arg_return->value = (XtArgVal) *(long *)to_val.addr;
	else if (to_val.size == sizeof(short))
	    arg_return->value = (XtArgVal) *(short *)to_val.addr;
	else if (to_val.size == sizeof(char))
	    arg_return->value = (XtArgVal) *(char *)to_val.addr;
	else if (to_val.size == sizeof(XtArgVal))
	    arg_return->value = *(XtArgVal *)to_val.addr;
	else if (to_val.size > sizeof(XtArgVal)) {
	    arg_return->value = (XtArgVal) XtMalloc(to_val.size);
	    memory_return->value = (XtArgVal)
		memcpy((void *)arg_return->value, to_val.addr, to_val.size);
	}
    }
       
    return(1);
}


/*
 *    _XmNestedArgtoArg() converts the passed nested list into
 *    an ArgList/count.
 */
static int
_XmNestedArgtoArg(Widget widget, XtTypedArgList avlist, ArgList args,
		  XtResourceList resources, Cardinal num_resources,
		  ArgList memory_return)
{
    int         count = 0;
 
    for (; avlist->name != NULL; avlist++) {
        if (avlist->type != NULL) {
            /* If widget is NULL, the typed arg is ignored */
            if (widget != NULL) {
                /* this is a typed arg */
                count += _XmTypedArgToArg(widget, avlist, (args+count),
					  resources, num_resources,
					  (memory_return+count));
            }
        }
	else if (strcmp(avlist->name, XtVaNestedList) == 0) {
            count += _XmNestedArgtoArg(widget, (XtTypedArgList)avlist->value,
				       (args+count), resources, num_resources,
				       (memory_return+count));
        }
	else {
            (args+count)->name = avlist->name;
            (args+count)->value = avlist->value;
            ++count;
        }
    }

    return(count);
}

/*
 * Free memory allocated through _XmVaToArgList.  The actual args array
 * size is expected to be total_count * 2, where total_count is the number
 * of elements needed for resource representations.  The lower half of the
 * array contains pairs of resource names and values as usual.  For each
 * element [n] in the lower half of the array, the value field of the
 * corresponding element [n + total_count] in the upper half of the array
 * has been pressed into service in order to note whether the resource value
 * is a pointer to memory that was allocated in _XmTypedArgToArg.  In the
 * upper half, if the value field is not NULL, it contains the address of
 * memory which should now be freed.  That memory could have been allocated
 * only as a result of the conversion of typed arguments.  Therefore, if
 * there were no typed arguments in the original varargs, there is no need
 * to examine the upper half of the array.  In the choice of data structure
 * to make this representation, priority was given to the wish to retrofit
 * the release of memory around the existing signature of _XmVaToArgList.
 */
static void
_XmFreeArgList(ArgList args, int total_count, int typed_count)
{
    ArgList p;

    if (args) {
	if (typed_count)
	    for (p = args + total_count; total_count--; ++p) {
		if (p->value) XtFree((char *)p->value);
	    }
	XtFree((char *)args);
    }
}


/*
 * Description: Retreives the normal and constraint resources
 *              for this widget.
 * Arguments: widget - the widget.
 * RETURNED        res_list - the list of resource for this widget
 * RETURNED        number - the number of resources in the above list.
 * Returns: none
 */
static void
_XmGetResources(Widget widget, XtResourceList *res_list, Cardinal *number)
{
    Widget parent = XtParent(widget);

    XtInitializeWidgetClass(XtClass(widget));
    XtGetResourceList(XtClass(widget), res_list, number);
    
    if (!XtIsShell(widget) && parent && XtIsConstraint(parent)) {
	XtResourceList res, constraint, cons_top;
	Cardinal num_constraint, temp;

	XtGetConstraintResourceList(XtClass(parent), &constraint, 
				    &num_constraint);

	cons_top = constraint;
	*res_list = (XtResourceList) XtRealloc((char*)*res_list, 
					       ((*number + num_constraint) * 
						sizeof(XtResource)));

	for (temp= num_constraint, res= *res_list + *number; temp != 0; temp--)
	    *res++ = *constraint++;

	*number += num_constraint;
	XtFree( (XtPointer) cons_top);
    }
}
 
/* 
 *    Given a variable argument list, _XmVaToArgList() returns the 
 *    equivalent ArgList and count. _XmVaToArgList() handles nested 
 *    lists and typed arguments.  If typed arguments are present, the
 *    ArgList should be freed with _XmFreeArgList.
 */
static void
_XmVaToArgList(Widget widget, va_list var, int max_count,
	       ArgList *args_return, Cardinal *num_args_return)
{
    String		attr;
    int			count;
    ArgList		args = (ArgList)NULL;
    XtTypedArg		typed_arg;
    XtResourceList	resources = (XtResourceList)NULL;
    Cardinal		num_resources;
    Boolean		fetched_resource_list = False;

    if (max_count  == 0) {
	*num_args_return = 0;
	*args_return = (ArgList)NULL;
	return;
    }

    max_count *= 2;
    args = (ArgList)XtMalloc((unsigned)(max_count * sizeof(Arg)));
    for (count = max_count; --count >= 0; )
	args[count].value = (XtArgVal) NULL;
    max_count /= 2;
    count = 0;

    for(attr = va_arg(var, String) ; attr != NULL;
			attr = va_arg(var, String)) {
	if (strcmp(attr, XtVaTypedArg) == 0) {
	    typed_arg.name = va_arg(var, String);
	    typed_arg.type = va_arg(var, String);
	    typed_arg.value = va_arg(var, XtArgVal);
	    typed_arg.size = va_arg(var, int);

	    /* if widget is NULL, typed args are ignored */
	    if (widget != NULL) {
		if (!fetched_resource_list) {
		    _XmGetResources(widget, &resources, &num_resources);
		    fetched_resource_list = True;
		}
		count += _XmTypedArgToArg(widget, &typed_arg, &args[count],
					  resources, num_resources,
					  &args[max_count + count]);
	    }
	} else if (strcmp(attr, XtVaNestedList) == 0) {
	    if (widget != NULL || !fetched_resource_list) {
		_XmGetResources(widget, &resources, &num_resources);
		fetched_resource_list = True;
	    }

	    count += _XmNestedArgtoArg(widget, va_arg(var, XtTypedArgList),
				       &args[count], resources, num_resources,
				       &args[max_count + count]);
	}
	else if (strcmp(attr, XmVaCASCADEBUTTON) == 0) {
	    /* label - XmString, mnemonic - KeySym */
	    (void)va_arg(var, XmString);
	    (void)va_arg(var, KeySym);
	}
	else if (strcmp(attr, XmVaCHECKBUTTON) == 0 ||
		 strcmp(attr, XmVaPUSHBUTTON) == 0 ||
		 strcmp(attr, XmVaRADIOBUTTON) == 0 || 
		 strcmp(attr, XmVaTOGGLEBUTTON) == 0) {
	    /* label - XmString, mnemonic - KeySym, accelerator - String,
	       accelerator_text - XmString */
	    (void)va_arg(var, XmString);
	    (void)va_arg(var, KeySym);
	    (void)va_arg(var, String);
	    (void)va_arg(var, XmString);
	}
	else if (strcmp(attr, XmVaTITLE) == 0) {
 	    /* title - XmString */
	    (void)va_arg(var, XmString);
	}
	else if (strcmp(attr, XmVaDOUBLE_SEPARATOR) == 0 ||
		 strcmp(attr, XmVaSEPARATOR) == 0 ||
		 strcmp(attr, XmVaSINGLE_SEPARATOR) == 0) {
	    /* just eat it */
	}
	else {
	    args[count].name = attr;
	    args[count].value = va_arg(var, XtArgVal);
	    count ++;
	}
    }

    XtFree((XtPointer)resources);

    *num_args_return = (Cardinal)count;
    *args_return = (ArgList)args;
}

static int
_XmNestedArgtoTypedArg(XtTypedArgList args, 
		       XtTypedArgList avlist) 
{    
    int         count = 0;
     
    for (; avlist->name != NULL; avlist++) { 
        if (avlist->type != NULL) { 
            (args+count)->name = avlist->name; 
            (args+count)->type = avlist->type; 
            (args+count)->size = avlist->size;
            (args+count)->value = avlist->value;
            ++count; 
        }
	else if(strcmp(avlist->name, XtVaNestedList) == 0) {             
            count += _XmNestedArgtoTypedArg((args+count),  
                            (XtTypedArgList)avlist->value); 
        }
	else {                             
            (args+count)->name = avlist->name; 
	    (args+count)->type = NULL;
            (args+count)->value = avlist->value; 
            ++count;
        }                                     
    }         
    return(count);
}


/*
 *    Given a variable argument list, _XmVaToTypedArgList() returns 
 *    the equivalent TypedArgList. _XmVaToTypedArgList() handles nested
 *    lists.
 *    Note: _XmVaToTypedArgList() does not do type conversions.
 */
void
_XmVaToTypedArgList(va_list var, int max_count,
		    XtTypedArgList *args_return, Cardinal *num_args_return)
{
    XtTypedArgList	args = NULL;
    String              attr;
    int			count;

    args = (XtTypedArgList)
	XtMalloc((unsigned)(max_count * sizeof(XtTypedArg))); 

    for(attr = va_arg(var, String), count = 0 ; attr != NULL;
		    attr = va_arg(var, String)) {
        if (strcmp(attr, XtVaTypedArg) == 0) {
	    args[count].name = va_arg(var, String);
	    args[count].type = va_arg(var, String);
	    args[count].value = va_arg(var, XtArgVal);
	    args[count].size = va_arg(var, int);
	    ++count;
	}
	else if (strcmp(attr, XtVaNestedList) == 0) {
   	    count += _XmNestedArgtoTypedArg(&args[count], 
			va_arg(var, XtTypedArgList));
	}
	else if (strcmp(attr, XmVaCASCADEBUTTON) == 0) {
	    /* label - XmString, mnemonic - KeySym */
	    (void)va_arg(var, XmString);
	    (void)va_arg(var, KeySym);
	}
	else if (strcmp(attr, XmVaCHECKBUTTON) == 0 ||
		 strcmp(attr, XmVaPUSHBUTTON) == 0 ||
		 strcmp(attr, XmVaRADIOBUTTON) == 0 || 
		 strcmp(attr, XmVaTOGGLEBUTTON) == 0) {
	    /* label - XmString, mnemonic - KeySym, accelerator - String,
	       accelerator_text - XmString */
	    (void)va_arg(var, XmString);
	    (void)va_arg(var, KeySym);
	    (void)va_arg(var, String);
	    (void)va_arg(var, XmString);
	}
	else if (strcmp(attr, XmVaTITLE) == 0) {
 	    /* title - XmString */
	    (void)va_arg(var, XmString);
	}
	else if (strcmp(attr, XmVaDOUBLE_SEPARATOR) == 0 ||
		 strcmp(attr, XmVaSEPARATOR) == 0 ||
		 strcmp(attr, XmVaSINGLE_SEPARATOR) == 0) {
	    /* just eat it */
	}
	else {
	    args[count].name = attr;
	    args[count].type = NULL;
	    args[count].value = va_arg(var, XtArgVal);
	    ++count;
	}
    }

    *args_return = args;
    *num_args_return = count;
}

Widget
XmVaCreateSimpleCheckBox(Widget parent,
			 String name,
			 XtCallbackProc callback,
			 ...)
{
    va_list var;
    Widget rc;
    Arg myArgList[5];
    char buf[32];
    int i, n, total_count, typed_count, args_count, button_count;
    ArgList args;
    XmSimpleMenuRec data;
    XtTypedArgList typed_args = NULL;
    Cardinal num_args;

    XdbDebug(__FILE__, parent, "XmVaCreateSimpleCheckBox();\n");

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    memset((void *)&data, 0, sizeof(XmSimpleMenuRec));

    n = 0;
#if 0
    XtSetArg(myArgList[n], XmNrowColumnType, XmWORK_AREA); n++;
#endif
    XtSetArg(myArgList[n], XmNradioAlwaysOne, False); n++;
    XtSetArg(myArgList[n], XmNisHomogeneous, True); n++;
    XtSetArg(myArgList[n], XmNentryClass, xmToggleButtonGadgetClass); n++;

    Va_start(var, callback);
    _XmCountVaList(var, &button_count, &args_count, &typed_count, &total_count);
    va_end(var);

    Va_start(var, callback);
    _XmVaToTypedArgList(var, total_count, &typed_args, &num_args);

    rc = _XtCreateWidget(name,
			 xmRowColumnWidgetClass,
			 parent,
			 myArgList, n,
			 typed_args, num_args);
    if (typed_args != NULL) {
	XtFree((XtPointer)typed_args);
    }
    va_end(var);

    Va_start(var, callback);
    _XmVaToArgList(rc, var, total_count, &args, &num_args);
    XtGetApplicationResources(rc, (XtPointer)&data, 
			      simple_resources, XtNumber(simple_resources),
			      args, num_args);
    if (data.count == 0)
	data.count = button_count;
    data.callback = callback;
    data.button_type = button_types;
    data.label_string = button_strings;
    data.mnemonic = button_mnemonics;
    data.accelerator = button_accel;
    data.accelerator_text = button_acc_text;

    for (i = 0; i < data.count; i++) {
	sprintf(buf, "button_%d", i);
        _XmCreateSimpleGadget(buf, rc, XmTOGGLEBUTTON, &data, i, args, num_args);
    }
    va_end(var);
    if (num_args != 0) {
	_XmFreeArgList(args, total_count, typed_count);
    }

    return rc;
}

Widget
XmVaCreateSimpleMenuBar(Widget parent,
			String name,
			...)
{
    va_list var;
    Widget rc;
    Arg myArgList[5];
    char buf[32];
    int i, n, total_count, typed_count, args_count, button_count;
    ArgList args;
    XmSimpleMenuRec data;
    XtTypedArgList typed_args = NULL;
    Cardinal num_args;

    XdbDebug(__FILE__, parent, "XmVaCreateSimpleMenuBar();\n");

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    memset((void *)&data, 0, sizeof(XmSimpleMenuRec));

    n = 0;
    XtSetArg(myArgList[n], XmNrowColumnType, XmMENU_BAR); n++;
    XtSetArg(myArgList[n], XmNentryClass, xmCascadeButtonGadgetClass); n++;
    XtSetArg(myArgList[n], XmNisHomogeneous, True); n++;

    Va_start(var, name);
    _XmCountVaList(var, &button_count, &args_count, &typed_count, &total_count);
    va_end(var);

    Va_start(var, name);
    _XmVaToTypedArgList(var, total_count, &typed_args, &num_args);

    rc = _XtCreateWidget(name,
			 xmRowColumnWidgetClass,
			 parent,
			 myArgList, n,
			 typed_args, num_args);
    if (typed_args != NULL) {
	XtFree((XtPointer)typed_args);
    }
    va_end(var);

    Va_start(var, name);
    _XmVaToArgList(rc, var, total_count, &args, &num_args);
    XtGetApplicationResources(rc, (XtPointer)&data, 
			      simple_resources, XtNumber(simple_resources),
			      args, num_args);
    if (data.count == 0)
	data.count = button_count;
    data.button_type = button_types;
    data.label_string = button_strings;
    data.mnemonic = button_mnemonics;
    data.accelerator = button_accel;
    data.accelerator_text = button_acc_text;

    for (i = 0; i < data.count; i++) {
	sprintf(buf, "button_%d", i);
        _XmCreateSimpleGadget(buf, rc, XmCASCADEBUTTON, &data, i, args, num_args);
    }
    va_end(var);
    if (num_args != 0) {
	_XmFreeArgList(args, total_count, typed_count);
    }

    return rc;
}

Widget
XmVaCreateSimpleOptionMenu(Widget parent,
			   String name,
			   XmString option_label,
			   KeySym option_mnemonic,
			   int button_set,
			   XtCallbackProc callback,
			   ...)
{
    va_list var;
    Widget rc, label;
    Arg myArgList[5];
    ArgList args;
    char buf[32];
    int i, n, total_count, typed_count, args_count, button_count;
    XmSimpleMenuRec data;
    char *oname;
    XtTypedArgList typed_args = NULL;
    Cardinal num_args = 0;
    int mt = 0;

    XdbDebug(__FILE__, parent, "XmVaCreateSimpleOptionMenu();\n");

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    memset((void *)&data, 0, sizeof(XmSimpleMenuRec));

    n = 0;
    XtSetArg(myArgList[n], XmNrowColumnType, XmMENU_OPTION); n++;

    Va_start(var, callback);
    _XmCountVaList(var, &button_count, &args_count, &typed_count, &total_count);
    va_end(var);

    Va_start(var, callback);
    _XmVaToTypedArgList(var, total_count, &typed_args, &num_args);

    rc = _XtCreateWidget(name,
			 xmRowColumnWidgetClass,
			 parent,
			 myArgList, n,
			 typed_args, num_args);
    if (typed_args != NULL) {
	XtFree((XtPointer)typed_args);
    }
    va_end(var);

    XtVaGetValues(rc, XmNrowColumnType, &mt, NULL);
    XdbDebug(__FILE__, rc, "RCTYPE: %d\n", mt);

    Va_start(var, callback);
    _XmVaToArgList(rc, var, total_count, &args, &num_args);
    XtGetApplicationResources(rc, (XtPointer)&data, 
			      simple_resources, XtNumber(simple_resources),
			      args, num_args);
    data.option_label = option_label;
    data.option_mnemonic = option_mnemonic;
    data.button_set = button_set;
    if (data.count == 0)
	data.count = button_count;
    data.callback = callback;
    data.button_type = button_types;
    data.label_string = button_strings;
    data.mnemonic = button_mnemonics;
    data.accelerator = button_accel;
    data.accelerator_text = button_acc_text;

    oname = XtMalloc(strlen(name) + strlen("_label") + 1);
    strcpy(oname, name);
    strcat(oname, "_label");
    n = 0;
    RC_OptionLabel(rc) = XmStringCopy(option_label);
    XtSetArg(myArgList[n], XmNlabelString, RC_OptionLabel(rc)); n++;
    label = XmCreateLabelGadget(rc, oname, myArgList, n);
    XtManageChild(label);
    XtFree(oname);

    oname = XtMalloc(strlen(name) + strlen("_cascade") + 1);
    strcpy(oname, name);
    strcat(oname, "_cascade");
    n = 0;
    XtSetArg(myArgList[n], XmNmnemonic, option_mnemonic); n++;
    RC_CascadeBtn(rc) = XmCreateCascadeButtonGadget(rc, oname, myArgList, n);
    XtManageChild(RC_CascadeBtn(rc));
    XtFree(oname);

#if 0
    /* This isn't right.  This should be passed in by the user, and we should
     * check to see if the subMenuId is not set.  If it isn't we should fail
     * the call.
     */
    oname = XtMalloc(strlen(name) + strlen("_option") + 1);
    strcpy(oname, name);
    strcat(oname, "_option");
    n = 0;
    XtSetArg(myArgList[n], XmNrowColumnType, XmMENU_PULLDOWN); n++;
    RC_OptionSubMenu(rc) = XmCreateRowColumn(rc, oname, myArgList, n);
    XtVaSetValues(RC_CascadeBtn(rc), XmNsubMenuId, RC_OptionSubMenu(rc), NULL);
    XtFree(oname);
#endif

    for (i = 0; i < data.count; i++) {
	sprintf(buf, "button_%d", i);
        _XmCreateSimpleGadget(buf, RC_OptionSubMenu(rc), XmPUSHBUTTON, &data, i, args, num_args);
    }
    va_end(var);

    if (num_args != 0) { 
	_XmFreeArgList(args, total_count, typed_count);
    }

    return rc;
}

Widget
XmVaCreateSimplePopupMenu(Widget parent,
			  String name,
			  XtCallbackProc callback,
			  ...)
{
    va_list var;
    Widget rc;
    Arg myArgList[5];
    char buf[32];
    int i, n, total_count, typed_count, args_count, button_count;
    ArgList args;
    XmSimpleMenuRec data;
    XtTypedArgList typed_args = NULL;
    Cardinal num_args;

    XdbDebug(__FILE__, parent, "XmVaCreateSimplePopupMenu();\n");

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    memset((void *)&data, 0, sizeof(XmSimpleMenuRec));

    n = 0;
    XtSetArg(myArgList[n], XmNrowColumnType, XmMENU_POPUP); n++;

    Va_start(var, callback);
    _XmCountVaList(var, &button_count, &args_count, &typed_count, &total_count);
    va_end(var);

    Va_start(var, callback);
    _XmVaToTypedArgList(var, total_count, &typed_args, &num_args);

    rc = _XtCreateWidget(name,
			 xmRowColumnWidgetClass,
			 parent,
			 myArgList, n,
			 typed_args, num_args);
    if (typed_args != NULL) {
	XtFree((XtPointer)typed_args);
    }
    va_end(var);

    Va_start(var, callback);
    _XmVaToArgList(rc, var, total_count, &args, &num_args);
    XtGetApplicationResources(rc, (XtPointer)&data, 
			      simple_resources, XtNumber(simple_resources),
			      args, num_args);
    if (data.count == 0)
	data.count = button_count;
    data.callback = callback;
    data.button_type = button_types;
    data.label_string = button_strings;
    data.mnemonic = button_mnemonics;
    data.accelerator = button_accel;
    data.accelerator_text = button_acc_text;

    for (i = 0; i < data.count; i++) {
	sprintf(buf, "button_%d", i);
        _XmCreateSimpleGadget(buf, rc, XmTOGGLEBUTTON, &data, i, args, num_args);
    }
    va_end(var);
    if (num_args != 0) {
	_XmFreeArgList(args, total_count, typed_count);
    }

    return rc;
}

Widget
XmVaCreateSimplePulldownMenu(Widget parent,
			     String name,
			     int post_from_button,
			     XtCallbackProc callback,
			     ...)
{
    va_list var;
    Widget rc;
    Arg myArgList[5];
    char buf[32];
    int i, n, total_count, typed_count, args_count, button_count;
    ArgList args;
    XmSimpleMenuRec data;
    XtTypedArgList typed_args = NULL;
    Cardinal num_args;

    XdbDebug(__FILE__, parent, "XmVaCreateSimplePulldownMenu();\n");

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    memset((void *)&data, 0, sizeof(XmSimpleMenuRec));

    n = 0;
    XtSetArg(myArgList[n], XmNrowColumnType, XmMENU_PULLDOWN); n++;

    Va_start(var, callback);
    _XmCountVaList(var, &button_count, &args_count, &typed_count, &total_count);
    va_end(var);

    Va_start(var, callback);
    _XmVaToTypedArgList(var, total_count, &typed_args, &num_args);

    rc = _XtCreateWidget(name,
			 xmRowColumnWidgetClass,
			 parent,
			 myArgList, n,
			 typed_args, num_args);
    if (typed_args != NULL) {
	XtFree((XtPointer)typed_args);
    }
    va_end(var);

    Va_start(var, callback);
    _XmVaToArgList(rc, var, total_count, &args, &num_args);
    XtGetApplicationResources(rc, (XtPointer)&data, 
			      simple_resources, XtNumber(simple_resources),
			      args, num_args);
    data.post_from_button = post_from_button;
    if (data.count == 0)
	data.count = button_count;
    data.callback = callback;
    data.button_type = button_types;
    data.label_string = button_strings;
    data.mnemonic = button_mnemonics;
    data.accelerator = button_accel;
    data.accelerator_text = button_acc_text;

    for (i = 0; i < data.count; i++) {
	sprintf(buf, "button_%d", i);
        _XmCreateSimpleGadget(buf, rc, XmPUSHBUTTON, &data, i, args, num_args);
    }
    va_end(var);
    if (num_args != 0) {
	_XmFreeArgList(args, total_count, typed_count);
    }

    return rc;
}

Widget
XmVaCreateSimpleRadioBox(Widget parent,
			 String name,
			 int button_set,
			 XtCallbackProc callback,
			 ...)
{
    va_list var;
    Widget rc, tgl;
    Arg myArgList[5];
    char buf[32];
    int i, n, total_count, typed_count, args_count, button_count;
    ArgList args;
    XmSimpleMenuRec data;
    XtTypedArgList typed_args = NULL;
    Cardinal num_args;

    XdbDebug(__FILE__, parent, "XmVaCreateSimpleRadioBox();\n");

    while (parent && !XtIsComposite(parent))
	parent = XtParent(parent);

    memset((void *)&data, 0, sizeof(XmSimpleMenuRec));

    n = 0;
#if 0
    XtSetArg(myArgList[n], XmNrowColumnType, XmWORK_AREA); n++;
#endif
    XtSetArg(myArgList[n], XmNradioAlwaysOne, True); n++;
    XtSetArg(myArgList[n], XmNisHomogeneous, True); n++;
    XtSetArg(myArgList[n], XmNentryClass, xmToggleButtonGadgetClass); n++;

    Va_start(var, callback);
    _XmCountVaList(var, &button_count, &args_count, &typed_count, &total_count);
    va_end(var);

    Va_start(var, callback);
    _XmVaToTypedArgList(var, total_count, &typed_args, &num_args);

    rc = _XtCreateWidget(name,
			 xmRowColumnWidgetClass,
			 parent,
			 myArgList, n,
			 typed_args, num_args);
    if (typed_args != NULL) {
	XtFree((XtPointer)typed_args);
    }
    va_end(var);

    Va_start(var, callback);
    _XmVaToArgList(rc, var, total_count, &args, &num_args);
    XtGetApplicationResources(rc, (XtPointer)&data, 
			      simple_resources, XtNumber(simple_resources),
			      args, num_args);
    data.button_set = button_set;
    data.callback = callback;
    if (data.count == 0)
	data.count = button_count;
    data.button_type = button_types;
    data.label_string = button_strings;
    data.mnemonic = button_mnemonics;
    data.accelerator = button_accel;
    data.accelerator_text = button_acc_text;

    for (i = 0; i < data.count; i++) {
	sprintf(buf, "button_%d", i);
       tgl = _XmCreateSimpleGadget(buf, rc, XmRADIOBUTTON, &data, i,
                                   args, num_args);
       if ((data.button_set > 0) &&
           XmIsToggleButton(tgl) &&
           (i == data.button_set))
           XmToggleButtonSetState(tgl, True, False);
       else if ((data.button_set > 0) &&
                XmIsToggleButtonGadget(tgl) &&
                (i == data.button_set))
           XmToggleButtonGadgetSetState(tgl, True, False);
    }
    va_end(var);
    if (num_args != 0) {
	_XmFreeArgList(args, total_count, typed_count);
    }
 
    return rc;
}

