/**
 *
 * $Id: TrackLoc.c,v 1.7 1996/02/09 15:17:09 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: TrackLoc.c,v 1.7 1996/02/09 15:17:09 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>

Widget
XmTrackingEvent(Widget widget,
                Cursor cursor,
                Boolean confine_to,
                XEvent *event_return)
{
    Window confine_to_this;
    XEvent ev;

    if (confine_to)
	confine_to_this = XtWindow(widget);
    else
	confine_to_this = None;

    XGrabPointer(XtDisplay(widget),
		 XtWindow(widget),
		 True,
		 ButtonReleaseMask | ButtonPressMask,
		 GrabModeAsync,
		 GrabModeAsync,
		 confine_to_this,
		 cursor,
		 CurrentTime);

    while (True)
    {
	XtAppNextEvent(XtWidgetToApplicationContext(widget), &ev);

	if (ev.xbutton.type == KeyRelease
	    || (ev.xbutton.type == ButtonRelease
		&& ev.xbutton.button == 1))
	{
	    XUngrabPointer(XtDisplay(widget),
			   CurrentTime);

	    /* If the button was clicked outside of this programs windows, the widget
	       that grabbed the pointer will get the event.  So, we check the bounds of
	       the widget against the coordinates of the event.  If they're outside, we
	       return NULL.  Otherwise we return the widget in which the event occured. */
	    
	    if (ev.xbutton.window == XtWindow(widget)
		&& (ev.xbutton.x < XtX(widget) 
		    || ev.xbutton.y < XtY(widget) 
		    || ev.xbutton.x > XtX(widget) + XtWidth(widget)
		    || ev.xbutton.y > XtY(widget) + XtHeight(widget)))
		return NULL;
	    else
		return XtWindowToWidget(XtDisplay(widget),
					ev.xbutton.window);
	}
    }
}

Widget 
XmTrackingLocate(Widget widget,
		 Cursor cursor,
		 Boolean confine_to)
{
    XEvent ev;

    return XmTrackingEvent(widget,
			   cursor,
			   confine_to,
			   &ev);
}
