/**
 *
 * $Id: XmI.h,v 1.7 1996/04/30 23:59:10 toshok Exp $
 * 
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef _XM_PI_H
#define _XM_PI_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * LessTif-specific functions/variables.  Use at the cost of incompatibility
 * with Motif 1.2
 * YOU SHOULD NOT CALL CALL THESE FUNCTIONS IF YOU DON'T KNOW WHAT YOU'RE
 * DOING!!
 */

XmFontList _XmFontListCreateDefault(Display *);
Boolean _XmFontListGetDefaultFont(XmFontList fontlist,
				  XFontStruct **font_struct);

XmFontListEntry _XmFontListEntryFromTag(XmFontList fontlist, char *tag);

String _XmMakeDialogName(String name);

extern Position _XmScrollBarValueToPos(Widget sw, int value);
extern Dimension _XmScrollBarSliderPixSize(Widget sw);

extern void _XmScrolledWindowLayout(Widget w, Boolean ParentResize,
				    Widget child, Boolean TestMode,
				    XtWidgetGeometry *childgeom,
				    Position x, Position y,
				    Dimension fw, Dimension fh);

/* resource converters */
extern Boolean _XmCvtStringToXmString(Display *, XrmValue *, Cardinal *,
				      XrmValue *, XrmValue *, XtPointer *);
extern Boolean _XmCvtStringToFontlist(Display *, XrmValue *, Cardinal *,
				      XrmValue *, XrmValue *, XtPointer *);
extern Boolean _XmCvtStringToDimension(Display *, XrmValue *, Cardinal *,
				       XrmValue *, XrmValue *, XtPointer *);
extern Boolean _XmCvtStringToPosition(Display *, XrmValue *, Cardinal *,
				      XrmValue *, XrmValue *, XtPointer *);

/* Things for Label/LabelG */

extern void _XmLabelGetPixmapSize(Widget w,Pixmap Pix,unsigned int *width,unsigned int *height);
extern void _XmLabelRecomputeSize(Widget w);
extern void _XmLabelGetPixmapSize(Widget w,Pixmap Pix, unsigned int *width, unsigned int *height);
extern void _XmCalcLabelDimensions(Widget w);
extern void _XmLabelDimensions(Widget w, Dimension *wd, Dimension *ht);
extern void _XmLabelRecalcDimensions(Widget request, Widget new);

/* GeomUtils : A lot of these I'm not sure of*/
extern void _XmGMReplyToQueryGeometry();
extern void _XmGMEnforceMargin();
extern void _XmGMCalcSize(Widget w,
			  Dimension margin_w, Dimension margin_h,
			  Dimension *retw, Dimension *reth);
extern void _XmGMDoLayout(Widget w,
			  Dimension margin_w, Dimension margin_h,
			  unsigned char resize_policy, short adjust);
extern void _XmGMHandleGeometryManager();
extern void _XmGMHandleQueryGeometry();
extern Boolean _XmGMOverlap();

/* for DialogS.c */
extern void _XmBbMap(Widget w);
extern void _XmBbUnmap(Widget w);

/* from MessageB.c */
extern void _XmMessageBoxInstallImages(Widget w);

/* from Manager.c */
extern void _XmManagerInstallAccelerator(Widget m, Widget w, String s);
extern void _XmManagerInstallMnemonic(Widget m, Widget w, KeySym mn);
extern void _XmManagerUninstallAccelerator(Widget m, Widget w);
extern void _XmManagerUninstallMnemonic(Widget m, Widget w);

/* for TearOff */
extern void _XmPushButtonSetTranslation(Widget, int);

/* TearOff */
extern void _XmTearOffInitiate(Widget w, XEvent *event);

#ifdef __cplusplus
};
#endif

#endif /* _XM_PI_H */
