#include <regex.h>
/*
 Ping hosts in specified IP range. Responding hosts will
 get an entry in /proc/net/arp; read those entries and
 construct an bootpd file from them. Also, (if asked for on
 the command line), create /tftpboot/$IP directories with the
 mknfsroot command. (also in nfsroot package).


 Security: Although this programme needs to be run as root, and
 sends packets to hosts on the network it does _not_ listen to
 anything that comes from the network directly. It only parses
 the file /proc/net/arp, a file directly generated by the kernel.
 So, I think I cannot get evil formed input form there. This,
 as fas as I can see, makes that the system() calls and
 (sometimes) not checking for bounderies in strings, are safe.


 Part of debian package nfsroot

 GNU copyleft by joost witteveen <joostje@debian.org>


 */
#include <map.h>
#include <vector>
#include <fstream.h>
#include <iostream.h> 
#include <strstream.h>
#include <unistd.h>
#include <netdb.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <resolv.h>
#include <linux/in.h>
#include <linux/time.h>
#include <linux/socket.h>
#include <signal.h>

#define IGNOREHOSTS  "/etc/nfsroot/ignorehosts"
#define PROCARP      "/proc/net/arp"
#define MKFSROOT     "/usr/sbin/mknfsroot"
#define ARPLIST      "/var/lib/nfsroot/arplist"
#define BOOTPTAB     "/etc/bootptab"
#define BOOTPTABCONF "/etc/nfsroot/bootptab"
#define BOOTPDPID    "/var/run/bootpd.pid"
#define TCENTRY      ".nrdefault"
#define HELPSTR \
   "Usage: -v   verbose output\n"\
   "       -u s make uptates to "BOOTPTAB", and /tftpboot\n"\
   "               dir entries every s seconds\n"\
   "       -i n wait n seconds between each ping (default: 1)\n"\
   "       -c n stop after count rounds (default: -1=dont''t stop)\n"\
   "       -p p use port p (default: 7=echo)\n"\
   "       -nodir do not make the /tftpboot directories\n"\
   "       -r x.x.x.x-y.y.y.y \n"\
   "            Ping sequentially IP numbers x.x.x.x through y.y.y.y\n"\
   "            (the -r option may be present any number of times)\n"
    
class strsort{
public:
  bool operator()(const char *i, const char *j) const{
    return strcmp(i,j)<0;
  }
};

vector<regex_t *> ignore_reg;
map<char *, char*, strsort > hostinfo; 
map<char *, char *, strsort > ip_hw;

int verbose=0;
int no_tftpboot_dir=0;
int update_boot=0;

int compile_ignores(){
  char buf[1024];
  char *s=buf;
  char ch;
  char errstr[1024];
  int err;
  regex_t *r;
  ifstream ignorestr(IGNOREHOSTS);
  istrstream hostexp(buf,sizeof(buf));
  while(ignorestr.get(s,sizeof(buf),'\n')){
    if((s[0]!='#')&&(s[0])){
      r=new regex_t;
      if((err=regcomp(r,s,REG_NOSUB|REG_EXTENDED|REG_ICASE))){
	regerror(err,r,errstr,sizeof(errstr));
	cerr<<errstr<<endl;
	cerr<<"in file "<<IGNOREHOSTS<<endl;
	exit(1);
      }
      ignore_reg.push_back(r);
    }
    ignorestr.get(ch);
  }
  return 0;
}


hostent *testhost(char *host){
  map<char *, char *, strsort >::iterator i;
  struct hostent *h;
  vector<regex_t *>::iterator ri;
  int l;
  int toldnsfailed=0;

  if((i=hostinfo.find(host))==hostinfo.end()){
    char *s=new char[strlen(host)+1];
    strcpy(s,host);
    h=gethostbyname(host);
    hostinfo[s]=(char *)(h!=0);
    if(h){
      h=gethostbyaddr(h->h_addr_list[0],h->h_length,AF_INET);
      if(h){
	hostinfo[s]=new char[strlen(h->h_name)+1];
	strcpy(hostinfo[s],h->h_name);
      }
      for(ri=ignore_reg.begin();ri!=ignore_reg.end();ri++){
	if(!regexec(*ri,host,0,NULL,0)){
	  hostinfo[s]=NULL; break;
	}
	if(h){
	  if(!regexec(*ri,h->h_name,0,NULL,0)){
	    hostinfo[s]=NULL; break;
	  }
	  for(l=0;(h->h_aliases)[l];l++){
	    if(!regexec(*ri,(h->h_aliases)[l],0,NULL,0)){
	      hostinfo[s]=NULL; ri=ignore_reg.end(); break;
	    }
	  }
	} else if (verbose && !(toldnsfailed++))
	  cout<<"nslookup for host "<<host<<" failed"<<endl;
      } 
      h=(hostent *)hostinfo[s];
    } else 
      cerr<<"entry in table for host \""<<host<<"\" has problems"<<endl;
  }
  else{
    if((*i).second){
      h=gethostbyname(host);
    }
    else
      h=NULL;
  }
    
  return h;
}

void write_arplist(char *fname, int newhosts){
  char buf[1024];
  char *s=buf;
  char *t;
  char ch;
  int pid;
  map<char *, char *, strsort >::iterator i;
  static lastupdate_bootpdtab=0;
  static lastupdate_ftpboot=0;

  if(newhosts){
    ofstream arplist(fname);
    if(!arplist)
      cerr<<"cannot open file "<<fname<<" for writeing"<<endl;
    else{
      if(verbose)
	cout<<"found new hosts, updating "<<fname<<endl;
      
      arplist<<"IP address       HW type     Flags       HW address            Mask     Device"<<endl;
      for(i=ip_hw.begin(); i!=ip_hw.end(); i++)
	arplist<< (*i).first<<"      dunno      02  "<<(*i).second<<endl;
    }
    if((update_boot>0)&&(lastupdate_bootpdtab+update_boot)<time(0)){
      ifstream bootptabconf(BOOTPTABCONF);
      if(!bootptabconf){
	cerr<<"cannot open file "BOOTPTABCONF" for reading, so"<<endl;
	cerr<<"cannot create requested "BOOTPTAB" file"<<endl;
	exit(1);
      }
      ofstream bootptab(BOOTPTAB);
      if(!bootptabconf){
	cerr<<"cannot open file "BOOTPTAB" for writeing."<<endl;
	cerr<<"but you requested me to update "BOOTPTAB" with -u option"<<endl;
	exit(1);
      }
      
      lastupdate_bootpdtab=time(NULL);
      if(verbose)
	cout<<"updating "BOOTPTAB<<endl;  
      //write bootpd conf file (usually in /etc/bootptab)
      bootptab<<"# Do not edit this file, it is autmaticaly generated"<<endl;
      bootptab<<"# using " BOOTPTABCONF " as a template. Please add your"<<endl;
      bootptab<<"# changes there."<<endl<<endl<<endl;
      while(bootptabconf.get(s,sizeof(buf),'\n')){
	bootptab<<s<<endl;
	bootptabconf.get(ch);
      }
      for(i=ip_hw.begin(); i!=ip_hw.end(); i++){
	for(t=buf,s=(*i).second; (*t=*s); t++,s++)
	  if(*t==':') 
	    *t='.';
	t=hostinfo[(*i).first];
	if(t>(char*)10)
	  bootptab<<t;
	else
	  bootptab<<(*i).first;
	bootptab<<":ha="<<buf<<":tc=" TCENTRY <<endl;
	
      }
      ifstream bootpdpid(BOOTPDPID);
      if(bootpdpid>>pid){
	if(verbose)
	  cout<<"Sending SIGHUP to bootpd (pid="<<pid<<")"<<endl;
	if(kill(pid,1))
	  cout<<"Error: "<<strerror(errno)
	      <<", when trying to send SIGHUP to bootpd"<<endl;
      } else
	cerr<<"could not read bootpd pid from " BOOTPDPID<<endl;
    }
  }
  

  if((!no_tftpboot_dir)&&
     (update_boot>0)&&
     (lastupdate_ftpboot+update_boot)<time(0)){
    int restart_nfsd=0;
    char d[1024],comm[1024];
    struct stat stat_buf;
    lastupdate_ftpboot=time(0);

    for(i=ip_hw.begin(); i!=ip_hw.end(); i++){
      strcpy(d,"/tftpboot/");
      strcat(d,(*i).first);
      if(stat(d,&stat_buf)){
	strcpy(comm,MKFSROOT);
	strcat(comm," ");
	strcat(comm,(*i).first);
	if(verbose)
	  cout<<"executing "<<comm<<endl;
	system(comm);
	restart_nfsd=1;
      }
    }
    if(restart_nfsd){
      // if /tftpboot/$IP never existed, then there's no problem, but
      // if the user recently deleted it (while being used by nfsd),
      // nfsd will not anymore serve the new dir. Thus:
      if(verbose)
	cout<<"new entry in /tftpboot, restarting nfsd to avoid confusion"<<endl;
      system("/etc/init.d/netstd_nfs stop >>/tmp/nrprobenet.debug");
      system("/etc/init.d/netstd_nfs start >>/tmp/nrprobenet.debug");
    }
  }
}

int parse_procarp(char *fname){
  char buf[1024];
  char buf1[1024];
  char *s=buf;
  char *host=buf1;
  char *tmph,*tmps;
  int newhosts=0;
  map<char *, char *, strsort >::iterator i;
  
  ifstream arp(fname);
  if(arp){
    arp.get(s,sizeof(buf),'\n');
    while (arp>>host){
      arp>>s;arp>>s;
      if(!strcmp(s,"0x2")){ //we've found a valid entry
	arp>>s;
	if(testhost(host)){
	  tmph=new char[strlen(host)+1];
	  tmps=new char[strlen(s)+1];
	  strcpy(tmph,host);
	  strcpy(tmps,s);
	  if((i=ip_hw.find(host))==ip_hw.end()){
	    newhosts++;
	    if(verbose)
	      cout<<"found new host: "<<tmph<<" is at "<<tmps<<endl;
	  }else{
	    char *t, *u;
	    t=(*i).first;
	    u=(*i).second;
	    if(strcmp(tmps,u)){
	      if(verbose) 
		cout<<"host "<<tmph<<" changed hw address: was at "
		    <<u<<", is now at "<<tmps<<endl;
	      newhosts++;
	    }
	    ip_hw.erase(host);
	    delete[] t;
	    delete[] u;
	  }
	  ip_hw[tmph]=tmps;
	}
      }
      // if(!strcmp(s,"0x0")) //this entry now fails to respond: remove it.
      //   if(ip_hp.find(host)!=ip_hp.end())
      //     ip_hw.erase(host);
      arp.get(s,sizeof(buf),'\n');
    }
  }
  return newhosts;
}


void  ping (int port, hostent *h){
  struct sockaddr_in *s;
  int net,l;
  s=new sockaddr_in;
  bzero((char *)s, sizeof(sockaddr_in));
  s->sin_family=AF_INET;

  memcpy((caddr_t)&s->sin_addr, h->h_addr_list[0],h->h_length);
  swab(&port,&(s->sin_port),2);
  net=socket(AF_INET, SOCK_STREAM, 0);
  /*//oh hell, this doesn't work! (So, I'll use fork+kill instead)
    struct timeval timeout;
    timeout.tv_sec=0;
    timeout.tv_usec=20000;
    
    setsockopt(net, SOL_SOCKET,SO_SNDTIMEO,timeout);
    setsockopt(net, SOL_SOCKET, SO_RCVTIMEO,timeout);
    */
  l=connect(net,(struct sockaddr *)s, sizeof (*s));
  delete s;
}

void ping_range(int interval, int checkarpinterval,
		int port,
		char *ranges){
  istrstream range(ranges,strlen(ranges));
  int l,pid,status;
  static int arpcheck=checkarpinterval;
  int low[4];
  int cur[4];
  int high[4];
  char ch;
  char hoststr[100];
  hostent *h;
  for(l=0;l<4;l++){
    low[l]=0;
    high[l]=254;
  }
  for(l=0;l<4;l++){
    range>>low[l];
    range>>ch;
    if(ch!='.')
      break;
  }
  if(ch!='-'){
    cerr<<"IP ranges should be in this format: x.x.x.x-y.y.y.y"<<endl;
    cerr<<"I could not find the \"-\" in "<<ranges<<endl;
    exit(1);
  }
  for(l=0;l<4;l++){
    range>>high[l];
    range>>ch;
    if(ch!='.')
      break;
  }

  for (cur[0]=low[0]; cur[0]<=high[0]; cur[0]++)
    for (cur[1]=low[1]; cur[1]<=high[1]; cur[1]++)
      for (cur[2]=low[2]; cur[2]<=high[2]; cur[2]++){
	for (cur[3]=low[3]; cur[3]<=high[3]; cur[3]++){
	  sprintf(hoststr,"%i.%i.%i.%i",cur[0],cur[1],cur[2],cur[3]);
	  if((h=testhost(hoststr))){
	    if (verbose)
	      cout<<"pinging host "<<hoststr<<endl;
	     if(!(pid=fork())){
	       ping(port,h);
	       exit(0);
	     }
	     sleep(interval);
	     { 
	       timeval t;
	       t.tv_usec=10000;
	       t.tv_sec=0;
	       select(0,0,0,0,&t);
	     }
	     kill(pid,9);
	     waitpid(pid,&status,0);
	     if(arpcheck--<=0){
	       int newhosts;
	       arpcheck=checkarpinterval;
	       newhosts=parse_procarp(PROCARP);
	       write_arplist(ARPLIST,newhosts);
	     }
	  }
	  else if(verbose)
	    cout<<"ignoring host "<<hoststr<<endl;
	}
	//sleep at least interval sec for each subnet,
	//to prevent eating of all CPU time if all hosts are "ignored":
	sleep(interval);
      }
}

int main(int argc, char **argv){
  int argi;
  int interval=1,port=7,count=-1;
  int checkarpinterval=4;
  compile_ignores();
  parse_procarp(ARPLIST);

  for(argi=1;argi<argc;argi++){
    if(!strcmp(argv[argi],"-h")){
      cout<<HELPSTR;
      exit(0);
    }
    if(!strcmp(argv[argi],"-v"))
      verbose=1;
    if(!strcmp(argv[argi],"-nodir"))
      no_tftpboot_dir=1;
    if(argi<argc-1){
      if(!strcmp(argv[argi],"-i")){
	argi++;
	istrstream t(argv[argi],strlen(argv[argi]));
	t>>interval;
      }
      if(!strcmp(argv[argi],"-c")){
	argi++;
	istrstream c(argv[argi],strlen(argv[argi]));
	c>>count;
      }
      if(!strcmp(argv[argi],"-p")){
	argi++;
	istrstream p(argv[argi],strlen(argv[argi]));
	p>>port;
      }
      if(!strcmp(argv[argi],"-u")){
	argi++;
	istrstream u(argv[argi],strlen(argv[argi]));
	u>>update_boot;
      }
    }
  }
  cout<<"Nrprobenet: probing with intervals of "<<interval
      <<" seconds and port"<<port<<endl;
  cout<<"for hw adreses on local network"<<endl;
  if(update_boot){
    cout<<"updating "BOOTPTAB" when new hosts are found, every "
	<<update_boot<<" seconds"<<endl;
    cout<<"and reading " PROCARP " every "<<checkarpinterval<<" pings"<<endl;
  }
  if(count>=0)
    cout<<"Making "<<count<<"sweeps through the IP range"<<endl;

  while (count){
    for(argi=1;argi<argc;argi++){
      if(argi<argc-1){
	if(!strcmp(argv[argi],"-r")){
	  ping_range(interval,checkarpinterval,port,argv[++argi]);
	}
      }
    } 
    if(count>0)
      count--;
  }
  //for(i=ip_hw.begin(); i!=ip_hw.end(); i++)
  //  cout<< (*i).first<<"="<<(*i).second<<endl;
}
