//
// Qt Example Application: menu
//
// This example demonstrates how to use menus in Qt.
//

#include "menu.h"
#include <qpopmenu.h>
#include <qapp.h>


MenuExample::MenuExample( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    QPopupMenu *file = new QPopupMenu;
    CHECK_PTR( file );
    file->insertItem( "Open",  this, SLOT(open()) );
    file->insertItem( "Close", this, SLOT(close()) );
    file->insertItem( "Exit",  qApp, SLOT(quit()) );

    QPopupMenu *edit = new QPopupMenu;
    CHECK_PTR( edit );
    int undoID = edit->insertItem( "Undo", this, SLOT(undo()) );
    int redoID = edit->insertItem( "Redo", this, SLOT(redo()) );
    edit->setItemEnabled( undoID, FALSE );
    edit->setItemEnabled( redoID, FALSE );

    QPopupMenu *help = new QPopupMenu;
    CHECK_PTR( help );
    help->insertItem( "About", this, SLOT(about()) );

    menu = new QMenuBar( this );
    CHECK_PTR( menu );
    menu->insertItem( "File", file );
    menu->insertItem( "Edit", edit );
    menu->insertItem( "Help", help );

    label = new QLabel( this );
    CHECK_PTR( label );
    label->setGeometry( 20, rect().center().y()-20, width()-40, 40 );
    label->setFrameStyle( menu->frameStyle() );
    label->setLineWidth( menu->lineWidth() );
    label->setAlignment( AlignCenter );

    connect( this,  SIGNAL(explain(const char *)),
	     label, SLOT(setText(const char *)) );

    setMinimumSize( 100, 80 );
}


void MenuExample::open()
{
    emit explain( "File/Open selected" );
}


void MenuExample::close()
{
    emit explain( "File/Close selected" );
}


void MenuExample::undo()
{
    emit explain( "Edit/Undo selected" );
}


void MenuExample::redo()
{
    emit explain( "Edit/Redo selected" );
}


void MenuExample::about()
{
    emit explain( "Help/About selected" );
}


void MenuExample::resizeEvent( QResizeEvent * )
{
    label->setGeometry( 20, rect().center().y()-20, width()-40, 40 );
}


#include "menu.moc"


int main( int argc, char ** argv )
{
    QApplication a( argc, argv );
    MenuExample m;

    a.setMainWidget( &m );
    m.show();
    return a.exec();
}
