/****************************************************************************
** $Id: qfontdta.h,v 2.0 1996/09/24 10:15:52 agulbra Exp $
**
**		      ***   INTERNAL HEADER FILE   ***
**
**		This file is NOT a part of the Qt interface!
**
*** Definition of QFontData struct
**
** Created : 941229
**
** Copyright (C) 1992-1996 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.0
** see the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the commercial version of Qt only by this comment.)
**
*****************************************************************************/

#ifndef QFONTDTA_H
#define QFONTDTA_H


struct QFontDef {				// font definition
    QString	family;
    short	pointSize;
    uint	styleHint	: 8;
    uint	charSet		: 8;
    uint	weight		: 8;
    uint	italic		: 1;
    uint	underline	: 1;
    uint	strikeOut	: 1;
    uint	fixedPitch	: 1;
    uint	hintSetByUser	: 1;
    uint	rawMode		: 1;
    uint	dirty		: 1;
};

#if defined(_WS_X11_)
struct QXFontData;
#endif

struct QFontData : QShared {
    QFontData();
   ~QFontData();
    QFontData( const QFontData & );
    QFontData  &operator=( const QFontData & );
    QFontDef	req;				// requested font
    QFontDef	act;				// actual font
    uint	exactMatch	: 1;
#if defined(_WS_WIN_)
    uint	stockFont	: 1;
#endif
    short	lineW;				// underline/strikeOut font
#if defined(_WS_WIN_) || defined(_WS_PM_)
    HANDLE	hfont;
    HANDLE	hdc;
    void       *tm;
#elif defined(_WS_X11_)
    QXFontData *xfd;
#endif
};


#endif // QFONTDTA_H
