/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** importNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ importNodeList
importNodeList_new ()
{
  importNodeList s = (importNodeList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = importNodeListBASESIZE;
  s->elements = (importNode *) 
    dmalloc (sizeof (*s->elements) * importNodeListBASESIZE);
  
  return (s);
}

static void
importNodeList_grow (importNodeList s)
{
  int i;
  importNode *newelements;

  s->nspace = importNodeListBASESIZE + s->nspace;

  newelements = (importNode *) dmalloc (sizeof (*newelements) 
					* (s->nelements + importNodeListBASESIZE));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements);
  s->elements = newelements;
}

importNodeList
importNodeList_add (importNodeList s, importNode el)
{
  if (s->nspace <= 0)
    importNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;
  return s;
}

/*@only@*/ cstring
importNodeList_unparse (importNodeList s)
{
  bool first = TRUE;
  cstring st = cstring_undefined;

  importNodeList_elements (s, current)
  {
    if (first)
      {
	st = cstring_copy (ltoken_unparse (current->val));
	first = FALSE;
      }
    else
      {
	st = message ("%q, %s", st, ltoken_unparse (current->val));
      }
  } end_importNodeList_elements;

  return st;
}

void
importNodeList_free (importNodeList s)
{
  int i;
  
  for (i = 0; i < s->nelements; i++)
    {
      importNode_free (s->elements[i]); 
    }
  
  sfree (s->elements);
  sfree (s);
}
