/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** specialClauses.h
*/

# ifndef SPECIALCLAUSES_H
# define SPECIALCLAUSES_H

typedef enum
{
  SP_USES,
  SP_DEFINES,
  SP_ALLOCATES,
  SP_RELEASES,
  SP_SETS,
  SP_ISNULL,
  SP_ISNOTNULL,
  SP_ISONLY,
  SP_ISSHARED,
  SP_ISDEPENDENT,
  SP_ISOWNED,
  SP_ISOBSERVER,
  SP_ISEXPOSED
} specialClauseKind ;

typedef enum
{
  TK_BEFORE,
  TK_AFTER,
  TK_BOTH
} stateConstraint;

abst_typedef struct
{
  stateConstraint state;
  specialClauseKind kind;
  sRefSet refs;
} *specialClause ;

typedef /*@only@*/ specialClause o_specialClause;

extern /*@unused@*/ cstring specialClause_unparse (specialClause s) /*@*/ ;

extern /*@null@*/ sRefMod 
  specialClause_getEffectFunction (specialClause cl) /*@*/ ;

extern /*@null@*/ sRefMod 
  specialClause_getReturnEffectFunction (specialClause cl) /*@*/ ;

extern /*@null@*/ sRefMod 
  specialClause_getEntryFunction (specialClause cl) /*@*/ ;

extern bool specialClause_isBefore (specialClause cl) /*@*/ ;
extern bool specialClause_isAfter (specialClause cl) /*@*/ ;

extern /*@observer@*/ sRefSet specialClause_getRefs (specialClause cl) /*@*/ ;
# define specialClause_getRefs(cl) ((cl)->refs)

abst_typedef /*@null@*/ struct
{
  int nelements;
  int nspace;
  /*@relnull@*/ /*@reldef@*/ o_specialClause *elements;
} *specialClauses ;

/*@iter specialClauses_elements (sef specialClauses x, yield exposed specialClause el); @*/
# define specialClauses_elements(x, m_el) \
   { if (!specialClauses_isUndefined(x)) \
       { int m_ind; specialClause *m_elements = &((x)->elements[0]); \
          for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
           { specialClause m_el = *(m_elements++); 

# define end_specialClauses_elements }}}

/*@iter specialClauses_preElements (sef specialClauses x, yield exposed specialClause el); @*/
# define specialClauses_preElements(x, m_el) \
   { if (!specialClauses_isUndefined(x)) \
       { int m_ind; specialClause *m_elements = &((x)->elements[0]); \
          for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
           { specialClause m_el = *(m_elements++); if (specialClause_isBefore (m_el)) { \

# define end_specialClauses_preElements }}}}

/*@iter specialClauses_postElements (sef specialClauses x, yield exposed specialClause el); @*/
# define specialClauses_postElements(x, m_el) \
   { if (!specialClauses_isUndefined(x)) \
       { int m_ind; specialClause *m_elements = &((x)->elements[0]); \
          for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
           { specialClause m_el = *(m_elements++); if (specialClause_isAfter (m_el)) { \

# define end_specialClauses_postElements }}}}

extern void specialClauses_checkAll (uentry ue) 
   /*@modifies ue, stderr@*/ ;

extern flagcode specialClause_preErrorCode (specialClause cl) /*@*/ ;
extern /*@observer@*/ cstring 
  specialClause_preErrorString (specialClause cl, sRef sr) /*@*/ ;

extern flagcode specialClause_postErrorCode (specialClause cl) /*@*/ ;
extern /*@observer@*/ cstring 
  specialClause_postErrorString (specialClause cl, sRef sr) /*@*/ ;

extern sRefTest specialClause_getPreTestFunction (specialClause cl) /*@*/ ;

extern sRefTest specialClause_getPostTestFunction (specialClause cl) /*@*/ ;
extern sRefShower specialClause_getPostTestShower (specialClause cl) /*@*/ ;

extern specialClause 
  specialClause_create (stateConstraint st, specialClauseKind k, /*@only@*/ sRefSet s) 
  /*@*/ ;

extern specialClause specialClause_createDefines (/*@only@*/ sRefSet s) /*@*/ ;
extern specialClause specialClause_createUses (/*@only@*/ sRefSet s) /*@*/ ;
extern specialClause specialClause_createAllocates (/*@only@*/ sRefSet s) /*@*/ ;
extern specialClause specialClause_createReleases (/*@only@*/ sRefSet s) /*@*/ ;
extern specialClause specialClause_createSets (/*@only@*/ sRefSet s) /*@*/ ;

/*@constant null specialClauses specialClauses_undefined@*/
# define specialClauses_undefined ((specialClauses) 0)

extern /*@falsenull@*/ bool specialClauses_isDefined (specialClauses s) /*@*/ ;
# define specialClauses_isDefined(s) ((s) != specialClauses_undefined)

extern /*@truenull@*/ bool specialClauses_isUndefined (specialClauses s) /*@*/ ;
# define specialClauses_isUndefined(s) ((s) == specialClauses_undefined)

extern /*@unused@*/ int 
  specialClauses_size (/*@sef@*/ specialClauses s) /*@*/ ;
# define specialClauses_size(s) (specialClauses_isDefined (s) ? (s)->nelements : 0)

extern cstring specialClause_unparseKind (specialClause s) /*@*/ ;

extern specialClauses
  specialClauses_add (/*@returned@*/ specialClauses s, 
		      /*@only@*/ specialClause el)  
  /*@modifies s@*/ ;

extern /*@unused@*/ cstring specialClauses_unparse (specialClauses s) /*@*/ ;
extern void specialClauses_free (/*@only@*/ specialClauses s) ;

extern /*@only@*/ specialClauses specialClauses_copy (specialClauses s) /*@*/ ;

extern cstring specialClauses_dump (specialClauses s) /*@*/ ;
extern specialClauses specialClauses_undump (char **s) /*@modifies *s@*/ ;

/*@constant int specialClausesBASESIZE;@*/
# define specialClausesBASESIZE MIDBASESIZE

extern void specialClauses_checkEqual (uentry old, uentry new) 
  /*@modifies stderr@*/ ;

# else
# error "Multiple include"
# endif


