#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

int do_drag_text(c, e, x, y, f)
tcanvas c;
tevent e;
int x, y;
int (*f)();
{
	static treenode dragnode;
	static int dragging;
	static tree dragtree;
	static int tx, ty, tw, th;
	static int newx, newy;
	static int offx, offy;
	static nodetypedata nd;
	static treetypedata td;
	static int result;
	static int notyet;
	static treenode lastnode;
	static unsigned long lasttime, thistime;

	result=0;

	if(installing)
	{
		dragging=0;
		lastnode=NULL;
		canvas_add_event_function(do_drag_text, f);
		return(1);
	}
	else if(uninstalling)
	{
		canvas_remove_event_function(do_drag_text);
		return(1);
	}
	else if(printing) printf("zdragtext\n");

	switch(tevent_type(e))
	{
		case te_mousedown:
			if(!dragging)
			{
				dragnode=(treenode)which_label(c, x, y);
				if(dragnode!=NULL)
				{
					thistime=tevent_time(e);
					if(lastnode==dragnode && thistime-lasttime<DBLCLICK)
					{
						show_node_info_frame();
						lastnode=NULL;
						result=1;
					}
					else
					{
						lasttime=thistime;
						lastnode=dragnode;
						select_by_state(NodeSel, dragnode, 0.0, e);
						if(!globals->autoformat && ndta(dragnode)->selected)
						{
							dragging=1;
							notyet=1;
							install_dragging_function(do_drag_text);
							nd=ndta(dragnode)->td;
							dragtree=tree_get_tree(dragnode);
							td=tdta(dragtree)->td;
							tx=ttext_x(nd->label);
							ty=ttext_y(nd->label);
							tw=ttext_width(nd->label);
							th=ttext_height(nd->label);
							offx=x-tx;
							offy=y-ty;
							drag_rectangle(c, tx, ty, tw, th);
						}
						result=1;
					}
				}
			}
			else
				result=1;
			break;
		case te_mouseup:
			if(dragging)
			{
				dragging=0;
				uninstall_dragging_function(do_drag_text);
				drag_rectangle(c, tx, ty, tw, th);
				if(tdta(dragtree)->type==Boxed)
				{
					newx=x-offx;
					if(newx<nodex(nd, td))
						newx=nodex(nd, td);
					newy=ty;
				}
				else
				{
					newx=x-offx;
					newy=y-offy;
				}
				if(notyet)
				{
					if(abs(newx-tx)>5 || abs(newy-ty)>5)
						notyet=0;
				}
				if(!notyet)
				{
					tx=newx;
					ty=newy;
					x=nodex(nd, td);
					y=nodey(nd, td);
					do_command(EveryNode, NULL, NULL, 0.0, 0.0,
						tx-x, ty-y, 0, 0, MoveNodeLabel);
				}
				result=1;
			}
			break;
		case te_drag:
			if(dragging)
			{
				drag_rectangle(c, tx, ty, tw, th);
				if(tdta(dragtree)->type==Boxed)
				{
					newx=x-offx;
					if(newx<nodex(nd, td))
						newx=nodex(nd, td);
					newy=ty;
				}
				else
				{
					newx=x-offx;
					newy=y-offy;
				}
				if(notyet)
				{
					if(abs(newx-tx)>5 || abs(newy-ty)>5)
						notyet=0;
				}
				if(!notyet)
				{
					tx=newx;
					ty=newy;
				}
				drag_rectangle(c, tx, ty, tw, th);
				result=1;
			}
			break;
		default:
			if(dragging)
				result=1;
			break;
	}
	return(result);
}
