#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/* infoscale.c:
 *
 * manager for handling the window that allows the user to change the
 * properties of the scale bar
 */

#include "interface.h"

#include "treedata.h"

static tframe info;
static tpanel p;
static tpchoice nm, sm, zm;
static tpmsg msg, smsg, emsg;
static tptext scale_value;
static tcolorchooser c;
static tpbutton colorb;
static tpmsg spacer;
static tpmsg fontmsg, stylemsg, sizemsg;
char s_text[50], sv_text[50];

int scale_info_pick_font(m, mi, e)
	/* change the font of the scale bar on every selected tree */
tpmenu m;
tpitem mi;
tevent e;
{
    tfont f;

	seteventloc(e);
    tfont_grey_menus(nm, sm, zm);
    f=(tfont)tfont_get_selected_font(globals->c, nm, sm, zm);
    do_command(EveryTree, NULL, f, 0.0, 0.0,
		0, 0, 0, 0, SetScaleBarFont);
    return(1);
}

scale_choose_color(red, green, blue)
	/* change the color of the scrollbar on every selected tree */
unsigned short red, green, blue;
{
	tcolor n;

	n=tcolor_new(globals->c, NULL, red, green, blue);
	do_command(EveryTree, NULL, n, 0.0, 0.0,
		0, 0, 0, 0, SetScaleBarColor);
	tcolor_hide_chooser(c);
}

int scale_show_color_chooser(b, e)
tpbutton b;
tevent e;
{
	seteventloc(e);
	tcolor_move_chooser(c, globals->ewin, globals->ex, globals->ey);
	tcolor_show_chooser(c);
}

int scale_hide_color_chooser()
{
	if(globals->depth>1)
		tcolor_hide_chooser(c);
}

int scale_info_valid_float(s)
	/* check if the scale for the scale bar is a valid floating point number */
char *s;
{
    static int i;
    static int dec;

    dec=0;
    for(i=0;s[i]!='\0';i++)
	if(isdigit(s[i]))
	    ;
	else if(s[i]=='.')
	{
	    if(!dec)
		dec++;
	    else
		break;
	}
	else
	    break;
    if(s[i]!='\0')
	return(0);
    else
	return(1);
}

int scale_info_enter_scale_value(t, e)
	/* if the user presses return or tab while editing the "scale bar value"
	 * field, this checks if the value entered is valid, and if it is,
	 * it adjusts the scale bar according to the new value
	 */
tptext t;
tevent e;
{
    char *s;
	char *newval;
    double d;
    int i;

    if(tevent_type(e)==te_keydown)
    {
		s=tevent_string(e);
		if(s[0]=='\n' || s[0]=='\r' || s[0]=='\t')
		{
			/* get the value */
			newval=tptext_get_val(t);
			if(scale_info_valid_float(newval))
			{
				/* it's a valid number, so sscan it and change the scale
				 * bar for every selected tree */
				sscanf(newval, "%lf", &d);
				if(!do_command(EveryTree, NULL, NULL, d, 0.0,
						0, 0, 0, 0, SetScaleBarValue))
					tptext_set_val(t, sv_text);
			}
			else
				/* it's invalid, so restore original value */
				tptext_set_val(t, sv_text);
			return(tptext_none);
		}
		else
			return(tptext_insert);
    }
	return(tptext_dontknow);
}

int create_scale_info_frame(parent, args)
tframe parent;
targs args;
{
	int i;

    info=tframe_new(parent, 580,100,50,50,0,1,0,
		"Treetool:Scale Bar Settings", args);
    if(info==NULL)
		return(0);
    p=tframe_dialog_panel(info);
    if(p==NULL)
		return(0);

	/* create value field */
    scale_value=tptext_new(p, 20, 20, 100, 0, NULL, NULL,
    	"Value for Scale Bar:");
    tptext_set_event_procedure(scale_value, scale_info_enter_scale_value);
	tptext_set_displayed_characters(scale_value, 15);
	spacer=(tpmsg)tpmsg_new(p, 10, 10, 0, 0, NULL, scale_value, "  ");
	/* create color button */
	colorb=tpbutton_new(p, 20, 10, 0, 0, NULL, spacer,
		"Change Color...");
	if(globals->depth>1)
		c=(tcolorchooser)tcolor_new_chooser(parent, args, scale_choose_color,
			"Choose a color for the Scale Bar");
	else
		tpbutton_disable(colorb);
	tpbutton_set_event_procedure(colorb, scale_show_color_chooser);
	spacer=(tpmsg)tpmsg_new(p, 10, 10, 0, 0, NULL, colorb, "  ");
	/* create font menus */
    msg=(tpmsg)tpmsg_new(p, 20, 0, 0, 0, NULL, spacer,
		"Scale Bar Label:");
    nm=tfont_make_name_choicemenu(p,
		70,0,0,0,NULL,msg,globals->name,scale_info_pick_font);
    sm=tfont_make_style_choicemenu(p,
		70,0,0,0,NULL,nm,globals->style,scale_info_pick_font);
    zm=tfont_make_size_choicemenu(p,
		70,0,0,0,NULL,sm,globals->size,scale_info_pick_font);
    fontmsg=tpmsg_new(p, 30, 0, 0, 0, NULL, msg, "Font:");
    stylemsg=tpmsg_new(p, 30, 0, 0, 0, NULL, nm, "Style:");
    sizemsg=tpmsg_new(p, 30, 0, 0, 0, NULL, sm, "Size:");
    tpanel_fit(p);
    tframe_fit(info);
    tframe_hide(info);
    return(1);
}

int update_scale_info_frame(t)
	/* update the frame so that the font menus, color chooser, and value
	 * field reflect the attributes of the scale bar for the given tree */
tree t;
{
    char s[50];

	/* setup font menus */
    tfont_set_selection(tdta(t)->td->pfont,nm,sm,zm);
	/* get value for value field */
    sprintf(s, "%.2f", tdta(t)->td->pv);
    strcpy(sv_text, s);
    tptext_set_val(scale_value, s);
	/* setup color chooser */
	if(globals->depth>1)
		tcolor_change_chooser_color(c, tdta(t)->td->c);
}

int show_scale_info_frame()
{
	moveframetoloc(info);
    tframe_show(info);
}

int hide_scale_info_frame()
{
    tframe_hide(info);
	if(globals->depth>1)
		tcolor_hide_chooser(c);
}

scale_busy()
{
	if(info!=NULL)
		tframe_set_busy(info);
}

scale_notbusy()
{
	if(info!=NULL)
		tframe_set_notbusy(info);
}

grey_scale_info(numtrees, clip, multi, subtrees, nodes, branches)
	/* grey items on the scale info frame that don't apply depending
	 * on the current selection */
int numtrees, clip, multi, subtrees, nodes, branches;
{
    if(branches || nodes || subtrees)
    {
		tptext_enable(scale_value);
        if(globals->depth>1)
            tpbutton_enable(colorb);
        tpchoice_enable(nm);
        tpchoice_enable(sm);
        tpchoice_enable(zm);
    }
    else
    {
		tptext_disable(scale_value);
        if(globals->depth>1)
            tpbutton_disable(colorb);
        tpchoice_disable(nm);
        tpchoice_disable(sm);
        tpchoice_disable(zm);
    }
}
