/*
 * gejimpl.c - implementation of the GE3D Java interface
 * Copyright (c) 1996,97 IICM - all rights reserved
 *
 * created: mpichler, 19960924
 *
 * changed: mpopetz, 19970121
 * changed: mpichler, 19970709
 * changed: kwagen, 19970801
 *
 * $Id: gejimpl.c,v 1.21 1997/09/15 09:37:21 apesen Exp $
 */


#ifdef __cplusplus
extern "C" {
#endif
#include "GE3D.h"
#ifdef __cplusplus
} // C++
#endif


#include "jutils.h"

#include <math.h>  /* M_PI */
#ifndef M_PI
# include <values.h>
#endif
#include <stdio.h>  /* debugging */

#ifdef macintosh
# include <vectors.h>
# include <ge3d.h>
# define M_PI _PI
# define PACKAGE iicm_ge3d_
#else
# include <ge3d/vectors.h>
# include <ge3d/ge3d.h>
#endif

/* conversion radians to degrees */
#define DEGREES(R)  ( (R) * (180 / M_PI) )

/* note: also static native functions get a "this" handle in Java */

static int texturealpha = 0;
static materialsGE3D* gejmaterial = NULL; 
static materialsGE3D* gejvertmaterial = NULL; 


/* initGE3D */
void name2(PACKAGE,GE3D_initGE3D) (struct name3(H,PACKAGE,GE3D)* handle)
{
  /* static colorRGB white = { 1, 1, 1 }; */

  ge3d_init_ ();
  gejmaterial = malloc (sizeof (materialsGE3D));
  initmtl3D (gejmaterial);
  gejvertmaterial = malloc (sizeof (materialsGE3D));
  initmtl3D (gejvertmaterial);
  /* ge3dHint (hint_lighting, 0);  / * need light sources and normal vectors for lighting */
  /* caller responsible for light sources; e.g. setHeadLight */
}

/* setDrawMode */
void name2(PACKAGE,GE3D_setDrawMode) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 mode)
{
  ge3d_setmode ((int) mode);
}

/* setBackgroundColor */
void name2(PACKAGE,GE3D_setBackgroundColor) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 rgb)
{
  /* fprintf (stderr, "background: 0x%06x\n", rgb); */
  ge3d_setbackgcolor (((rgb >> 16) & 0xff) / 255.0f, ((rgb >> 8) & 0xff) / 255.0f, (rgb & 0xff) / 255.0f);
}

/* clearScreen */
void name2(PACKAGE,GE3D_clearScreen) (struct name3(H,PACKAGE,GE3D)* handle)
{ /* why is the function to clear the window still named clearScreen here and in ge3d? ;-) */
  ge3d_clearscreen ();
}

/* hint */
void name2(PACKAGE,GE3D_hint) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 flag, jn_int32 value)
{
  ge3dHint (flag, value);
}

/* antialiasingSupport */
jn_int32 name2(PACKAGE,GE3D_antialiasingSupport) (struct name3(H,PACKAGE,GE3D)* handle)
{
  return ge3dAntialiasingSupport ();
}

/* antialiasing */
void name2(PACKAGE,GE3D_antialiasing) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 flags)
{
  ge3dAntialiasing (flags);
}


/*** transformations ***/

/* rotatef3f */
void name2(PACKAGE,GE3D_rotatef3f) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfFloat* haxis, float angle)
{
  ge3dRotate ((const vector3D*) unhand (haxis)->body, angle);  /* angle in radians */
}

/* translatefff */
void name2(PACKAGE,GE3D_translatefff) (struct name3(H,PACKAGE,GE3D)* handle, float x, float y, float z)
{
  /* fprintf (stderr, "translation [%g, %g, %g]\n", x, y, z); */
  ge3d_translate (x, y, z);
}

/* ge3dTransformMcWc */
void name2(PACKAGE,GE3D_ge3dTransformMcWc) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfFloat* hin, HArrayOfFloat* hout)
{
  ge3dTransformMcWc ((const point3D*) unhand (hin)->body, (point3D*) unhand (hout)->body);  
}


/*** matrix operations ***/

/* loadIdentity */
void name2(PACKAGE,GE3D_loadIdentity) (struct name3(H,PACKAGE,GE3D)* handle)
{
  ge3dLoadIdentity ();
}

/* pushMatrix */
void name2(PACKAGE,GE3D_pushMatrix) (struct name3(H,PACKAGE,GE3D)* handle)
{
  ge3d_push_matrix ();
}

/* pushThisMatrix */
void name2(PACKAGE,GE3D_pushThisMatrix) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfFloat* math)
{
  ge3d_push_this_matrix ((const float (*)[4]) unhand (math)->body);
}

/* popMatrix */
void name2(PACKAGE,GE3D_popMatrix) (struct name3(H,PACKAGE,GE3D)* handle)
{
  ge3d_pop_matrix ();
}

/* getMatrix */
void name2(PACKAGE,GE3D_getMatrix) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfFloat* math)
{
  ge3d_get_matrix ((float (*)[4]) unhand (math)->body);
}


/*** camera setting ***/

/* setPerspectiveCamera */
void name2(PACKAGE,GE3D_setPerspectiveCamera) (struct name3(H,PACKAGE,GE3D)* handle,
  HArrayOfFloat* position, HArrayOfFloat* axisangle, float fovy, float aspect, float hither, float yon)
{
  const point3D* pos = (const point3D*) unhand (position)->body;
  const vector3D* rotaxis = (const vector3D*) unhand (axisangle)->body;
  float rotangle = DEGREES (((const float*) rotaxis)[3]);
  fovy = DEGREES (fovy);

/*fprintf (stderr, "%% position (%g, %g, %g), rotaxis (%g, %g, %g), angle (degrees) %g\n",*/
/*pos->x, pos->y, pos->z, rotaxis->x, rotaxis->y, rotaxis->z, rotangle);*/
/*fprintf (stderr, "view angle (degrees): %g, aspect ratio: %g, hither: %g, yon: %g\n", fovy, aspect, hither, yon);*/

  ge3dCamera (cam_perspective | cam_relative, pos, rotangle, rotaxis, fovy, aspect, hither, yon);
}

/* simpleOrthoCamera */
void name2(PACKAGE,GE3D_simpleOrthoCamera) (struct name3(H,PACKAGE,GE3D)* handle, float width, float height)
{
  point3D eyepos = { 0, 0, 1 };
  point3D lookat = { 0, 0, 0 };
  /* view centered at window center */
  ge3d_ortho_cam (&eyepos, &lookat, NULL, width, height, 0, 2);
}


/*** color ***/

/* fillColor3f (fillcolor) */
void name2(PACKAGE,GE3D_fillColor3f) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfFloat* colh)
{
  const colorRGB* color = (const colorRGB*) unhand (colh)->body;
  /* fprintf (stderr, "fillcolor: (%g, %g, %g)\n", color->R, color->G, color->B); */
  ge3dFillColor (color);  /* macro */
}

/* lineColorRGBi (fillcolor) */
void name2(PACKAGE,GE3D_lineColorRGBi) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 color)
{
  /* color: 0xrrggbb */
  float r = ((color >> 16) & 0xff) / 255.0;
  float g = ((color >> 8) & 0xff) / 255.0;
  float b = (color & 0xff) / 255.0;
  ge3d_setlinecolor (r, g, b);
}

/* lineColor3f */
void name2(PACKAGE,GE3D_lineColor3f) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfFloat* colh)
{
  const colorRGB* color = (const colorRGB*) unhand (colh)->body;
  ge3dLineColor (color);
}

/* material */
void name2(PACKAGE,GE3D_material) (struct name3(H,PACKAGE,GE3D)* handle, float ambient,
  HArrayOfFloat* diffuseh, HArrayOfFloat* emissiveh, float shininess, HArrayOfFloat* specularh,
  float transparency
)
{
  colorRGB* diffuse = (colorRGB*) unhand (diffuseh)->body;
  colorRGB* specular = (colorRGB*) unhand (specularh)->body;
  colorRGB* emissive = (colorRGB*) unhand (emissiveh)->body;
  static colorRGB ambientrgb;
  static float shiny, transp;

  initRGB (ambientrgb, ambient * diffuse->R, ambient * diffuse->G, ambient * diffuse->B);
  shiny = shininess;
  transp = transparency;

  gejmaterial->num_ambient = gejmaterial->num_diffuse = gejmaterial->num_specular = 1;
  gejmaterial->num_emissive = gejmaterial->num_shininess = gejmaterial->num_transparency = 1;
  gejmaterial->num_base = 1;
  gejmaterial->rgb_base = diffuse;
  gejmaterial->rgb_ambient = &ambientrgb;
  gejmaterial->rgb_diffuse = diffuse;
  gejmaterial->rgb_specular = specular;
  gejmaterial->rgb_emissive = emissive;
  gejmaterial->val_shininess = &shiny;
  gejmaterial->val_transparency = &transp;

  ge3dMaterial (mat_front_and_back, gejmaterial);
}

/* defaultMaterial */
void name2(PACKAGE,GE3D_defaultMaterial) (struct name3(H,PACKAGE,GE3D)* handle)
{
  ge3dDefaultMaterial ();
  initmtl3D (gejmaterial);
}

/* lineStyle */
void name2(PACKAGE,GE3D_lineStyle) (struct name3(H,PACKAGE,GE3D)* handle, jn_int16 pattern)
{
  ge3d_setlinestyle (pattern);
}


/*** lighting ***/

/* activateLightSource */
void name2(PACKAGE,GE3D_activateLightSource) (struct name3(H,PACKAGE,GE3D)* handle, 
  jn_int32 index, HArrayOfFloat* colh, float intensity, HArrayOfFloat* posh, float positional
)
{ /* point/directional light source */
  const point3D* position = (const point3D*) unhand (posh)->body;
  colorRGB color = *(colorRGB*) unhand (colh)->body;
  color.R *= intensity;
  color.G *= intensity;
  color.B *= intensity;

  if (positional)
    ge3dSetLightSource ((int) index, &color, position, positional, 0);
  else  /* reverse direction to point towards light source */
  {
    point3D direction = *position;
    neg3D (direction);
    ge3dSetLightSource ((int) index, &color, &direction, positional, 0);
  }
  ge3d_switchlight ((int) index, 1);
}

/* setHeadLight */
void name2(PACKAGE,GE3D_setHeadLight) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfFloat* colh)
{
  static const vector3D vwlgtdir = { 0, 0, 1 };  /* towards camera */
  const colorRGB* color = (const colorRGB*) unhand (colh)->body;

  ge3dSetLightSource (0, color, &vwlgtdir, 0.0, 1);
  ge3d_switchlight (0, 1);  /* headlight has index 0 by convention */
}

/* deactivateLights */
void name2(PACKAGE,GE3D_deactivateLights) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 from, jn_int32 to)
{
  while (from <= to)
  {
    ge3d_switchlight (from++, 0);
  }
}


/*** texturing ***/

/* createPixelTexture */
jn_int32 name2(PACKAGE,GE3D_createPixelTexture) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfInt* datah)
{
  const int* data = (const int*) unhand (datah)->body;
  int width = data[0];
  int height = data[1];
  int format = data[2] + ge3d_int_I_BT - 1;  /* + 4 */
  int colored = (data[2] > 2);
  int index = ge3dCreateTexture (width, height, data + 3, format, 0);
  texturealpha = (data[2] == 2 || data[2] == 4);
  return colored ? -index : index;
}

/* createImageTexture */
jn_int32 name2(PACKAGE,GE3D_createImageTexture) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 width, jn_int32 height, HArrayOfInt* datah)
{
  const int* data = (const int*) unhand (datah)->body;
  int flag = 0;
  int index = ge3dCreateTexture (width, height, data, ge3d_int_ARGB_TB, &flag);
  int colored = flag & 2;
  texturealpha = flag & 1;
  return colored ? -index : index;
}

/* doTexturing */
void name2(PACKAGE,GE3D_doTexturing) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 on)
{
  ge3dDoTexturing (on);
}

/* applyTexture */
void name2(PACKAGE,GE3D_applyTexture) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 index)
{
  ge3dApplyTexture (index);
}

/* textureRepeat */
void name2(PACKAGE,GE3D_textureRepeat) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 s, jn_int32 t)
{
  ge3dTextureRepeat (s, t);
}

/* freeTexture */
void name2(PACKAGE,GE3D_freeTexture) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 index)
{
  ge3dFreeTexture (index);
}

/* textureMipmapping */
void name2(PACKAGE,GE3D_setTextureMipmapping) (struct name3(H,PACKAGE,GE3D)* handle, jn_int32 quality)
{
  ge3dTextureMipmapping (quality);
}

/* loadTextureIdentity */
void name2(PACKAGE,GE3D_loadTextureIdentity) (struct name3(H,PACKAGE,GE3D)* handle)
{
  ge3dLoadTextureIdentity ();
}

/* loadTextureMatrix */
void name2(PACKAGE,GE3D_loadTextureMatrix) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfFloat* math)
{
  ge3dLoadTextureMatrix ((const float (*)[4]) unhand (math)->body);
}

/* alphaTest */
void name2(PACKAGE,GE3D_alphaTest) (struct name3(H,PACKAGE,GE3D)* handle, float threshold)
{
  ge3dAlphaTest (threshold);
}

/* getTextureAlpha */
jn_int32 name2(PACKAGE,GE3D_getTextureAlpha) (struct name3(H,PACKAGE,GE3D)* handle)
{
  return texturealpha;
}


/*** drawing geometry ***/

/* drawCube */
void name2(PACKAGE,GE3D_drawCube) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfFloat* hmin, HArrayOfFloat* hmax)
{
  const point3D* min = (const point3D*) unhand (hmin)->body;
  const point3D* max = (const point3D*) unhand (hmax)->body;

/*fprintf (stderr, "cube ((%g, %g, %g), (%g, %g, %g))\n", min->x, min->y, min->z, max->x, max->y, max->z);*/

  ge3dCube (min, max);
}

/* drawWireCube */
void name2(PACKAGE,GE3D_drawWireCube) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfFloat* hmin, HArrayOfFloat* hmax)
{
  const point3D* min = (const point3D*) unhand (hmin)->body;
  const point3D* max = (const point3D*) unhand (hmax)->body;

  ge3dWireCube (min, max);
}

/* drawCylinder */
void name2(PACKAGE,GE3D_drawCylinder) (struct name3(H,PACKAGE,GE3D)* handle,
  float botrad, float toprad, float bottom, float height, jn_int32 parts)
{
  ge3dCylinder (botrad, toprad, bottom, height, parts);
}

/* drawFaceSet */
void name2(PACKAGE,GE3D_drawFaceSet) (struct name3(H,PACKAGE,GE3D)* handle,
  HArrayOfFloat* hverts, jn_int32 numcoordinds, HArrayOfInt* hcoordinds,
  HArrayOfFloat* hfnormals,
  HArrayOfFloat* htexcoords, jn_int32 numtexinds, HArrayOfInt* htexcoordinds,
  jn_int32 numcolor, HArrayOfFloat* hcolor, jn_int32 numcolorinds, HArrayOfInt* hcolorinds,
  jn_int32 matbinding,
  HArrayOfFloat* hnormallist, jn_int32 numnormalinds, HArrayOfInt* hnormalinds
)
{
  const point3D* verts = (const point3D*) unhand (hverts)->body;
  /* not using array sizes, because they may be larger than the used part numverts (FloatArray) */
  const int* coordinds = (const int*) unhand (hcoordinds)->body;
  const vector3D* fnormals = hfnormals ? (const vector3D*) unhand (hfnormals)->body : 0;
  const point2D* texcoords = htexcoords ? (const point2D*) unhand (htexcoords)->body : 0;
  const int* texcoordinds = htexcoordinds ? (const int*) unhand (htexcoordinds)->body : 0;
  colorRGB* color = hcolor ? (colorRGB*) unhand (hcolor)->body : 0;
  const int* colorinds = hcolorinds ? (const int*) unhand (hcolorinds)->body : 0;
  const vector3D * normallist = hnormallist ? (const vector3D*) unhand (hnormallist)->body : 0;
  const int* normalinds = hnormalinds ? (const int*) unhand (hnormalinds)->body : 0;
  /* assert: C's int is 32 bit (jn_int32 is) */

/* fprintf (stderr, "drawing faceset with %d vertex indices (%d, %d, %d, ...)\n", */
/* (int) numcoordinds, (int) coordinds[0], (int) coordinds[1], (int) coordinds[2]); */

  gejvertmaterial->num_diffuse = numcolor;
  gejvertmaterial->rgb_diffuse = color;

/* fprintf (stderr, "calling ge3dFaceSet, %d colors, %p\n", numcolor, (void*) color); */
/*if (numcolor == 5)*/
/*  fprintf (stderr, "(%g, %g, %g), (%g, %g, %g), (%g, %g, %g)\n", color[0].R, color[0].G, color[0].B,*/
/*color[1].R, color[1].G, color[1].B, color[2].R, color[2].G, color[2].B);*/

  ge3dFaceSet (
    verts, numcoordinds, coordinds,             /* vertex data */
    gejvertmaterial, matbinding, numcolorinds, colorinds,  /* materials */
    normallist, numnormalinds, normalinds,      /* vertex normals */
    fnormals,                                   /* facenormals */
    texcoords, numtexinds, texcoordinds         /* texturing */
  );

/* fprintf (stderr, "after calling ge3dFaceSet\n"); */

  if (gejmaterial->rgb_diffuse)  /* restore diffuse color */
    ge3dFillColor (gejmaterial->rgb_diffuse);
}

/* drawLineSet */
void name2(PACKAGE,GE3D_drawLineSet) (struct name3(H,PACKAGE,GE3D)* handle,
  HArrayOfFloat* hverts, jn_int32 numcoordinds, HArrayOfInt* hcoordinds,
  jn_int32 numcolor, HArrayOfFloat* hcolor, jn_int32 numcolorind, HArrayOfInt* hcolorind, jn_int32 pervertex
)
{
  const point3D* verts = (const point3D*) unhand (hverts)->body;
  const int* coordinds = (const int*) unhand (hcoordinds)->body;
  const colorRGB* color = hcolor ? (const colorRGB*) unhand (hcolor)->body : 0;
  const int* colorind = hcolorind ? (const int*) unhand (hcolorind)->body : 0;

  ge3dLineSet2 (verts, numcoordinds, coordinds, numcolor, color, numcolorind, colorind, pervertex);
}

/* drawPointSet */
void name2(PACKAGE,GE3D_drawPointSet) (struct name3(H,PACKAGE,GE3D)* handle,
  HArrayOfFloat* hverts, jn_int32 numverts, HArrayOfFloat* hcolor, jn_int32 numcolor
)
{
  const point3D* verts = (const point3D*) unhand (hverts)->body;
  const colorRGB* color = hcolor ? (const colorRGB*) unhand (hcolor)->body : 0;

  ge3dPointSet2 (verts, numverts, color, numcolor);
}

/* drawSphere */
void name2(PACKAGE,GE3D_drawSphere) (struct name3(H,PACKAGE,GE3D)* handle, float radius)
{
  ge3dSphere (radius);
}

/* drawLine2D */
void name2(PACKAGE,GE3D_drawLine2D) (struct name3(H,PACKAGE,GE3D)* handle,
  float x0, float y0, float x1, float y1)
{
  ge3d_line (x0, y0, 0.0, x1, y1, 0.0);
}

/* drawRect2D */
void name2(PACKAGE,GE3D_drawRect2D) (struct name3(H,PACKAGE,GE3D)* handle,
  float x0, float y0, float x1, float y1)
{
  ge3d_rect (x0, y0, x1, y1);
}

/* drawPolyLines2D */
void name2(PACKAGE,GE3D_drawPolyLines2D) (struct name3(H,PACKAGE,GE3D)* handle, HArrayOfFloat* hlines)
{
  ge3dPolyLines2D ((float*) unhand (hlines)->body);  /* should be (const float*) in ge3d */
}

/* drawCircle */
void name2(PACKAGE,GE3D_drawCircle) (struct name3(H,PACKAGE,GE3D)* handle, float x, float y, float r)
{
  ge3d_circle (x, y, r);  /* circle outline */
}
